/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Chiral_center_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_CHIRAL_CENTER_BASE_HPP
#define OBJECTS_MMDB1_CHIRAL_CENTER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mmdb1/Atom_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Chiral centers are atoms with tetrahedral geometry.  Chirality is defined
/// by a chiral volume involving the chiral center and 3 other atoms bonded to 
/// it.  For any coordinates assigned to atoms c, n1, n2, and n3, the vector 
/// triple product (n1-c) dot ( (n2-c) cross (n3-c) ) must have the indicated
/// sign.  The calculation assumes an orthogonal right-handed coordinate system
/// as is used for MMDB model structures.  
/// Chirality is defined for standard residues in the MMDB dictionary, but is 
/// not assigned automatically for PDB-derived nonstandard residues. If assigned
/// for nonstandard residues, the source of chirality information is described 
/// by a citation within the residue description.
class NCBI_MMDB1_EXPORT CChiral_center_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CChiral_center_Base(void);
    // destructor
    virtual ~CChiral_center_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESign {
        eSign_positive = 1,
        eSign_negative = 2
    };
    
    /// Access to ESign's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESign)(void);
    
    // types
    typedef CAtom_id TC;
    typedef CAtom_id TN1;
    typedef CAtom_id TN2;
    typedef CAtom_id TN3;
    typedef ESign TSign;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_c,
        e_n1,
        e_n2,
        e_n3,
        e_sign
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CAtom_id TC
    ///  Check whether the C data member has been assigned a value.
    bool IsSetC(void) const;
    /// Check whether it is safe or not to call GetC method.
    bool CanGetC(void) const;
    void ResetC(void);
    const TC& GetC(void) const;
    void SetC(const TC& value);
    TC& SetC(void);

    /// mandatory
    /// typedef CAtom_id TN1
    ///  Check whether the N1 data member has been assigned a value.
    bool IsSetN1(void) const;
    /// Check whether it is safe or not to call GetN1 method.
    bool CanGetN1(void) const;
    void ResetN1(void);
    const TN1& GetN1(void) const;
    void SetN1(const TN1& value);
    TN1& SetN1(void);

    /// mandatory
    /// typedef CAtom_id TN2
    ///  Check whether the N2 data member has been assigned a value.
    bool IsSetN2(void) const;
    /// Check whether it is safe or not to call GetN2 method.
    bool CanGetN2(void) const;
    void ResetN2(void);
    const TN2& GetN2(void) const;
    void SetN2(const TN2& value);
    TN2& SetN2(void);

    /// mandatory
    /// typedef CAtom_id TN3
    ///  Check whether the N3 data member has been assigned a value.
    bool IsSetN3(void) const;
    /// Check whether it is safe or not to call GetN3 method.
    bool CanGetN3(void) const;
    void ResetN3(void);
    const TN3& GetN3(void) const;
    void SetN3(const TN3& value);
    TN3& SetN3(void);

    /// mandatory
    /// typedef ESign TSign
    ///  Check whether the Sign data member has been assigned a value.
    bool IsSetSign(void) const;
    /// Check whether it is safe or not to call GetSign method.
    bool CanGetSign(void) const;
    void ResetSign(void);
    TSign GetSign(void) const;
    void SetSign(TSign value);
    TSign& SetSign(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CChiral_center_Base(const CChiral_center_Base&);
    CChiral_center_Base& operator=(const CChiral_center_Base&);

    // data
    Uint4 m_set_State[1];
    CAtom_id m_C;
    CAtom_id m_N1;
    CAtom_id m_N2;
    CAtom_id m_N3;
    ESign m_Sign;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CChiral_center_Base::IsSetC(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CChiral_center_Base::CanGetC(void) const
{
    return IsSetC();
}

inline
void CChiral_center_Base::ResetC(void)
{
    m_C = CAtom_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CChiral_center_Base::TC& CChiral_center_Base::GetC(void) const
{
    if (!CanGetC()) {
        ThrowUnassigned(0);
    }
    return m_C;
}

inline
void CChiral_center_Base::SetC(const CChiral_center_Base::TC& value)
{
    m_C = value;
    m_set_State[0] |= 0x3;
}

inline
CChiral_center_Base::TC& CChiral_center_Base::SetC(void)
{
    m_set_State[0] |= 0x1;
    return m_C;
}

inline
bool CChiral_center_Base::IsSetN1(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CChiral_center_Base::CanGetN1(void) const
{
    return IsSetN1();
}

inline
void CChiral_center_Base::ResetN1(void)
{
    m_N1 = CAtom_id(0);
    m_set_State[0] &= ~0xc;
}

inline
const CChiral_center_Base::TN1& CChiral_center_Base::GetN1(void) const
{
    if (!CanGetN1()) {
        ThrowUnassigned(1);
    }
    return m_N1;
}

inline
void CChiral_center_Base::SetN1(const CChiral_center_Base::TN1& value)
{
    m_N1 = value;
    m_set_State[0] |= 0xc;
}

inline
CChiral_center_Base::TN1& CChiral_center_Base::SetN1(void)
{
    m_set_State[0] |= 0x4;
    return m_N1;
}

inline
bool CChiral_center_Base::IsSetN2(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CChiral_center_Base::CanGetN2(void) const
{
    return IsSetN2();
}

inline
void CChiral_center_Base::ResetN2(void)
{
    m_N2 = CAtom_id(0);
    m_set_State[0] &= ~0x30;
}

inline
const CChiral_center_Base::TN2& CChiral_center_Base::GetN2(void) const
{
    if (!CanGetN2()) {
        ThrowUnassigned(2);
    }
    return m_N2;
}

inline
void CChiral_center_Base::SetN2(const CChiral_center_Base::TN2& value)
{
    m_N2 = value;
    m_set_State[0] |= 0x30;
}

inline
CChiral_center_Base::TN2& CChiral_center_Base::SetN2(void)
{
    m_set_State[0] |= 0x10;
    return m_N2;
}

inline
bool CChiral_center_Base::IsSetN3(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CChiral_center_Base::CanGetN3(void) const
{
    return IsSetN3();
}

inline
void CChiral_center_Base::ResetN3(void)
{
    m_N3 = CAtom_id(0);
    m_set_State[0] &= ~0xc0;
}

inline
const CChiral_center_Base::TN3& CChiral_center_Base::GetN3(void) const
{
    if (!CanGetN3()) {
        ThrowUnassigned(3);
    }
    return m_N3;
}

inline
void CChiral_center_Base::SetN3(const CChiral_center_Base::TN3& value)
{
    m_N3 = value;
    m_set_State[0] |= 0xc0;
}

inline
CChiral_center_Base::TN3& CChiral_center_Base::SetN3(void)
{
    m_set_State[0] |= 0x40;
    return m_N3;
}

inline
bool CChiral_center_Base::IsSetSign(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CChiral_center_Base::CanGetSign(void) const
{
    return IsSetSign();
}

inline
void CChiral_center_Base::ResetSign(void)
{
    m_Sign = (ESign)(0);
    m_set_State[0] &= ~0x300;
}

inline
CChiral_center_Base::TSign CChiral_center_Base::GetSign(void) const
{
    if (!CanGetSign()) {
        ThrowUnassigned(4);
    }
    return m_Sign;
}

inline
void CChiral_center_Base::SetSign(CChiral_center_Base::TSign value)
{
    m_Sign = value;
    m_set_State[0] |= 0x300;
}

inline
CChiral_center_Base::TSign& CChiral_center_Base::SetSign(void)
{
#ifdef _DEBUG
    if (!IsSetSign()) {
        memset(&m_Sign,UnassignedByte(),sizeof(m_Sign));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Sign;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_CHIRAL_CENTER_BASE_HPP
