/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Molinfo_field_constraint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_MOLINFO_FIELD_CONSTRAINT_BASE_HPP
#define OBJECTS_MACRO_MOLINFO_FIELD_CONSTRAINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMolinfo_field;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMolinfo_field_constraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMolinfo_field_constraint_Base(void);
    // destructor
    virtual ~CMolinfo_field_constraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMolinfo_field TField;
    typedef bool TIs_not;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field,
        e_is_not
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMolinfo_field TField
    ///  Check whether the Field data member has been assigned a value.
    bool IsSetField(void) const;
    /// Check whether it is safe or not to call GetField method.
    bool CanGetField(void) const;
    void ResetField(void);
    const TField& GetField(void) const;
    void SetField(TField& value);
    TField& SetField(void);

    /// optional with default false
    /// typedef bool TIs_not
    ///  Check whether the Is_not data member has been assigned a value.
    bool IsSetIs_not(void) const;
    /// Check whether it is safe or not to call GetIs_not method.
    bool CanGetIs_not(void) const;
    void ResetIs_not(void);
    void SetDefaultIs_not(void);
    TIs_not GetIs_not(void) const;
    void SetIs_not(TIs_not value);
    TIs_not& SetIs_not(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMolinfo_field_constraint_Base(const CMolinfo_field_constraint_Base&);
    CMolinfo_field_constraint_Base& operator=(const CMolinfo_field_constraint_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TField > m_Field;
    bool m_Is_not;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMolinfo_field_constraint_Base::IsSetField(void) const
{
    return m_Field.NotEmpty();
}

inline
bool CMolinfo_field_constraint_Base::CanGetField(void) const
{
    return true;
}

inline
const CMolinfo_field_constraint_Base::TField& CMolinfo_field_constraint_Base::GetField(void) const
{
    if ( !m_Field ) {
        const_cast<CMolinfo_field_constraint_Base*>(this)->ResetField();
    }
    return (*m_Field);
}

inline
CMolinfo_field_constraint_Base::TField& CMolinfo_field_constraint_Base::SetField(void)
{
    if ( !m_Field ) {
        ResetField();
    }
    return (*m_Field);
}

inline
bool CMolinfo_field_constraint_Base::IsSetIs_not(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMolinfo_field_constraint_Base::CanGetIs_not(void) const
{
    return true;
}

inline
void CMolinfo_field_constraint_Base::ResetIs_not(void)
{
    m_Is_not = false;
    m_set_State[0] &= ~0xc;
}

inline
void CMolinfo_field_constraint_Base::SetDefaultIs_not(void)
{
    ResetIs_not();
}

inline
CMolinfo_field_constraint_Base::TIs_not CMolinfo_field_constraint_Base::GetIs_not(void) const
{
    return m_Is_not;
}

inline
void CMolinfo_field_constraint_Base::SetIs_not(CMolinfo_field_constraint_Base::TIs_not value)
{
    m_Is_not = value;
    m_set_State[0] |= 0xc;
}

inline
CMolinfo_field_constraint_Base::TIs_not& CMolinfo_field_constraint_Base::SetIs_not(void)
{
#ifdef _DEBUG
    if (!IsSetIs_not()) {
        memset(&m_Is_not,UnassignedByte(),sizeof(m_Is_not));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Is_not;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_MOLINFO_FIELD_CONSTRAINT_BASE_HPP
