/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Molinfo_field_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_MOLINFO_FIELD_BASE_HPP
#define OBJECTS_MACRO_MOLINFO_FIELD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Completedness_type.hpp>
#include <objects/macro/Molecule_class_type.hpp>
#include <objects/macro/Molecule_type.hpp>
#include <objects/macro/Strand_type.hpp>
#include <objects/macro/Technique_type.hpp>
#include <objects/macro/Topology_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMolinfo_field_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMolinfo_field_Base(void);
    // destructor
    virtual ~CMolinfo_field_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,    ///< No variant selected
        e_Molecule,
        e_Technique,
        e_Completedness,
        e_Mol_class,
        e_Topology,
        e_Strand
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 7 ///< == e_Strand+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef EMolecule_type TMolecule;
    typedef ETechnique_type TTechnique;
    typedef ECompletedness_type TCompletedness;
    typedef EMolecule_class_type TMol_class;
    typedef ETopology_type TTopology;
    typedef EStrand_type TStrand;

    // getters
    // setters

    // typedef EMolecule_type TMolecule
    bool IsMolecule(void) const;
    TMolecule GetMolecule(void) const;
    TMolecule& SetMolecule(void);
    void SetMolecule(TMolecule value);

    // typedef ETechnique_type TTechnique
    bool IsTechnique(void) const;
    TTechnique GetTechnique(void) const;
    TTechnique& SetTechnique(void);
    void SetTechnique(TTechnique value);

    // typedef ECompletedness_type TCompletedness
    bool IsCompletedness(void) const;
    TCompletedness GetCompletedness(void) const;
    TCompletedness& SetCompletedness(void);
    void SetCompletedness(TCompletedness value);

    // typedef EMolecule_class_type TMol_class
    bool IsMol_class(void) const;
    TMol_class GetMol_class(void) const;
    TMol_class& SetMol_class(void);
    void SetMol_class(TMol_class value);

    // typedef ETopology_type TTopology
    bool IsTopology(void) const;
    TTopology GetTopology(void) const;
    TTopology& SetTopology(void);
    void SetTopology(TTopology value);

    // typedef EStrand_type TStrand
    bool IsStrand(void) const;
    TStrand GetStrand(void) const;
    TStrand& SetStrand(void);
    void SetStrand(TStrand value);


private:
    // copy constructor and assignment operator
    CMolinfo_field_Base(const CMolinfo_field_Base& );
    CMolinfo_field_Base& operator=(const CMolinfo_field_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TMolecule m_Molecule;
        TTechnique m_Technique;
        TCompletedness m_Completedness;
        TMol_class m_Mol_class;
        TTopology m_Topology;
        TStrand m_Strand;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CMolinfo_field_Base::E_Choice CMolinfo_field_Base::Which(void) const
{
    return m_choice;
}

inline
void CMolinfo_field_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMolinfo_field_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMolinfo_field_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMolinfo_field_Base::IsMolecule(void) const
{
    return m_choice == e_Molecule;
}

inline
CMolinfo_field_Base::TMolecule CMolinfo_field_Base::GetMolecule(void) const
{
    CheckSelected(e_Molecule);
    return m_Molecule;
}

inline
CMolinfo_field_Base::TMolecule& CMolinfo_field_Base::SetMolecule(void)
{
    Select(e_Molecule, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Molecule;
}

inline
void CMolinfo_field_Base::SetMolecule(CMolinfo_field_Base::TMolecule value)
{
    Select(e_Molecule, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Molecule = value;
}

inline
bool CMolinfo_field_Base::IsTechnique(void) const
{
    return m_choice == e_Technique;
}

inline
CMolinfo_field_Base::TTechnique CMolinfo_field_Base::GetTechnique(void) const
{
    CheckSelected(e_Technique);
    return m_Technique;
}

inline
CMolinfo_field_Base::TTechnique& CMolinfo_field_Base::SetTechnique(void)
{
    Select(e_Technique, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Technique;
}

inline
void CMolinfo_field_Base::SetTechnique(CMolinfo_field_Base::TTechnique value)
{
    Select(e_Technique, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Technique = value;
}

inline
bool CMolinfo_field_Base::IsCompletedness(void) const
{
    return m_choice == e_Completedness;
}

inline
CMolinfo_field_Base::TCompletedness CMolinfo_field_Base::GetCompletedness(void) const
{
    CheckSelected(e_Completedness);
    return m_Completedness;
}

inline
CMolinfo_field_Base::TCompletedness& CMolinfo_field_Base::SetCompletedness(void)
{
    Select(e_Completedness, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Completedness;
}

inline
void CMolinfo_field_Base::SetCompletedness(CMolinfo_field_Base::TCompletedness value)
{
    Select(e_Completedness, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Completedness = value;
}

inline
bool CMolinfo_field_Base::IsMol_class(void) const
{
    return m_choice == e_Mol_class;
}

inline
CMolinfo_field_Base::TMol_class CMolinfo_field_Base::GetMol_class(void) const
{
    CheckSelected(e_Mol_class);
    return m_Mol_class;
}

inline
CMolinfo_field_Base::TMol_class& CMolinfo_field_Base::SetMol_class(void)
{
    Select(e_Mol_class, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Mol_class;
}

inline
void CMolinfo_field_Base::SetMol_class(CMolinfo_field_Base::TMol_class value)
{
    Select(e_Mol_class, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Mol_class = value;
}

inline
bool CMolinfo_field_Base::IsTopology(void) const
{
    return m_choice == e_Topology;
}

inline
CMolinfo_field_Base::TTopology CMolinfo_field_Base::GetTopology(void) const
{
    CheckSelected(e_Topology);
    return m_Topology;
}

inline
CMolinfo_field_Base::TTopology& CMolinfo_field_Base::SetTopology(void)
{
    Select(e_Topology, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Topology;
}

inline
void CMolinfo_field_Base::SetTopology(CMolinfo_field_Base::TTopology value)
{
    Select(e_Topology, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Topology = value;
}

inline
bool CMolinfo_field_Base::IsStrand(void) const
{
    return m_choice == e_Strand;
}

inline
CMolinfo_field_Base::TStrand CMolinfo_field_Base::GetStrand(void) const
{
    CheckSelected(e_Strand);
    return m_Strand;
}

inline
CMolinfo_field_Base::TStrand& CMolinfo_field_Base::SetStrand(void)
{
    Select(e_Strand, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Strand;
}

inline
void CMolinfo_field_Base::SetStrand(CMolinfo_field_Base::TStrand value)
{
    Select(e_Strand, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Strand = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_MOLINFO_FIELD_BASE_HPP
