/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Field_edit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_FIELD_EDIT_BASE_HPP
#define OBJECTS_MACRO_FIELD_EDIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/macro/Field_edit_location.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CField_edit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CField_edit_Base(void);
    // destructor
    virtual ~CField_edit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TFind_txt;
    typedef string TRepl_txt;
    typedef EField_edit_location TLocation;
    typedef bool TCase_insensitive;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_find_txt,
        e_repl_txt,
        e_location,
        e_case_insensitive
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TFind_txt
    ///  Check whether the Find_txt data member has been assigned a value.
    bool IsSetFind_txt(void) const;
    /// Check whether it is safe or not to call GetFind_txt method.
    bool CanGetFind_txt(void) const;
    void ResetFind_txt(void);
    const TFind_txt& GetFind_txt(void) const;
    void SetFind_txt(const TFind_txt& value);
    void SetFind_txt(TFind_txt&& value);
    TFind_txt& SetFind_txt(void);

    /// optional
    /// typedef string TRepl_txt
    ///  Check whether the Repl_txt data member has been assigned a value.
    bool IsSetRepl_txt(void) const;
    /// Check whether it is safe or not to call GetRepl_txt method.
    bool CanGetRepl_txt(void) const;
    void ResetRepl_txt(void);
    const TRepl_txt& GetRepl_txt(void) const;
    void SetRepl_txt(const TRepl_txt& value);
    void SetRepl_txt(TRepl_txt&& value);
    TRepl_txt& SetRepl_txt(void);

    /// optional with default eField_edit_location_anywhere
    /// typedef EField_edit_location TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    void SetDefaultLocation(void);
    TLocation GetLocation(void) const;
    void SetLocation(TLocation value);
    TLocation& SetLocation(void);

    /// optional with default false
    /// typedef bool TCase_insensitive
    ///  Check whether the Case_insensitive data member has been assigned a value.
    bool IsSetCase_insensitive(void) const;
    /// Check whether it is safe or not to call GetCase_insensitive method.
    bool CanGetCase_insensitive(void) const;
    void ResetCase_insensitive(void);
    void SetDefaultCase_insensitive(void);
    TCase_insensitive GetCase_insensitive(void) const;
    void SetCase_insensitive(TCase_insensitive value);
    TCase_insensitive& SetCase_insensitive(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CField_edit_Base(const CField_edit_Base&);
    CField_edit_Base& operator=(const CField_edit_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Find_txt;
    string m_Repl_txt;
    EField_edit_location m_Location;
    bool m_Case_insensitive;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CField_edit_Base::IsSetFind_txt(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CField_edit_Base::CanGetFind_txt(void) const
{
    return IsSetFind_txt();
}

inline
const CField_edit_Base::TFind_txt& CField_edit_Base::GetFind_txt(void) const
{
    if (!CanGetFind_txt()) {
        ThrowUnassigned(0);
    }
    return m_Find_txt;
}

inline
void CField_edit_Base::SetFind_txt(const CField_edit_Base::TFind_txt& value)
{
    m_Find_txt = value;
    m_set_State[0] |= 0x3;
}

inline
void CField_edit_Base::SetFind_txt(CField_edit_Base::TFind_txt&& value)
{
    m_Find_txt = std::forward<CField_edit_Base::TFind_txt>(value);
    m_set_State[0] |= 0x3;
}

inline
CField_edit_Base::TFind_txt& CField_edit_Base::SetFind_txt(void)
{
#ifdef _DEBUG
    if (!IsSetFind_txt()) {
        m_Find_txt = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Find_txt;
}

inline
bool CField_edit_Base::IsSetRepl_txt(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CField_edit_Base::CanGetRepl_txt(void) const
{
    return IsSetRepl_txt();
}

inline
const CField_edit_Base::TRepl_txt& CField_edit_Base::GetRepl_txt(void) const
{
    if (!CanGetRepl_txt()) {
        ThrowUnassigned(1);
    }
    return m_Repl_txt;
}

inline
void CField_edit_Base::SetRepl_txt(const CField_edit_Base::TRepl_txt& value)
{
    m_Repl_txt = value;
    m_set_State[0] |= 0xc;
}

inline
void CField_edit_Base::SetRepl_txt(CField_edit_Base::TRepl_txt&& value)
{
    m_Repl_txt = std::forward<CField_edit_Base::TRepl_txt>(value);
    m_set_State[0] |= 0xc;
}

inline
CField_edit_Base::TRepl_txt& CField_edit_Base::SetRepl_txt(void)
{
#ifdef _DEBUG
    if (!IsSetRepl_txt()) {
        m_Repl_txt = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Repl_txt;
}

inline
bool CField_edit_Base::IsSetLocation(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CField_edit_Base::CanGetLocation(void) const
{
    return true;
}

inline
void CField_edit_Base::ResetLocation(void)
{
    m_Location = eField_edit_location_anywhere;
    m_set_State[0] &= ~0x30;
}

inline
void CField_edit_Base::SetDefaultLocation(void)
{
    ResetLocation();
}

inline
CField_edit_Base::TLocation CField_edit_Base::GetLocation(void) const
{
    return m_Location;
}

inline
void CField_edit_Base::SetLocation(CField_edit_Base::TLocation value)
{
    m_Location = value;
    m_set_State[0] |= 0x30;
}

inline
CField_edit_Base::TLocation& CField_edit_Base::SetLocation(void)
{
#ifdef _DEBUG
    if (!IsSetLocation()) {
        memset(&m_Location,UnassignedByte(),sizeof(m_Location));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Location;
}

inline
bool CField_edit_Base::IsSetCase_insensitive(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CField_edit_Base::CanGetCase_insensitive(void) const
{
    return true;
}

inline
void CField_edit_Base::ResetCase_insensitive(void)
{
    m_Case_insensitive = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CField_edit_Base::SetDefaultCase_insensitive(void)
{
    ResetCase_insensitive();
}

inline
CField_edit_Base::TCase_insensitive CField_edit_Base::GetCase_insensitive(void) const
{
    return m_Case_insensitive;
}

inline
void CField_edit_Base::SetCase_insensitive(CField_edit_Base::TCase_insensitive value)
{
    m_Case_insensitive = value;
    m_set_State[0] |= 0xc0;
}

inline
CField_edit_Base::TCase_insensitive& CField_edit_Base::SetCase_insensitive(void)
{
#ifdef _DEBUG
    if (!IsSetCase_insensitive()) {
        memset(&m_Case_insensitive,UnassignedByte(),sizeof(m_Case_insensitive));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Case_insensitive;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_FIELD_EDIT_BASE_HPP
