/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Edit_location_strand_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_EDIT_LOCATION_STRAND_BASE_HPP
#define OBJECTS_MACRO_EDIT_LOCATION_STRAND_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Featur_locatio_strand_from.hpp>
#include <objects/macro/Feature_location_strand_to.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CEdit_location_strand_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEdit_location_strand_Base(void);
    // destructor
    virtual ~CEdit_location_strand_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EFeature_location_strand_from TStrand_from;
    typedef EFeature_location_strand_to TStrand_to;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_strand_from,
        e_strand_to
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EFeature_location_strand_from TStrand_from
    ///  Check whether the Strand_from data member has been assigned a value.
    bool IsSetStrand_from(void) const;
    /// Check whether it is safe or not to call GetStrand_from method.
    bool CanGetStrand_from(void) const;
    void ResetStrand_from(void);
    TStrand_from GetStrand_from(void) const;
    void SetStrand_from(TStrand_from value);
    TStrand_from& SetStrand_from(void);

    /// mandatory
    /// typedef EFeature_location_strand_to TStrand_to
    ///  Check whether the Strand_to data member has been assigned a value.
    bool IsSetStrand_to(void) const;
    /// Check whether it is safe or not to call GetStrand_to method.
    bool CanGetStrand_to(void) const;
    void ResetStrand_to(void);
    TStrand_to GetStrand_to(void) const;
    void SetStrand_to(TStrand_to value);
    TStrand_to& SetStrand_to(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEdit_location_strand_Base(const CEdit_location_strand_Base&);
    CEdit_location_strand_Base& operator=(const CEdit_location_strand_Base&);

    // data
    Uint4 m_set_State[1];
    EFeature_location_strand_from m_Strand_from;
    EFeature_location_strand_to m_Strand_to;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEdit_location_strand_Base::IsSetStrand_from(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEdit_location_strand_Base::CanGetStrand_from(void) const
{
    return IsSetStrand_from();
}

inline
void CEdit_location_strand_Base::ResetStrand_from(void)
{
    m_Strand_from = (ncbi::objects::EFeature_location_strand_from)(0);
    m_set_State[0] &= ~0x3;
}

inline
CEdit_location_strand_Base::TStrand_from CEdit_location_strand_Base::GetStrand_from(void) const
{
    if (!CanGetStrand_from()) {
        ThrowUnassigned(0);
    }
    return m_Strand_from;
}

inline
void CEdit_location_strand_Base::SetStrand_from(CEdit_location_strand_Base::TStrand_from value)
{
    m_Strand_from = value;
    m_set_State[0] |= 0x3;
}

inline
CEdit_location_strand_Base::TStrand_from& CEdit_location_strand_Base::SetStrand_from(void)
{
#ifdef _DEBUG
    if (!IsSetStrand_from()) {
        memset(&m_Strand_from,UnassignedByte(),sizeof(m_Strand_from));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Strand_from;
}

inline
bool CEdit_location_strand_Base::IsSetStrand_to(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEdit_location_strand_Base::CanGetStrand_to(void) const
{
    return IsSetStrand_to();
}

inline
void CEdit_location_strand_Base::ResetStrand_to(void)
{
    m_Strand_to = (ncbi::objects::EFeature_location_strand_to)(0);
    m_set_State[0] &= ~0xc;
}

inline
CEdit_location_strand_Base::TStrand_to CEdit_location_strand_Base::GetStrand_to(void) const
{
    if (!CanGetStrand_to()) {
        ThrowUnassigned(1);
    }
    return m_Strand_to;
}

inline
void CEdit_location_strand_Base::SetStrand_to(CEdit_location_strand_Base::TStrand_to value)
{
    m_Strand_to = value;
    m_set_State[0] |= 0xc;
}

inline
CEdit_location_strand_Base::TStrand_to& CEdit_location_strand_Base::SetStrand_to(void)
{
#ifdef _DEBUG
    if (!IsSetStrand_to()) {
        memset(&m_Strand_to,UnassignedByte(),sizeof(m_Strand_to));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Strand_to;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_EDIT_LOCATION_STRAND_BASE_HPP
