/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Request_Get_Seq_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_REQUEST_GET_SEQ_ID_BASE_HPP
#define OBJECTS_ID2_ID2_REQUEST_GET_SEQ_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2_Seq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Requested sequence ID, can be any string or Seq-id.
/// This request will be replied with one or more ID2-Reply-Get-Seq-id.
class NCBI_ID2_EXPORT CID2_Request_Get_Seq_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2_Request_Get_Seq_id_Base(void);
    // destructor
    virtual ~CID2_Request_Get_Seq_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESeq_id_type {
        eSeq_id_type_any        =    0,  ///< return any qualified Seq-id
        eSeq_id_type_gi         =    1,  ///< gi is preferred
        eSeq_id_type_text       =    2,  ///< text Seq-id (accession etc) is preferred
        eSeq_id_type_general    =    4,  ///< general Seq-id is preferred
        eSeq_id_type_all        =  127,  ///< return all qualified Seq-ids of the sequence
        eSeq_id_type_label      =  128,  ///< return a sequence string label as string  in general id with db "LABEL"
        eSeq_id_type_taxid      =  256,  ///< return a sequence taxonomy ID as integer  in general id with db "TAXID"
        eSeq_id_type_hash       =  512,  ///< return a sequence hash as integer  in general id with db "HASH"
        eSeq_id_type_seq_length = 1024,  ///< return a sequence Seq-inst.length as int  in general id with db "Seq-inst.length"
        eSeq_id_type_seq_mol    = 2048  ///< return a sequence Seq-inst.mol as int  in general id with db "Seq-inst.mol"
    };
    
    /// Access to ESeq_id_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESeq_id_type)(void);
    
    // types
    typedef CID2_Seq_id TSeq_id;
    typedef int TSeq_id_type;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq_id,
        e_seq_id_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CID2_Seq_id TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    void SetSeq_id(TSeq_id& value);
    TSeq_id& SetSeq_id(void);

    /// optional with default eSeq_id_type_any
    /// typedef int TSeq_id_type
    ///  Check whether the Seq_id_type data member has been assigned a value.
    bool IsSetSeq_id_type(void) const;
    /// Check whether it is safe or not to call GetSeq_id_type method.
    bool CanGetSeq_id_type(void) const;
    void ResetSeq_id_type(void);
    void SetDefaultSeq_id_type(void);
    TSeq_id_type GetSeq_id_type(void) const;
    void SetSeq_id_type(TSeq_id_type value);
    TSeq_id_type& SetSeq_id_type(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2_Request_Get_Seq_id_Base(const CID2_Request_Get_Seq_id_Base&);
    CID2_Request_Get_Seq_id_Base& operator=(const CID2_Request_Get_Seq_id_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeq_id > m_Seq_id;
    int m_Seq_id_type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2_Request_Get_Seq_id_Base::IsSetSeq_id(void) const
{
    return m_Seq_id.NotEmpty();
}

inline
bool CID2_Request_Get_Seq_id_Base::CanGetSeq_id(void) const
{
    return true;
}

inline
const CID2_Request_Get_Seq_id_Base::TSeq_id& CID2_Request_Get_Seq_id_Base::GetSeq_id(void) const
{
    if ( !m_Seq_id ) {
        const_cast<CID2_Request_Get_Seq_id_Base*>(this)->ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
CID2_Request_Get_Seq_id_Base::TSeq_id& CID2_Request_Get_Seq_id_Base::SetSeq_id(void)
{
    if ( !m_Seq_id ) {
        ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
bool CID2_Request_Get_Seq_id_Base::IsSetSeq_id_type(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2_Request_Get_Seq_id_Base::CanGetSeq_id_type(void) const
{
    return true;
}

inline
void CID2_Request_Get_Seq_id_Base::ResetSeq_id_type(void)
{
    m_Seq_id_type = eSeq_id_type_any;
    m_set_State[0] &= ~0xc;
}

inline
void CID2_Request_Get_Seq_id_Base::SetDefaultSeq_id_type(void)
{
    ResetSeq_id_type();
}

inline
CID2_Request_Get_Seq_id_Base::TSeq_id_type CID2_Request_Get_Seq_id_Base::GetSeq_id_type(void) const
{
    return m_Seq_id_type;
}

inline
void CID2_Request_Get_Seq_id_Base::SetSeq_id_type(CID2_Request_Get_Seq_id_Base::TSeq_id_type value)
{
    m_Seq_id_type = value;
    m_set_State[0] |= 0xc;
}

inline
CID2_Request_Get_Seq_id_Base::TSeq_id_type& CID2_Request_Get_Seq_id_Base::SetSeq_id_type(void)
{
#ifdef _DEBUG
    if (!IsSetSeq_id_type()) {
        memset(&m_Seq_id_type,UnassignedByte(),sizeof(m_Seq_id_type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Seq_id_type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_REQUEST_GET_SEQ_ID_BASE_HPP
