/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_TaggedSequences_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_TAGGEDSEQUENCES_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_TAGGEDSEQUENCES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CGC_Sequence;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// GC-TaggedSequences: set of sequences in a specific role
class NCBI_GENOME_COLLECTION_EXPORT CGC_TaggedSequences_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_TaggedSequences_Base(void);
    // destructor
    virtual ~CGC_TaggedSequences_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EState {
        eState_not_set     = 0,  ///< error
        eState_placed      = 1,  ///< exist only within a replicon. placed sequences  on higher sequence
        eState_unlocalized = 2,  ///< exist only within a replicon. "random" on a  given chromosome
        eState_unplaced    = 3,  ///< exist only on primary/diploid assembly-unit.  unknown chromosome
        eState_aligned     = 4,  ///< exist only on alt-loci/patch units. List all  aligned (eg cross-placed) sequences.  (unaligned are listed as unlocalized).
        eState_bits        = 6  ///< exist only on primary/diploid unit. if need to  report low-level contigs
    };
    
    /// Access to EState's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EState)(void);
    
    // types
    typedef int TState;
    typedef list< CRef< CGC_Sequence > > TSeqs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_state,
        e_seqs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TState
    ///  Check whether the State data member has been assigned a value.
    bool IsSetState(void) const;
    /// Check whether it is safe or not to call GetState method.
    bool CanGetState(void) const;
    void ResetState(void);
    TState GetState(void) const;
    void SetState(TState value);
    TState& SetState(void);

    /// mandatory
    /// typedef list< CRef< CGC_Sequence > > TSeqs
    ///  Check whether the Seqs data member has been assigned a value.
    bool IsSetSeqs(void) const;
    /// Check whether it is safe or not to call GetSeqs method.
    bool CanGetSeqs(void) const;
    void ResetSeqs(void);
    const TSeqs& GetSeqs(void) const;
    TSeqs& SetSeqs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_TaggedSequences_Base(const CGC_TaggedSequences_Base&);
    CGC_TaggedSequences_Base& operator=(const CGC_TaggedSequences_Base&);

    // data
    Uint4 m_set_State[1];
    int m_State;
    list< CRef< CGC_Sequence > > m_Seqs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_TaggedSequences_Base::IsSetState(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_TaggedSequences_Base::CanGetState(void) const
{
    return IsSetState();
}

inline
void CGC_TaggedSequences_Base::ResetState(void)
{
    m_State = (EState)(0);
    m_set_State[0] &= ~0x3;
}

inline
CGC_TaggedSequences_Base::TState CGC_TaggedSequences_Base::GetState(void) const
{
    if (!CanGetState()) {
        ThrowUnassigned(0);
    }
    return m_State;
}

inline
void CGC_TaggedSequences_Base::SetState(CGC_TaggedSequences_Base::TState value)
{
    m_State = value;
    m_set_State[0] |= 0x3;
}

inline
CGC_TaggedSequences_Base::TState& CGC_TaggedSequences_Base::SetState(void)
{
#ifdef _DEBUG
    if (!IsSetState()) {
        memset(&m_State,UnassignedByte(),sizeof(m_State));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_State;
}

inline
bool CGC_TaggedSequences_Base::IsSetSeqs(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_TaggedSequences_Base::CanGetSeqs(void) const
{
    return true;
}

inline
const CGC_TaggedSequences_Base::TSeqs& CGC_TaggedSequences_Base::GetSeqs(void) const
{
    return m_Seqs;
}

inline
CGC_TaggedSequences_Base::TSeqs& CGC_TaggedSequences_Base::SetSeqs(void)
{
    m_set_State[0] |= 0x4;
    return m_Seqs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_TAGGEDSEQUENCES_BASE_HPP
