/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GCClient_AssembliesForSequ_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GCCLIENT_ASSEMBLIESFORSEQU_BASE_HPP
#define OBJECTS_GENOMECOLL_GCCLIENT_ASSEMBLIESFORSEQU_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CGCClient_AssemblySequenceInfo;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGCClient_AssembliesForSequences_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGCClient_AssembliesForSequences_Base(void);
    // destructor
    virtual ~CGCClient_AssembliesForSequences_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CGCClient_AssemblySequenceInfo > > TAssemblies;
    typedef list< string > TNot_found_sequences;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_assemblies,
        e_not_found_sequences
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CGCClient_AssemblySequenceInfo > > TAssemblies
    ///  Check whether the Assemblies data member has been assigned a value.
    bool IsSetAssemblies(void) const;
    /// Check whether it is safe or not to call GetAssemblies method.
    bool CanGetAssemblies(void) const;
    void ResetAssemblies(void);
    const TAssemblies& GetAssemblies(void) const;
    TAssemblies& SetAssemblies(void);

    /// optional
    /// typedef list< string > TNot_found_sequences
    ///  Check whether the Not_found_sequences data member has been assigned a value.
    bool IsSetNot_found_sequences(void) const;
    /// Check whether it is safe or not to call GetNot_found_sequences method.
    bool CanGetNot_found_sequences(void) const;
    void ResetNot_found_sequences(void);
    const TNot_found_sequences& GetNot_found_sequences(void) const;
    TNot_found_sequences& SetNot_found_sequences(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGCClient_AssembliesForSequences_Base(const CGCClient_AssembliesForSequences_Base&);
    CGCClient_AssembliesForSequences_Base& operator=(const CGCClient_AssembliesForSequences_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CGCClient_AssemblySequenceInfo > > m_Assemblies;
    list< string > m_Not_found_sequences;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGCClient_AssembliesForSequences_Base::IsSetAssemblies(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGCClient_AssembliesForSequences_Base::CanGetAssemblies(void) const
{
    return true;
}

inline
const CGCClient_AssembliesForSequences_Base::TAssemblies& CGCClient_AssembliesForSequences_Base::GetAssemblies(void) const
{
    return m_Assemblies;
}

inline
CGCClient_AssembliesForSequences_Base::TAssemblies& CGCClient_AssembliesForSequences_Base::SetAssemblies(void)
{
    m_set_State[0] |= 0x1;
    return m_Assemblies;
}

inline
bool CGCClient_AssembliesForSequences_Base::IsSetNot_found_sequences(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGCClient_AssembliesForSequences_Base::CanGetNot_found_sequences(void) const
{
    return true;
}

inline
const CGCClient_AssembliesForSequences_Base::TNot_found_sequences& CGCClient_AssembliesForSequences_Base::GetNot_found_sequences(void) const
{
    return m_Not_found_sequences;
}

inline
CGCClient_AssembliesForSequences_Base::TNot_found_sequences& CGCClient_AssembliesForSequences_Base::SetNot_found_sequences(void)
{
    m_set_State[0] |= 0x4;
    return m_Not_found_sequences;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GCCLIENT_ASSEMBLIESFORSEQU_BASE_HPP
