/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Dbtag_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'general.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENERAL_DBTAG_BASE_HPP
#define OBJECTS_GENERAL_DBTAG_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CObject_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Dbtag is generalized for tagging
/// eg. { "Social Security", str "023-79-8841" }
/// or  { "member", id 8882224 }
class NCBI_GENERAL_EXPORT CDbtag_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDbtag_Base(void);
    // destructor
    virtual ~CDbtag_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TDb;
    typedef CObject_id TTag;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_db,
        e_tag
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// name of database or system
    /// mandatory
    /// typedef string TDb
    ///  Check whether the Db data member has been assigned a value.
    bool IsSetDb(void) const;
    /// Check whether it is safe or not to call GetDb method.
    bool CanGetDb(void) const;
    void ResetDb(void);
    const TDb& GetDb(void) const;
    void SetDb(const TDb& value);
    void SetDb(TDb&& value);
    TDb& SetDb(void);

    /// appropriate tag
    /// mandatory
    /// typedef CObject_id TTag
    ///  Check whether the Tag data member has been assigned a value.
    bool IsSetTag(void) const;
    /// Check whether it is safe or not to call GetTag method.
    bool CanGetTag(void) const;
    void ResetTag(void);
    const TTag& GetTag(void) const;
    void SetTag(TTag& value);
    TTag& SetTag(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDbtag_Base(const CDbtag_Base&);
    CDbtag_Base& operator=(const CDbtag_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Db;
    CRef< TTag > m_Tag;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDbtag_Base::IsSetDb(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDbtag_Base::CanGetDb(void) const
{
    return IsSetDb();
}

inline
const CDbtag_Base::TDb& CDbtag_Base::GetDb(void) const
{
    if (!CanGetDb()) {
        ThrowUnassigned(0);
    }
    return m_Db;
}

inline
void CDbtag_Base::SetDb(const CDbtag_Base::TDb& value)
{
    m_Db = value;
    m_set_State[0] |= 0x3;
}

inline
void CDbtag_Base::SetDb(CDbtag_Base::TDb&& value)
{
    m_Db = std::forward<CDbtag_Base::TDb>(value);
    m_set_State[0] |= 0x3;
}

inline
CDbtag_Base::TDb& CDbtag_Base::SetDb(void)
{
#ifdef _DEBUG
    if (!IsSetDb()) {
        m_Db = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Db;
}

inline
bool CDbtag_Base::IsSetTag(void) const
{
    return m_Tag.NotEmpty();
}

inline
bool CDbtag_Base::CanGetTag(void) const
{
    return true;
}

inline
const CDbtag_Base::TTag& CDbtag_Base::GetTag(void) const
{
    if ( !m_Tag ) {
        const_cast<CDbtag_Base*>(this)->ResetTag();
    }
    return (*m_Tag);
}

inline
CDbtag_Base::TTag& CDbtag_Base::SetTag(void)
{
    if ( !m_Tag ) {
        ResetTag();
    }
    return (*m_Tag);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENERAL_DBTAG_BASE_HPP
