/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBAltSeqData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBSEQ_GBALTSEQDATA_BASE_HPP
#define OBJECTS_GBSEQ_GBALTSEQDATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CGBAltSeqItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBSEQ_EXPORT CGBAltSeqData_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGBAltSeqData_Base(void);
    // destructor
    virtual ~CGBAltSeqData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef list< CRef< CGBAltSeqItem > > TItems;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_items
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// e.g., contig, wgs, scaffold, cage, genome
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef list< CRef< CGBAltSeqItem > > TItems
    ///  Check whether the Items data member has been assigned a value.
    bool IsSetItems(void) const;
    /// Check whether it is safe or not to call GetItems method.
    bool CanGetItems(void) const;
    void ResetItems(void);
    const TItems& GetItems(void) const;
    TItems& SetItems(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGBAltSeqData_Base(const CGBAltSeqData_Base&);
    CGBAltSeqData_Base& operator=(const CGBAltSeqData_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    list< CRef< CGBAltSeqItem > > m_Items;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGBAltSeqData_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGBAltSeqData_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CGBAltSeqData_Base::TName& CGBAltSeqData_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CGBAltSeqData_Base::SetName(const CGBAltSeqData_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CGBAltSeqData_Base::SetName(CGBAltSeqData_Base::TName&& value)
{
    m_Name = std::forward<CGBAltSeqData_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CGBAltSeqData_Base::TName& CGBAltSeqData_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CGBAltSeqData_Base::IsSetItems(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGBAltSeqData_Base::CanGetItems(void) const
{
    return true;
}

inline
const CGBAltSeqData_Base::TItems& CGBAltSeqData_Base::GetItems(void) const
{
    return m_Items;
}

inline
CGBAltSeqData_Base::TItems& CGBAltSeqData_Base::SetItems(void)
{
    m_set_State[0] |= 0x4;
    return m_Items;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBSEQ_GBALTSEQDATA_BASE_HPP
