/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ProjectHistoryItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_PROJECTHISTORYITEM_BASE_HPP
#define OBJECTS_GBPROJ_PROJECTHISTORYITEM_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CProjectHistoryItem_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CProjectHistoryItem_Base(void);
    // destructor
    virtual ~CProjectHistoryItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TId;
    typedef CDate TDate;
    typedef string TLabel;
    typedef string TComment;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_date,
        e_label,
        e_comment
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// ID of ProjectItem referenced
    /// mandatory
    /// typedef int TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    TId GetId(void) const;
    void SetId(TId value);
    TId& SetId(void);

    /// date of modification
    /// mandatory
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// label for this item (terse description)
    /// mandatory
    /// typedef string TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(const TLabel& value);
    void SetLabel(TLabel&& value);
    TLabel& SetLabel(void);

    /// optional longer description
    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CProjectHistoryItem_Base(const CProjectHistoryItem_Base&);
    CProjectHistoryItem_Base& operator=(const CProjectHistoryItem_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Id;
    CRef< TDate > m_Date;
    string m_Label;
    string m_Comment;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CProjectHistoryItem_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CProjectHistoryItem_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CProjectHistoryItem_Base::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CProjectHistoryItem_Base::TId CProjectHistoryItem_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CProjectHistoryItem_Base::SetId(CProjectHistoryItem_Base::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CProjectHistoryItem_Base::TId& CProjectHistoryItem_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CProjectHistoryItem_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CProjectHistoryItem_Base::CanGetDate(void) const
{
    return true;
}

inline
const CProjectHistoryItem_Base::TDate& CProjectHistoryItem_Base::GetDate(void) const
{
    if ( !m_Date ) {
        const_cast<CProjectHistoryItem_Base*>(this)->ResetDate();
    }
    return (*m_Date);
}

inline
CProjectHistoryItem_Base::TDate& CProjectHistoryItem_Base::SetDate(void)
{
    if ( !m_Date ) {
        ResetDate();
    }
    return (*m_Date);
}

inline
bool CProjectHistoryItem_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CProjectHistoryItem_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CProjectHistoryItem_Base::TLabel& CProjectHistoryItem_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(2);
    }
    return m_Label;
}

inline
void CProjectHistoryItem_Base::SetLabel(const CProjectHistoryItem_Base::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0x30;
}

inline
void CProjectHistoryItem_Base::SetLabel(CProjectHistoryItem_Base::TLabel&& value)
{
    m_Label = std::forward<CProjectHistoryItem_Base::TLabel>(value);
    m_set_State[0] |= 0x30;
}

inline
CProjectHistoryItem_Base::TLabel& CProjectHistoryItem_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Label;
}

inline
bool CProjectHistoryItem_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CProjectHistoryItem_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CProjectHistoryItem_Base::TComment& CProjectHistoryItem_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(3);
    }
    return m_Comment;
}

inline
void CProjectHistoryItem_Base::SetComment(const CProjectHistoryItem_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0xc0;
}

inline
void CProjectHistoryItem_Base::SetComment(CProjectHistoryItem_Base::TComment&& value)
{
    m_Comment = std::forward<CProjectHistoryItem_Base::TComment>(value);
    m_set_State[0] |= 0xc0;
}

inline
CProjectHistoryItem_Base::TComment& CProjectHistoryItem_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Comment;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_PROJECTHISTORYITEM_BASE_HPP
