/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_get_links_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_GET_LINKS_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_GET_LINKS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/entrez2/Entrez2_link_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEntrez2_id_list;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// request links of one type
class NCBI_ENTREZ2_EXPORT CEntrez2_get_links_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_get_links_Base(void);
    // destructor
    virtual ~CEntrez2_get_links_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEntrez2_id_list TUids;
    typedef CEntrez2_link_id TLinktype;
    typedef int TMax_UIDS;
    typedef bool TCount_only;
    typedef bool TParents_persist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_uids,
        e_linktype,
        e_max_UIDS,
        e_count_only,
        e_parents_persist
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// docs to link from
    /// mandatory
    /// typedef CEntrez2_id_list TUids
    ///  Check whether the Uids data member has been assigned a value.
    bool IsSetUids(void) const;
    /// Check whether it is safe or not to call GetUids method.
    bool CanGetUids(void) const;
    void ResetUids(void);
    const TUids& GetUids(void) const;
    void SetUids(TUids& value);
    TUids& SetUids(void);

    /// type of link
    /// mandatory
    /// typedef CEntrez2_link_id TLinktype
    ///  Check whether the Linktype data member has been assigned a value.
    bool IsSetLinktype(void) const;
    /// Check whether it is safe or not to call GetLinktype method.
    bool CanGetLinktype(void) const;
    void ResetLinktype(void);
    const TLinktype& GetLinktype(void) const;
    void SetLinktype(const TLinktype& value);
    TLinktype& SetLinktype(void);

    /// maximum number of links to return
    /// optional
    /// typedef int TMax_UIDS
    ///  Check whether the Max_UIDS data member has been assigned a value.
    bool IsSetMax_UIDS(void) const;
    /// Check whether it is safe or not to call GetMax_UIDS method.
    bool CanGetMax_UIDS(void) const;
    void ResetMax_UIDS(void);
    TMax_UIDS GetMax_UIDS(void) const;
    void SetMax_UIDS(TMax_UIDS value);
    TMax_UIDS& SetMax_UIDS(void);

    /// return only the counts
    /// optional
    /// typedef bool TCount_only
    ///  Check whether the Count_only data member has been assigned a value.
    bool IsSetCount_only(void) const;
    /// Check whether it is safe or not to call GetCount_only method.
    bool CanGetCount_only(void) const;
    void ResetCount_only(void);
    TCount_only GetCount_only(void) const;
    void SetCount_only(TCount_only value);
    TCount_only& SetCount_only(void);

    /// allow original uids in list
    /// optional
    /// typedef bool TParents_persist
    ///  Check whether the Parents_persist data member has been assigned a value.
    bool IsSetParents_persist(void) const;
    /// Check whether it is safe or not to call GetParents_persist method.
    bool CanGetParents_persist(void) const;
    void ResetParents_persist(void);
    TParents_persist GetParents_persist(void) const;
    void SetParents_persist(TParents_persist value);
    TParents_persist& SetParents_persist(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_get_links_Base(const CEntrez2_get_links_Base&);
    CEntrez2_get_links_Base& operator=(const CEntrez2_get_links_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TUids > m_Uids;
    CEntrez2_link_id m_Linktype;
    int m_Max_UIDS;
    bool m_Count_only;
    bool m_Parents_persist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_get_links_Base::IsSetUids(void) const
{
    return m_Uids.NotEmpty();
}

inline
bool CEntrez2_get_links_Base::CanGetUids(void) const
{
    return true;
}

inline
const CEntrez2_get_links_Base::TUids& CEntrez2_get_links_Base::GetUids(void) const
{
    if ( !m_Uids ) {
        const_cast<CEntrez2_get_links_Base*>(this)->ResetUids();
    }
    return (*m_Uids);
}

inline
CEntrez2_get_links_Base::TUids& CEntrez2_get_links_Base::SetUids(void)
{
    if ( !m_Uids ) {
        ResetUids();
    }
    return (*m_Uids);
}

inline
bool CEntrez2_get_links_Base::IsSetLinktype(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_get_links_Base::CanGetLinktype(void) const
{
    return IsSetLinktype();
}

inline
const CEntrez2_get_links_Base::TLinktype& CEntrez2_get_links_Base::GetLinktype(void) const
{
    if (!CanGetLinktype()) {
        ThrowUnassigned(1);
    }
    return m_Linktype;
}

inline
void CEntrez2_get_links_Base::SetLinktype(const CEntrez2_get_links_Base::TLinktype& value)
{
    m_Linktype = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_get_links_Base::TLinktype& CEntrez2_get_links_Base::SetLinktype(void)
{
    m_set_State[0] |= 0x4;
    return m_Linktype;
}

inline
bool CEntrez2_get_links_Base::IsSetMax_UIDS(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_get_links_Base::CanGetMax_UIDS(void) const
{
    return IsSetMax_UIDS();
}

inline
void CEntrez2_get_links_Base::ResetMax_UIDS(void)
{
    m_Max_UIDS = 0;
    m_set_State[0] &= ~0x30;
}

inline
CEntrez2_get_links_Base::TMax_UIDS CEntrez2_get_links_Base::GetMax_UIDS(void) const
{
    if (!CanGetMax_UIDS()) {
        ThrowUnassigned(2);
    }
    return m_Max_UIDS;
}

inline
void CEntrez2_get_links_Base::SetMax_UIDS(CEntrez2_get_links_Base::TMax_UIDS value)
{
    m_Max_UIDS = value;
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_get_links_Base::TMax_UIDS& CEntrez2_get_links_Base::SetMax_UIDS(void)
{
#ifdef _DEBUG
    if (!IsSetMax_UIDS()) {
        memset(&m_Max_UIDS,UnassignedByte(),sizeof(m_Max_UIDS));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Max_UIDS;
}

inline
bool CEntrez2_get_links_Base::IsSetCount_only(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CEntrez2_get_links_Base::CanGetCount_only(void) const
{
    return IsSetCount_only();
}

inline
void CEntrez2_get_links_Base::ResetCount_only(void)
{
    m_Count_only = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CEntrez2_get_links_Base::TCount_only CEntrez2_get_links_Base::GetCount_only(void) const
{
    if (!CanGetCount_only()) {
        ThrowUnassigned(3);
    }
    return m_Count_only;
}

inline
void CEntrez2_get_links_Base::SetCount_only(CEntrez2_get_links_Base::TCount_only value)
{
    m_Count_only = value;
    m_set_State[0] |= 0xc0;
}

inline
CEntrez2_get_links_Base::TCount_only& CEntrez2_get_links_Base::SetCount_only(void)
{
#ifdef _DEBUG
    if (!IsSetCount_only()) {
        memset(&m_Count_only,UnassignedByte(),sizeof(m_Count_only));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Count_only;
}

inline
bool CEntrez2_get_links_Base::IsSetParents_persist(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CEntrez2_get_links_Base::CanGetParents_persist(void) const
{
    return IsSetParents_persist();
}

inline
void CEntrez2_get_links_Base::ResetParents_persist(void)
{
    m_Parents_persist = 0;
    m_set_State[0] &= ~0x300;
}

inline
CEntrez2_get_links_Base::TParents_persist CEntrez2_get_links_Base::GetParents_persist(void) const
{
    if (!CanGetParents_persist()) {
        ThrowUnassigned(4);
    }
    return m_Parents_persist;
}

inline
void CEntrez2_get_links_Base::SetParents_persist(CEntrez2_get_links_Base::TParents_persist value)
{
    m_Parents_persist = value;
    m_set_State[0] |= 0x300;
}

inline
CEntrez2_get_links_Base::TParents_persist& CEntrez2_get_links_Base::SetParents_persist(void)
{
#ifdef _DEBUG
    if (!IsSetParents_persist()) {
        memset(&m_Parents_persist,UnassignedByte(),sizeof(m_Parents_persist));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Parents_persist;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_GET_LINKS_BASE_HPP
