/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_boolean_element_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_BOOLEAN_ELEMENT_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_BOOLEAN_ELEMENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/entrez2/Entrez2_operator.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEntrez2_boolean_term;
class CEntrez2_id_list;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZ2_EXPORT CEntrez2_boolean_element_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_boolean_element_Base(void);
    // destructor
    virtual ~CEntrez2_boolean_element_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Str,          ///< unparsed query string
        e_Op,           ///< logical operator
        e_Term,         ///< fielded term
        e_Ids,          ///< list of UIDs - returns history key in reply
        e_Key           ///< history key for uploaded UID list or other query
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Key+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TStr;
    typedef int TOp;
    typedef CEntrez2_boolean_term TTerm;
    typedef CEntrez2_id_list TIds;
    typedef string TKey;

    // getters
    // setters

    // typedef string TStr
    bool IsStr(void) const;
    const TStr& GetStr(void) const;
    TStr& SetStr(void);
    void SetStr(const TStr& value);

    // typedef int TOp
    bool IsOp(void) const;
    TOp GetOp(void) const;
    TOp& SetOp(void);
    void SetOp(TOp value);

    // typedef CEntrez2_boolean_term TTerm
    bool IsTerm(void) const;
    const TTerm& GetTerm(void) const;
    TTerm& SetTerm(void);
    void SetTerm(TTerm& value);

    // typedef CEntrez2_id_list TIds
    bool IsIds(void) const;
    const TIds& GetIds(void) const;
    TIds& SetIds(void);
    void SetIds(TIds& value);

    // typedef string TKey
    bool IsKey(void) const;
    const TKey& GetKey(void) const;
    TKey& SetKey(void);
    void SetKey(const TKey& value);


private:
    // copy constructor and assignment operator
    CEntrez2_boolean_element_Base(const CEntrez2_boolean_element_Base& );
    CEntrez2_boolean_element_Base& operator=(const CEntrez2_boolean_element_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TOp m_Op;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CEntrez2_boolean_element_Base::E_Choice CEntrez2_boolean_element_Base::Which(void) const
{
    return m_choice;
}

inline
void CEntrez2_boolean_element_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CEntrez2_boolean_element_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CEntrez2_boolean_element_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CEntrez2_boolean_element_Base::IsStr(void) const
{
    return m_choice == e_Str;
}

inline
const CEntrez2_boolean_element_Base::TStr& CEntrez2_boolean_element_Base::GetStr(void) const
{
    CheckSelected(e_Str);
    return *m_string;
}

inline
CEntrez2_boolean_element_Base::TStr& CEntrez2_boolean_element_Base::SetStr(void)
{
    Select(e_Str, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CEntrez2_boolean_element_Base::IsOp(void) const
{
    return m_choice == e_Op;
}

inline
CEntrez2_boolean_element_Base::TOp CEntrez2_boolean_element_Base::GetOp(void) const
{
    CheckSelected(e_Op);
    return m_Op;
}

inline
CEntrez2_boolean_element_Base::TOp& CEntrez2_boolean_element_Base::SetOp(void)
{
    Select(e_Op, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Op;
}

inline
void CEntrez2_boolean_element_Base::SetOp(CEntrez2_boolean_element_Base::TOp value)
{
    Select(e_Op, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Op = value;
}

inline
bool CEntrez2_boolean_element_Base::IsTerm(void) const
{
    return m_choice == e_Term;
}

inline
bool CEntrez2_boolean_element_Base::IsIds(void) const
{
    return m_choice == e_Ids;
}

inline
bool CEntrez2_boolean_element_Base::IsKey(void) const
{
    return m_choice == e_Key;
}

inline
const CEntrez2_boolean_element_Base::TKey& CEntrez2_boolean_element_Base::GetKey(void) const
{
    CheckSelected(e_Key);
    return *m_string;
}

inline
CEntrez2_boolean_element_Base::TKey& CEntrez2_boolean_element_Base::SetKey(void)
{
    Select(e_Key, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_BOOLEAN_ELEMENT_BASE_HPP
