/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_object_location_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_OBJECT_LOCATION_BASE_HPP
#define OBJECTS_CN3D_CN3D_OBJECT_LOCATION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_id;
class CCn3d_molecule_location;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// set of locations on a particular structure object (e.g., a PDB/MMDB
/// structure), which may include multiple ranges of residues each on
/// multiple chains.
class NCBI_CN3D_EXPORT CCn3d_object_location_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_object_location_Base(void);
    // destructor
    virtual ~CCn3d_object_location_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBiostruc_id TStructure_id;
    typedef list< CRef< CCn3d_molecule_location > > TResidues;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_structure_id,
        e_residues
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CBiostruc_id TStructure_id
    ///  Check whether the Structure_id data member has been assigned a value.
    bool IsSetStructure_id(void) const;
    /// Check whether it is safe or not to call GetStructure_id method.
    bool CanGetStructure_id(void) const;
    void ResetStructure_id(void);
    const TStructure_id& GetStructure_id(void) const;
    void SetStructure_id(TStructure_id& value);
    TStructure_id& SetStructure_id(void);

    /// mandatory
    /// typedef list< CRef< CCn3d_molecule_location > > TResidues
    ///  Check whether the Residues data member has been assigned a value.
    bool IsSetResidues(void) const;
    /// Check whether it is safe or not to call GetResidues method.
    bool CanGetResidues(void) const;
    void ResetResidues(void);
    const TResidues& GetResidues(void) const;
    TResidues& SetResidues(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_object_location_Base(const CCn3d_object_location_Base&);
    CCn3d_object_location_Base& operator=(const CCn3d_object_location_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TStructure_id > m_Structure_id;
    list< CRef< CCn3d_molecule_location > > m_Residues;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_object_location_Base::IsSetStructure_id(void) const
{
    return m_Structure_id.NotEmpty();
}

inline
bool CCn3d_object_location_Base::CanGetStructure_id(void) const
{
    return true;
}

inline
const CCn3d_object_location_Base::TStructure_id& CCn3d_object_location_Base::GetStructure_id(void) const
{
    if ( !m_Structure_id ) {
        const_cast<CCn3d_object_location_Base*>(this)->ResetStructure_id();
    }
    return (*m_Structure_id);
}

inline
CCn3d_object_location_Base::TStructure_id& CCn3d_object_location_Base::SetStructure_id(void)
{
    if ( !m_Structure_id ) {
        ResetStructure_id();
    }
    return (*m_Structure_id);
}

inline
bool CCn3d_object_location_Base::IsSetResidues(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_object_location_Base::CanGetResidues(void) const
{
    return true;
}

inline
const CCn3d_object_location_Base::TResidues& CCn3d_object_location_Base::GetResidues(void) const
{
    return m_Residues;
}

inline
CCn3d_object_location_Base::TResidues& CCn3d_object_location_Base::SetResidues(void)
{
    m_set_State[0] |= 0x4;
    return m_Residues;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_OBJECT_LOCATION_BASE_HPP
