/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Global_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_GLOBAL_ID_BASE_HPP
#define OBJECTS_CDD_GLOBAL_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Cdd's should not exist without a unique accession, but alternative id's may
/// be present as well. It is conceivable that a CD which is created as a merged
/// product of two highly redundant CDs will retain the source ids in addition 
/// to its new unique id
/// database the object resides in
/// currently not in use
class NCBI_CDD_EXPORT CGlobal_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGlobal_id_Base(void);
    // destructor
    virtual ~CGlobal_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TAccession;
    typedef string TRelease;
    typedef int TVersion;
    typedef string TDatabase;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_accession,
        e_release,
        e_version,
        e_database
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// SMART, Pfam, LOAD or CD accession
    /// mandatory
    /// typedef string TAccession
    ///  Check whether the Accession data member has been assigned a value.
    bool IsSetAccession(void) const;
    /// Check whether it is safe or not to call GetAccession method.
    bool CanGetAccession(void) const;
    void ResetAccession(void);
    const TAccession& GetAccession(void) const;
    void SetAccession(const TAccession& value);
    void SetAccession(TAccession&& value);
    TAccession& SetAccession(void);

    /// to hold CD-Database release number
    /// if desired, currently not used
    /// optional
    /// typedef string TRelease
    ///  Check whether the Release data member has been assigned a value.
    bool IsSetRelease(void) const;
    /// Check whether it is safe or not to call GetRelease method.
    bool CanGetRelease(void) const;
    void ResetRelease(void);
    const TRelease& GetRelease(void) const;
    void SetRelease(const TRelease& value);
    void SetRelease(TRelease&& value);
    TRelease& SetRelease(void);

    /// version 0 is the seed, version
    /// numbers increase with update/curate
    /// cycles
    /// optional
    /// typedef int TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    TVersion GetVersion(void) const;
    void SetVersion(TVersion value);
    TVersion& SetVersion(void);

    /// this is NOT the source!, rather the
    /// optional
    /// typedef string TDatabase
    ///  Check whether the Database data member has been assigned a value.
    bool IsSetDatabase(void) const;
    /// Check whether it is safe or not to call GetDatabase method.
    bool CanGetDatabase(void) const;
    void ResetDatabase(void);
    const TDatabase& GetDatabase(void) const;
    void SetDatabase(const TDatabase& value);
    void SetDatabase(TDatabase&& value);
    TDatabase& SetDatabase(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGlobal_id_Base(const CGlobal_id_Base&);
    CGlobal_id_Base& operator=(const CGlobal_id_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Accession;
    string m_Release;
    int m_Version;
    string m_Database;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGlobal_id_Base::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGlobal_id_Base::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CGlobal_id_Base::TAccession& CGlobal_id_Base::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(0);
    }
    return m_Accession;
}

inline
void CGlobal_id_Base::SetAccession(const CGlobal_id_Base::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0x3;
}

inline
void CGlobal_id_Base::SetAccession(CGlobal_id_Base::TAccession&& value)
{
    m_Accession = std::forward<CGlobal_id_Base::TAccession>(value);
    m_set_State[0] |= 0x3;
}

inline
CGlobal_id_Base::TAccession& CGlobal_id_Base::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Accession;
}

inline
bool CGlobal_id_Base::IsSetRelease(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGlobal_id_Base::CanGetRelease(void) const
{
    return IsSetRelease();
}

inline
const CGlobal_id_Base::TRelease& CGlobal_id_Base::GetRelease(void) const
{
    if (!CanGetRelease()) {
        ThrowUnassigned(1);
    }
    return m_Release;
}

inline
void CGlobal_id_Base::SetRelease(const CGlobal_id_Base::TRelease& value)
{
    m_Release = value;
    m_set_State[0] |= 0xc;
}

inline
void CGlobal_id_Base::SetRelease(CGlobal_id_Base::TRelease&& value)
{
    m_Release = std::forward<CGlobal_id_Base::TRelease>(value);
    m_set_State[0] |= 0xc;
}

inline
CGlobal_id_Base::TRelease& CGlobal_id_Base::SetRelease(void)
{
#ifdef _DEBUG
    if (!IsSetRelease()) {
        m_Release = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Release;
}

inline
bool CGlobal_id_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGlobal_id_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
void CGlobal_id_Base::ResetVersion(void)
{
    m_Version = 0;
    m_set_State[0] &= ~0x30;
}

inline
CGlobal_id_Base::TVersion CGlobal_id_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(2);
    }
    return m_Version;
}

inline
void CGlobal_id_Base::SetVersion(CGlobal_id_Base::TVersion value)
{
    m_Version = value;
    m_set_State[0] |= 0x30;
}

inline
CGlobal_id_Base::TVersion& CGlobal_id_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        memset(&m_Version,UnassignedByte(),sizeof(m_Version));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Version;
}

inline
bool CGlobal_id_Base::IsSetDatabase(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGlobal_id_Base::CanGetDatabase(void) const
{
    return IsSetDatabase();
}

inline
const CGlobal_id_Base::TDatabase& CGlobal_id_Base::GetDatabase(void) const
{
    if (!CanGetDatabase()) {
        ThrowUnassigned(3);
    }
    return m_Database;
}

inline
void CGlobal_id_Base::SetDatabase(const CGlobal_id_Base::TDatabase& value)
{
    m_Database = value;
    m_set_State[0] |= 0xc0;
}

inline
void CGlobal_id_Base::SetDatabase(CGlobal_id_Base::TDatabase&& value)
{
    m_Database = std::forward<CGlobal_id_Base::TDatabase>(value);
    m_set_State[0] |= 0xc0;
}

inline
CGlobal_id_Base::TDatabase& CGlobal_id_Base::SetDatabase(void)
{
#ifdef _DEBUG
    if (!IsSetDatabase()) {
        m_Database = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Database;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_GLOBAL_ID_BASE_HPP
