/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdd_tree_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_CDD_TREE_BASE_HPP
#define OBJECTS_CDD_CDD_TREE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCdd_descr_set;
class CCdd_id;
class CCdd_id_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// the Cdd-tree stores the hierarchy of CDDs. These objects are stored separate
/// from the CDs to allow for fast retrieval and use as an 'index' into CDs
/// all the components in a CD-tree match components in the full-sized CD
/// and should be synchronized
class NCBI_CDD_EXPORT CCdd_tree_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdd_tree_Base(void);
    // destructor
    virtual ~CCdd_tree_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef CCdd_id_set TId;
    typedef CCdd_descr_set TDescription;
    typedef CCdd_id TParent;
    typedef CCdd_id_set TChildren;
    typedef CCdd_id_set TSiblings;
    typedef CCdd_id_set TNeighbors;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_id,
        e_description,
        e_parent,
        e_children,
        e_siblings,
        e_neighbors
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// short name  copied from CD
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// IDs         copied from CD
    /// mandatory
    /// typedef CCdd_id_set TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// description copied from CD
    /// optional
    /// typedef CCdd_descr_set TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(TDescription& value);
    TDescription& SetDescription(void);

    /// CD is the result of a split/merge
    /// optional
    /// typedef CCdd_id TParent
    ///  Check whether the Parent data member has been assigned a value.
    bool IsSetParent(void) const;
    /// Check whether it is safe or not to call GetParent method.
    bool CanGetParent(void) const;
    void ResetParent(void);
    const TParent& GetParent(void) const;
    void SetParent(TParent& value);
    TParent& SetParent(void);

    /// this CD has been split
    /// optional
    /// typedef CCdd_id_set TChildren
    ///  Check whether the Children data member has been assigned a value.
    bool IsSetChildren(void) const;
    /// Check whether it is safe or not to call GetChildren method.
    bool CanGetChildren(void) const;
    void ResetChildren(void);
    const TChildren& GetChildren(void) const;
    void SetChildren(TChildren& value);
    TChildren& SetChildren(void);

    /// related CDs (have common hits)
    /// optional
    /// typedef CCdd_id_set TSiblings
    ///  Check whether the Siblings data member has been assigned a value.
    bool IsSetSiblings(void) const;
    /// Check whether it is safe or not to call GetSiblings method.
    bool CanGetSiblings(void) const;
    void ResetSiblings(void);
    const TSiblings& GetSiblings(void) const;
    void SetSiblings(TSiblings& value);
    TSiblings& SetSiblings(void);

    /// co-occurring CDs (non-overlapping 
    /// hits to same sequences)
    /// optional
    /// typedef CCdd_id_set TNeighbors
    ///  Check whether the Neighbors data member has been assigned a value.
    bool IsSetNeighbors(void) const;
    /// Check whether it is safe or not to call GetNeighbors method.
    bool CanGetNeighbors(void) const;
    void ResetNeighbors(void);
    const TNeighbors& GetNeighbors(void) const;
    void SetNeighbors(TNeighbors& value);
    TNeighbors& SetNeighbors(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdd_tree_Base(const CCdd_tree_Base&);
    CCdd_tree_Base& operator=(const CCdd_tree_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    CRef< TId > m_Id;
    CRef< TDescription > m_Description;
    CRef< TParent > m_Parent;
    CRef< TChildren > m_Children;
    CRef< TSiblings > m_Siblings;
    CRef< TNeighbors > m_Neighbors;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdd_tree_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCdd_tree_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CCdd_tree_Base::TName& CCdd_tree_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CCdd_tree_Base::SetName(const CCdd_tree_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CCdd_tree_Base::SetName(CCdd_tree_Base::TName&& value)
{
    m_Name = std::forward<CCdd_tree_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CCdd_tree_Base::TName& CCdd_tree_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CCdd_tree_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CCdd_tree_Base::CanGetId(void) const
{
    return true;
}

inline
const CCdd_tree_Base::TId& CCdd_tree_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CCdd_tree_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CCdd_tree_Base::TId& CCdd_tree_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CCdd_tree_Base::IsSetDescription(void) const
{
    return m_Description.NotEmpty();
}

inline
bool CCdd_tree_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CCdd_tree_Base::TDescription& CCdd_tree_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(2);
    }
    return (*m_Description);
}

inline
bool CCdd_tree_Base::IsSetParent(void) const
{
    return m_Parent.NotEmpty();
}

inline
bool CCdd_tree_Base::CanGetParent(void) const
{
    return IsSetParent();
}

inline
const CCdd_tree_Base::TParent& CCdd_tree_Base::GetParent(void) const
{
    if (!CanGetParent()) {
        ThrowUnassigned(3);
    }
    return (*m_Parent);
}

inline
bool CCdd_tree_Base::IsSetChildren(void) const
{
    return m_Children.NotEmpty();
}

inline
bool CCdd_tree_Base::CanGetChildren(void) const
{
    return IsSetChildren();
}

inline
const CCdd_tree_Base::TChildren& CCdd_tree_Base::GetChildren(void) const
{
    if (!CanGetChildren()) {
        ThrowUnassigned(4);
    }
    return (*m_Children);
}

inline
bool CCdd_tree_Base::IsSetSiblings(void) const
{
    return m_Siblings.NotEmpty();
}

inline
bool CCdd_tree_Base::CanGetSiblings(void) const
{
    return IsSetSiblings();
}

inline
const CCdd_tree_Base::TSiblings& CCdd_tree_Base::GetSiblings(void) const
{
    if (!CanGetSiblings()) {
        ThrowUnassigned(5);
    }
    return (*m_Siblings);
}

inline
bool CCdd_tree_Base::IsSetNeighbors(void) const
{
    return m_Neighbors.NotEmpty();
}

inline
bool CCdd_tree_Base::CanGetNeighbors(void) const
{
    return IsSetNeighbors();
}

inline
const CCdd_tree_Base::TNeighbors& CCdd_tree_Base::GetNeighbors(void) const
{
    if (!CanGetNeighbors()) {
        ThrowUnassigned(6);
    }
    return (*m_Neighbors);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_CDD_TREE_BASE_HPP
