/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_def_line_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastdb.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTDB_BLAST_DEF_LINE_BASE_HPP
#define OBJECTS_BLASTDB_BLAST_DEF_LINE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTDB_EXPORT CBlast_def_line_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast_def_line_Base(void);
    // destructor
    virtual ~CBlast_def_line_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTitle;
    typedef list< CRef< CSeq_id > > TSeqid;
    typedef NCBI_NS_NCBI::TTaxId TTaxid;
    typedef list< int > TMemberships;
    typedef list< int > TLinks;
    typedef list< int > TOther_info;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_title,
        e_seqid,
        e_taxid,
        e_memberships,
        e_links,
        e_other_info
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// simple title
    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// Regular NCBI Seq-Id
    /// taxonomy id, should not be set if multiple taxids are available 
    /// (see links below)
    /// mandatory
    /// typedef list< CRef< CSeq_id > > TSeqid
    ///  Check whether the Seqid data member has been assigned a value.
    bool IsSetSeqid(void) const;
    /// Check whether it is safe or not to call GetSeqid method.
    bool CanGetSeqid(void) const;
    void ResetSeqid(void);
    const TSeqid& GetSeqid(void) const;
    TSeqid& SetSeqid(void);

    /// optional
    /// typedef NCBI_NS_NCBI::TTaxId TTaxid
    ///  Check whether the Taxid data member has been assigned a value.
    bool IsSetTaxid(void) const;
    /// Check whether it is safe or not to call GetTaxid method.
    bool CanGetTaxid(void) const;
    void ResetTaxid(void);
    TTaxid GetTaxid(void) const;
    void SetTaxid(TTaxid value);
    TTaxid& SetTaxid(void);

    /// bit arrays
    /// Repurposed to store the (multiple) taxIDs associated with WP proteins. 
    /// optional
    /// typedef list< int > TMemberships
    ///  Check whether the Memberships data member has been assigned a value.
    bool IsSetMemberships(void) const;
    /// Check whether it is safe or not to call GetMemberships method.
    bool CanGetMemberships(void) const;
    void ResetMemberships(void);
    const TMemberships& GetMemberships(void) const;
    TMemberships& SetMemberships(void);

    /// optional
    /// typedef list< int > TLinks
    ///  Check whether the Links data member has been assigned a value.
    bool IsSetLinks(void) const;
    /// Check whether it is safe or not to call GetLinks method.
    bool CanGetLinks(void) const;
    void ResetLinks(void);
    const TLinks& GetLinks(void) const;
    TLinks& SetLinks(void);

    /// In proteins this stores the PIG, in nucleotides this stores the "origin
    /// GIs" (if one sequence is described in the ASN.1 as an identical copy of
    /// another)
    /// optional
    /// typedef list< int > TOther_info
    ///  Check whether the Other_info data member has been assigned a value.
    bool IsSetOther_info(void) const;
    /// Check whether it is safe or not to call GetOther_info method.
    bool CanGetOther_info(void) const;
    void ResetOther_info(void);
    const TOther_info& GetOther_info(void) const;
    TOther_info& SetOther_info(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast_def_line_Base(const CBlast_def_line_Base&);
    CBlast_def_line_Base& operator=(const CBlast_def_line_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Title;
    list< CRef< CSeq_id > > m_Seqid;
    int m_Taxid;
    list< int > m_Memberships;
    list< int > m_Links;
    list< int > m_Other_info;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast_def_line_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast_def_line_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CBlast_def_line_Base::TTitle& CBlast_def_line_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return m_Title;
}

inline
void CBlast_def_line_Base::SetTitle(const CBlast_def_line_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x3;
}

inline
void CBlast_def_line_Base::SetTitle(CBlast_def_line_Base::TTitle&& value)
{
    m_Title = std::forward<CBlast_def_line_Base::TTitle>(value);
    m_set_State[0] |= 0x3;
}

inline
CBlast_def_line_Base::TTitle& CBlast_def_line_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Title;
}

inline
bool CBlast_def_line_Base::IsSetSeqid(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast_def_line_Base::CanGetSeqid(void) const
{
    return true;
}

inline
const CBlast_def_line_Base::TSeqid& CBlast_def_line_Base::GetSeqid(void) const
{
    return m_Seqid;
}

inline
CBlast_def_line_Base::TSeqid& CBlast_def_line_Base::SetSeqid(void)
{
    m_set_State[0] |= 0x4;
    return m_Seqid;
}

inline
bool CBlast_def_line_Base::IsSetTaxid(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast_def_line_Base::CanGetTaxid(void) const
{
    return IsSetTaxid();
}

inline
void CBlast_def_line_Base::ResetTaxid(void)
{
    m_Taxid = 0;
    m_set_State[0] &= ~0x30;
}

inline
CBlast_def_line_Base::TTaxid CBlast_def_line_Base::GetTaxid(void) const
{
    if (!CanGetTaxid()) {
        ThrowUnassigned(2);
    }
    return reinterpret_cast<const TTaxid&>(m_Taxid);
}

inline
void CBlast_def_line_Base::SetTaxid(CBlast_def_line_Base::TTaxid value)
{
    reinterpret_cast<TTaxid&>(m_Taxid) = value;
    m_set_State[0] |= 0x30;
}

inline
CBlast_def_line_Base::TTaxid& CBlast_def_line_Base::SetTaxid(void)
{
#ifdef _DEBUG
    if (!IsSetTaxid()) {
        memset(&m_Taxid,UnassignedByte(),sizeof(m_Taxid));
    }
#endif
    m_set_State[0] |= 0x10;
    return reinterpret_cast<TTaxid&>(m_Taxid);
}

inline
bool CBlast_def_line_Base::IsSetMemberships(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBlast_def_line_Base::CanGetMemberships(void) const
{
    return true;
}

inline
const CBlast_def_line_Base::TMemberships& CBlast_def_line_Base::GetMemberships(void) const
{
    return m_Memberships;
}

inline
CBlast_def_line_Base::TMemberships& CBlast_def_line_Base::SetMemberships(void)
{
    m_set_State[0] |= 0x40;
    return m_Memberships;
}

inline
bool CBlast_def_line_Base::IsSetLinks(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBlast_def_line_Base::CanGetLinks(void) const
{
    return true;
}

inline
const CBlast_def_line_Base::TLinks& CBlast_def_line_Base::GetLinks(void) const
{
    return m_Links;
}

inline
CBlast_def_line_Base::TLinks& CBlast_def_line_Base::SetLinks(void)
{
    m_set_State[0] |= 0x100;
    return m_Links;
}

inline
bool CBlast_def_line_Base::IsSetOther_info(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CBlast_def_line_Base::CanGetOther_info(void) const
{
    return true;
}

inline
const CBlast_def_line_Base::TOther_info& CBlast_def_line_Base::GetOther_info(void) const
{
    return m_Other_info;
}

inline
CBlast_def_line_Base::TOther_info& CBlast_def_line_Base::SetOther_info(void)
{
    m_set_State[0] |= 0x400;
    return m_Other_info;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTDB_BLAST_DEF_LINE_BASE_HPP
