/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cit_gen_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_CIT_GEN_BASE_HPP
#define OBJECTS_BIBLIO_CIT_GEN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/biblio/PubMedId.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAuth_list;
class CDate;
class CTitle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// NOT from ANSI, this is a catchall
class NCBI_BIBLIO_EXPORT CCit_gen_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCit_gen_Base(void);
    // destructor
    virtual ~CCit_gen_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TCit;
    typedef CAuth_list TAuthors;
    typedef NCBI_NS_NCBI::TEntrezId TMuid;
    typedef CTitle TJournal;
    typedef string TVolume;
    typedef string TIssue;
    typedef string TPages;
    typedef CDate TDate;
    typedef int TSerial_number;
    typedef string TTitle;
    typedef CPubMedId TPmid;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_cit,
        e_authors,
        e_muid,
        e_journal,
        e_volume,
        e_issue,
        e_pages,
        e_date,
        e_serial_number,
        e_title,
        e_pmid
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;

    // getters
    // setters

    /// anything, not parsable
    /// optional
    /// typedef string TCit
    ///  Check whether the Cit data member has been assigned a value.
    bool IsSetCit(void) const;
    /// Check whether it is safe or not to call GetCit method.
    bool CanGetCit(void) const;
    void ResetCit(void);
    const TCit& GetCit(void) const;
    void SetCit(const TCit& value);
    void SetCit(TCit&& value);
    TCit& SetCit(void);

    /// optional
    /// typedef CAuth_list TAuthors
    ///  Check whether the Authors data member has been assigned a value.
    bool IsSetAuthors(void) const;
    /// Check whether it is safe or not to call GetAuthors method.
    bool CanGetAuthors(void) const;
    void ResetAuthors(void);
    const TAuthors& GetAuthors(void) const;
    void SetAuthors(TAuthors& value);
    TAuthors& SetAuthors(void);

    /// medline uid
    /// optional
    /// typedef NCBI_NS_NCBI::TEntrezId TMuid
    ///  Check whether the Muid data member has been assigned a value.
    bool IsSetMuid(void) const;
    /// Check whether it is safe or not to call GetMuid method.
    bool CanGetMuid(void) const;
    void ResetMuid(void);
    TMuid GetMuid(void) const;
    void SetMuid(TMuid value);
    TMuid& SetMuid(void);

    /// optional
    /// typedef CTitle TJournal
    ///  Check whether the Journal data member has been assigned a value.
    bool IsSetJournal(void) const;
    /// Check whether it is safe or not to call GetJournal method.
    bool CanGetJournal(void) const;
    void ResetJournal(void);
    const TJournal& GetJournal(void) const;
    void SetJournal(TJournal& value);
    TJournal& SetJournal(void);

    /// optional
    /// typedef string TVolume
    ///  Check whether the Volume data member has been assigned a value.
    bool IsSetVolume(void) const;
    /// Check whether it is safe or not to call GetVolume method.
    bool CanGetVolume(void) const;
    void ResetVolume(void);
    const TVolume& GetVolume(void) const;
    void SetVolume(const TVolume& value);
    void SetVolume(TVolume&& value);
    TVolume& SetVolume(void);

    /// optional
    /// typedef string TIssue
    ///  Check whether the Issue data member has been assigned a value.
    bool IsSetIssue(void) const;
    /// Check whether it is safe or not to call GetIssue method.
    bool CanGetIssue(void) const;
    void ResetIssue(void);
    const TIssue& GetIssue(void) const;
    void SetIssue(const TIssue& value);
    void SetIssue(TIssue&& value);
    TIssue& SetIssue(void);

    /// optional
    /// typedef string TPages
    ///  Check whether the Pages data member has been assigned a value.
    bool IsSetPages(void) const;
    /// Check whether it is safe or not to call GetPages method.
    bool CanGetPages(void) const;
    void ResetPages(void);
    const TPages& GetPages(void) const;
    void SetPages(const TPages& value);
    void SetPages(TPages&& value);
    TPages& SetPages(void);

    /// optional
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// for GenBank style references
    /// optional
    /// typedef int TSerial_number
    ///  Check whether the Serial_number data member has been assigned a value.
    bool IsSetSerial_number(void) const;
    /// Check whether it is safe or not to call GetSerial_number method.
    bool CanGetSerial_number(void) const;
    void ResetSerial_number(void);
    TSerial_number GetSerial_number(void) const;
    void SetSerial_number(TSerial_number value);
    TSerial_number& SetSerial_number(void);

    /// eg. cit="unpublished",title="title"
    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// PubMed Id
    /// optional
    /// typedef CPubMedId TPmid
    ///  Check whether the Pmid data member has been assigned a value.
    bool IsSetPmid(void) const;
    /// Check whether it is safe or not to call GetPmid method.
    bool CanGetPmid(void) const;
    void ResetPmid(void);
    const TPmid& GetPmid(void) const;
    void SetPmid(const TPmid& value);
    TPmid& SetPmid(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCit_gen_Base(const CCit_gen_Base&);
    CCit_gen_Base& operator=(const CCit_gen_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Cit;
    CRef< TAuthors > m_Authors;
    ncbi::TIntId m_Muid;
    CRef< TJournal > m_Journal;
    string m_Volume;
    string m_Issue;
    string m_Pages;
    CRef< TDate > m_Date;
    int m_Serial_number;
    string m_Title;
    CPubMedId m_Pmid;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCit_gen_Base::IsSetCit(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCit_gen_Base::CanGetCit(void) const
{
    return IsSetCit();
}

inline
const CCit_gen_Base::TCit& CCit_gen_Base::GetCit(void) const
{
    if (!CanGetCit()) {
        ThrowUnassigned(0);
    }
    return m_Cit;
}

inline
void CCit_gen_Base::SetCit(const CCit_gen_Base::TCit& value)
{
    m_Cit = value;
    m_set_State[0] |= 0x3;
}

inline
void CCit_gen_Base::SetCit(CCit_gen_Base::TCit&& value)
{
    m_Cit = std::forward<CCit_gen_Base::TCit>(value);
    m_set_State[0] |= 0x3;
}

inline
CCit_gen_Base::TCit& CCit_gen_Base::SetCit(void)
{
#ifdef _DEBUG
    if (!IsSetCit()) {
        m_Cit = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Cit;
}

inline
bool CCit_gen_Base::IsSetAuthors(void) const
{
    return m_Authors.NotEmpty();
}

inline
bool CCit_gen_Base::CanGetAuthors(void) const
{
    return IsSetAuthors();
}

inline
const CCit_gen_Base::TAuthors& CCit_gen_Base::GetAuthors(void) const
{
    if (!CanGetAuthors()) {
        ThrowUnassigned(1);
    }
    return (*m_Authors);
}

inline
bool CCit_gen_Base::IsSetMuid(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCit_gen_Base::CanGetMuid(void) const
{
    return IsSetMuid();
}

inline
void CCit_gen_Base::ResetMuid(void)
{
    m_Muid = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCit_gen_Base::TMuid CCit_gen_Base::GetMuid(void) const
{
    if (!CanGetMuid()) {
        ThrowUnassigned(2);
    }
    return reinterpret_cast<const TMuid&>(m_Muid);
}

inline
void CCit_gen_Base::SetMuid(CCit_gen_Base::TMuid value)
{
    reinterpret_cast<TMuid&>(m_Muid) = value;
    m_set_State[0] |= 0x30;
}

inline
CCit_gen_Base::TMuid& CCit_gen_Base::SetMuid(void)
{
#ifdef _DEBUG
    if (!IsSetMuid()) {
        memset(&m_Muid,UnassignedByte(),sizeof(m_Muid));
    }
#endif
    m_set_State[0] |= 0x10;
    return reinterpret_cast<TMuid&>(m_Muid);
}

inline
bool CCit_gen_Base::IsSetJournal(void) const
{
    return m_Journal.NotEmpty();
}

inline
bool CCit_gen_Base::CanGetJournal(void) const
{
    return IsSetJournal();
}

inline
const CCit_gen_Base::TJournal& CCit_gen_Base::GetJournal(void) const
{
    if (!CanGetJournal()) {
        ThrowUnassigned(3);
    }
    return (*m_Journal);
}

inline
bool CCit_gen_Base::IsSetVolume(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCit_gen_Base::CanGetVolume(void) const
{
    return IsSetVolume();
}

inline
const CCit_gen_Base::TVolume& CCit_gen_Base::GetVolume(void) const
{
    if (!CanGetVolume()) {
        ThrowUnassigned(4);
    }
    return m_Volume;
}

inline
void CCit_gen_Base::SetVolume(const CCit_gen_Base::TVolume& value)
{
    m_Volume = value;
    m_set_State[0] |= 0x300;
}

inline
void CCit_gen_Base::SetVolume(CCit_gen_Base::TVolume&& value)
{
    m_Volume = std::forward<CCit_gen_Base::TVolume>(value);
    m_set_State[0] |= 0x300;
}

inline
CCit_gen_Base::TVolume& CCit_gen_Base::SetVolume(void)
{
#ifdef _DEBUG
    if (!IsSetVolume()) {
        m_Volume = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Volume;
}

inline
bool CCit_gen_Base::IsSetIssue(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CCit_gen_Base::CanGetIssue(void) const
{
    return IsSetIssue();
}

inline
const CCit_gen_Base::TIssue& CCit_gen_Base::GetIssue(void) const
{
    if (!CanGetIssue()) {
        ThrowUnassigned(5);
    }
    return m_Issue;
}

inline
void CCit_gen_Base::SetIssue(const CCit_gen_Base::TIssue& value)
{
    m_Issue = value;
    m_set_State[0] |= 0xc00;
}

inline
void CCit_gen_Base::SetIssue(CCit_gen_Base::TIssue&& value)
{
    m_Issue = std::forward<CCit_gen_Base::TIssue>(value);
    m_set_State[0] |= 0xc00;
}

inline
CCit_gen_Base::TIssue& CCit_gen_Base::SetIssue(void)
{
#ifdef _DEBUG
    if (!IsSetIssue()) {
        m_Issue = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Issue;
}

inline
bool CCit_gen_Base::IsSetPages(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CCit_gen_Base::CanGetPages(void) const
{
    return IsSetPages();
}

inline
const CCit_gen_Base::TPages& CCit_gen_Base::GetPages(void) const
{
    if (!CanGetPages()) {
        ThrowUnassigned(6);
    }
    return m_Pages;
}

inline
void CCit_gen_Base::SetPages(const CCit_gen_Base::TPages& value)
{
    m_Pages = value;
    m_set_State[0] |= 0x3000;
}

inline
void CCit_gen_Base::SetPages(CCit_gen_Base::TPages&& value)
{
    m_Pages = std::forward<CCit_gen_Base::TPages>(value);
    m_set_State[0] |= 0x3000;
}

inline
CCit_gen_Base::TPages& CCit_gen_Base::SetPages(void)
{
#ifdef _DEBUG
    if (!IsSetPages()) {
        m_Pages = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Pages;
}

inline
bool CCit_gen_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CCit_gen_Base::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CCit_gen_Base::TDate& CCit_gen_Base::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(7);
    }
    return (*m_Date);
}

inline
bool CCit_gen_Base::IsSetSerial_number(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CCit_gen_Base::CanGetSerial_number(void) const
{
    return IsSetSerial_number();
}

inline
void CCit_gen_Base::ResetSerial_number(void)
{
    m_Serial_number = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CCit_gen_Base::TSerial_number CCit_gen_Base::GetSerial_number(void) const
{
    if (!CanGetSerial_number()) {
        ThrowUnassigned(8);
    }
    return m_Serial_number;
}

inline
void CCit_gen_Base::SetSerial_number(CCit_gen_Base::TSerial_number value)
{
    m_Serial_number = value;
    m_set_State[0] |= 0x30000;
}

inline
CCit_gen_Base::TSerial_number& CCit_gen_Base::SetSerial_number(void)
{
#ifdef _DEBUG
    if (!IsSetSerial_number()) {
        memset(&m_Serial_number,UnassignedByte(),sizeof(m_Serial_number));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Serial_number;
}

inline
bool CCit_gen_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CCit_gen_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CCit_gen_Base::TTitle& CCit_gen_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(9);
    }
    return m_Title;
}

inline
void CCit_gen_Base::SetTitle(const CCit_gen_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CCit_gen_Base::SetTitle(CCit_gen_Base::TTitle&& value)
{
    m_Title = std::forward<CCit_gen_Base::TTitle>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CCit_gen_Base::TTitle& CCit_gen_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Title;
}

inline
bool CCit_gen_Base::IsSetPmid(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CCit_gen_Base::CanGetPmid(void) const
{
    return IsSetPmid();
}

inline
void CCit_gen_Base::ResetPmid(void)
{
    m_Pmid = CPubMedId(0);
    m_set_State[0] &= ~0x300000;
}

inline
const CCit_gen_Base::TPmid& CCit_gen_Base::GetPmid(void) const
{
    if (!CanGetPmid()) {
        ThrowUnassigned(10);
    }
    return m_Pmid;
}

inline
void CCit_gen_Base::SetPmid(const CCit_gen_Base::TPmid& value)
{
    m_Pmid = value;
    m_set_State[0] |= 0x300000;
}

inline
CCit_gen_Base::TPmid& CCit_gen_Base::SetPmid(void)
{
    m_set_State[0] |= 0x100000;
    return m_Pmid;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_CIT_GEN_BASE_HPP
