class Borges::Window < Borges::Component

  def default_style
    %^
    #window-titlebar {background-color: lightblue; margin-bottom: 10px; width: 100%; }
    #window-title { text-align: right; width: 66% }
    #window-close {text-align: right;}
    ^
  end

  def render_close_button_on(r)
    r.anchor 'close' do self.answer end
  end

  def render_content_on(r)
    r.set_attribute(:cellspacing, 0)
    r.table do
      r.element_id('window-titlebar')
      r.table_row do 
          r.element_id('window-title')
          r.table_data(@title)
          r.element_id('window-close')
          r.table_data do self.render_close_button_on(r) end
      end

      r.element_id('window-content')
      
      renderelement = @content
      if self.respond_to? :render_on
        renderelement = self
      end
      
      r.table_row_span(2) do
        r.render renderelement
      end
    end
  end
  
  def style
    if @style
      @style
    else  
      default_style
    end
  end
  
  attr_accessor :title, :content
  attr_writer :style
end

