/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ESearchResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esearch.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esearch__OBJTOOLS_EUTILS_ESEARCH_ESEARCHRESULT_BASE_HPP
#define esearch__OBJTOOLS_EUTILS_ESEARCH_ESEARCHRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_esearch_SCOPE
#  define BEGIN_esearch_SCOPE BEGIN_SCOPE(esearch)
#  define END_esearch_SCOPE END_SCOPE(esearch)
#endif
BEGIN_esearch_SCOPE // namespace esearch::


// forward declarations
class CErrorList;
class CIdList;
class CTranslationSet;
class CTranslationStack;
class CWarningList;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CESearchResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CESearchResult_Base(void);
    // destructor
    virtual ~CESearchResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_Data : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        /// Response tags 
        class NCBI_EUTILS_EXPORT C_Info : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_Info(void);
            // destructor
            ~C_Info(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            /////////////////////////////////////////////////////////////////////////////
            class NCBI_EUTILS_EXPORT C_Content : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Content(void);
                // destructor
                ~C_Content(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef NCBI_NS_STD::string TRetMax;
                typedef NCBI_NS_STD::string TRetStart;
                typedef NCBI_NS_STD::string TQueryKey;
                typedef NCBI_NS_STD::string TWebEnv;
                typedef CIdList TIdList;
                typedef CTranslationSet TTranslationSet;
                typedef CTranslationStack TTranslationStack;
                typedef NCBI_NS_STD::string TQueryTranslation;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_RetMax,
                    e_RetStart,
                    e_QueryKey,
                    e_WebEnv,
                    e_IdList,
                    e_TranslationSet,
                    e_TranslationStack,
                    e_QueryTranslation
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;
            
                // getters
                // setters
            
                /// \d+ 
                /// mandatory
                /// typedef NCBI_NS_STD::string TRetMax
                ///  Check whether the RetMax data member has been assigned a value.
                bool IsSetRetMax(void) const;
                /// Check whether it is safe or not to call GetRetMax method.
                bool CanGetRetMax(void) const;
                void ResetRetMax(void);
                const TRetMax& GetRetMax(void) const;
                void SetRetMax(const TRetMax& value);
                void SetRetMax(TRetMax&& value);
                TRetMax& SetRetMax(void);
            
                /// \d+ 
                /// mandatory
                /// typedef NCBI_NS_STD::string TRetStart
                ///  Check whether the RetStart data member has been assigned a value.
                bool IsSetRetStart(void) const;
                /// Check whether it is safe or not to call GetRetStart method.
                bool CanGetRetStart(void) const;
                void ResetRetStart(void);
                const TRetStart& GetRetStart(void) const;
                void SetRetStart(const TRetStart& value);
                void SetRetStart(TRetStart&& value);
                TRetStart& SetRetStart(void);
            
                /// \d+ 
                /// optional
                /// typedef NCBI_NS_STD::string TQueryKey
                ///  Check whether the QueryKey data member has been assigned a value.
                bool IsSetQueryKey(void) const;
                /// Check whether it is safe or not to call GetQueryKey method.
                bool CanGetQueryKey(void) const;
                void ResetQueryKey(void);
                const TQueryKey& GetQueryKey(void) const;
                void SetQueryKey(const TQueryKey& value);
                void SetQueryKey(TQueryKey&& value);
                TQueryKey& SetQueryKey(void);
            
                /// \S+ 
                /// optional
                /// typedef NCBI_NS_STD::string TWebEnv
                ///  Check whether the WebEnv data member has been assigned a value.
                bool IsSetWebEnv(void) const;
                /// Check whether it is safe or not to call GetWebEnv method.
                bool CanGetWebEnv(void) const;
                void ResetWebEnv(void);
                const TWebEnv& GetWebEnv(void) const;
                void SetWebEnv(const TWebEnv& value);
                void SetWebEnv(TWebEnv&& value);
                TWebEnv& SetWebEnv(void);
            
                /// mandatory
                /// typedef CIdList TIdList
                ///  Check whether the IdList data member has been assigned a value.
                bool IsSetIdList(void) const;
                /// Check whether it is safe or not to call GetIdList method.
                bool CanGetIdList(void) const;
                void ResetIdList(void);
                const TIdList& GetIdList(void) const;
                void SetIdList(TIdList& value);
                TIdList& SetIdList(void);
            
                /// mandatory
                /// typedef CTranslationSet TTranslationSet
                ///  Check whether the TranslationSet data member has been assigned a value.
                bool IsSetTranslationSet(void) const;
                /// Check whether it is safe or not to call GetTranslationSet method.
                bool CanGetTranslationSet(void) const;
                void ResetTranslationSet(void);
                const TTranslationSet& GetTranslationSet(void) const;
                void SetTranslationSet(TTranslationSet& value);
                TTranslationSet& SetTranslationSet(void);
            
                /// optional
                /// typedef CTranslationStack TTranslationStack
                ///  Check whether the TranslationStack data member has been assigned a value.
                bool IsSetTranslationStack(void) const;
                /// Check whether it is safe or not to call GetTranslationStack method.
                bool CanGetTranslationStack(void) const;
                void ResetTranslationStack(void);
                const TTranslationStack& GetTranslationStack(void) const;
                void SetTranslationStack(TTranslationStack& value);
                TTranslationStack& SetTranslationStack(void);
            
                /// .+ 
                /// mandatory
                /// typedef NCBI_NS_STD::string TQueryTranslation
                ///  Check whether the QueryTranslation data member has been assigned a value.
                bool IsSetQueryTranslation(void) const;
                /// Check whether it is safe or not to call GetQueryTranslation method.
                bool CanGetQueryTranslation(void) const;
                void ResetQueryTranslation(void);
                const TQueryTranslation& GetQueryTranslation(void) const;
                void SetQueryTranslation(const TQueryTranslation& value);
                void SetQueryTranslation(TQueryTranslation&& value);
                TQueryTranslation& SetQueryTranslation(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Content(const C_Content&);
                C_Content& operator=(const C_Content&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_STD::string m_RetMax;
                NCBI_NS_STD::string m_RetStart;
                NCBI_NS_STD::string m_QueryKey;
                NCBI_NS_STD::string m_WebEnv;
                NCBI_NS_NCBI::CRef< TIdList > m_IdList;
                NCBI_NS_NCBI::CRef< TTranslationSet > m_TranslationSet;
                NCBI_NS_NCBI::CRef< TTranslationStack > m_TranslationStack;
                NCBI_NS_STD::string m_QueryTranslation;
            };
            // types
            typedef NCBI_NS_STD::string TCount;
            typedef C_Content TContent;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_Count,
                e_RRQWITTQ
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// \d+ 
            /// mandatory
            /// typedef NCBI_NS_STD::string TCount
            ///  Check whether the Count data member has been assigned a value.
            bool IsSetCount(void) const;
            /// Check whether it is safe or not to call GetCount method.
            bool CanGetCount(void) const;
            void ResetCount(void);
            const TCount& GetCount(void) const;
            void SetCount(const TCount& value);
            void SetCount(TCount&& value);
            TCount& SetCount(void);
        
            /// optional
            /// typedef C_Content TContent
            ///  Check whether the Content data member has been assigned a value.
            bool IsSetContent(void) const;
            /// Check whether it is safe or not to call GetContent method.
            bool CanGetContent(void) const;
            void ResetContent(void);
            const TContent& GetContent(void) const;
            void SetContent(TContent& value);
            TContent& SetContent(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Info(const C_Info&);
            C_Info& operator=(const C_Info&);
        
            // data
            Uint4 m_set_State[1];
            NCBI_NS_STD::string m_Count;
            NCBI_NS_NCBI::CRef< TContent > m_Content;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Info,         ///< Response tags 
            e_ERROR         ///< Error message tags    .+ 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_ERROR+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef C_Info TInfo;
        typedef NCBI_NS_STD::string TERROR;
    
        // getters
        // setters
    
        // typedef C_Info TInfo
        bool IsInfo(void) const;
        const TInfo& GetInfo(void) const;
        TInfo& SetInfo(void);
        void SetInfo(TInfo& value);
    
        // typedef NCBI_NS_STD::string TERROR
        bool IsERROR(void) const;
        const TERROR& GetERROR(void) const;
        TERROR& SetERROR(void);
        void SetERROR(const TERROR& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Data TData;
    typedef CErrorList TErrorList;
    typedef CWarningList TWarningList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_CE,
        e_ErrorList,
        e_WarningList
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// optional
    /// typedef CErrorList TErrorList
    ///  Check whether the ErrorList data member has been assigned a value.
    bool IsSetErrorList(void) const;
    /// Check whether it is safe or not to call GetErrorList method.
    bool CanGetErrorList(void) const;
    void ResetErrorList(void);
    const TErrorList& GetErrorList(void) const;
    void SetErrorList(TErrorList& value);
    TErrorList& SetErrorList(void);

    /// optional
    /// typedef CWarningList TWarningList
    ///  Check whether the WarningList data member has been assigned a value.
    bool IsSetWarningList(void) const;
    /// Check whether it is safe or not to call GetWarningList method.
    bool CanGetWarningList(void) const;
    void ResetWarningList(void);
    const TWarningList& GetWarningList(void) const;
    void SetWarningList(TWarningList& value);
    TWarningList& SetWarningList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CESearchResult_Base(const CESearchResult_Base&);
    CESearchResult_Base& operator=(const CESearchResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TData > m_Data;
    NCBI_NS_NCBI::CRef< TErrorList > m_ErrorList;
    NCBI_NS_NCBI::CRef< TWarningList > m_WarningList;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetRetMax(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetRetMax(void) const
{
    return IsSetRetMax();
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TRetMax& CESearchResult_Base::C_Data::C_Info::C_Content::GetRetMax(void) const
{
    if (!CanGetRetMax()) {
        ThrowUnassigned(0);
    }
    return m_RetMax;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetRetMax(const CESearchResult_Base::C_Data::C_Info::C_Content::TRetMax& value)
{
    m_RetMax = value;
    m_set_State[0] |= 0x3;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetRetMax(CESearchResult_Base::C_Data::C_Info::C_Content::TRetMax&& value)
{
    m_RetMax = std::forward<CESearchResult_Base::C_Data::C_Info::C_Content::TRetMax>(value);
    m_set_State[0] |= 0x3;
}

inline
CESearchResult_Base::C_Data::C_Info::C_Content::TRetMax& CESearchResult_Base::C_Data::C_Info::C_Content::SetRetMax(void)
{
#ifdef _DEBUG
    if (!IsSetRetMax()) {
        m_RetMax = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_RetMax;
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetRetStart(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetRetStart(void) const
{
    return IsSetRetStart();
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TRetStart& CESearchResult_Base::C_Data::C_Info::C_Content::GetRetStart(void) const
{
    if (!CanGetRetStart()) {
        ThrowUnassigned(1);
    }
    return m_RetStart;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetRetStart(const CESearchResult_Base::C_Data::C_Info::C_Content::TRetStart& value)
{
    m_RetStart = value;
    m_set_State[0] |= 0xc;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetRetStart(CESearchResult_Base::C_Data::C_Info::C_Content::TRetStart&& value)
{
    m_RetStart = std::forward<CESearchResult_Base::C_Data::C_Info::C_Content::TRetStart>(value);
    m_set_State[0] |= 0xc;
}

inline
CESearchResult_Base::C_Data::C_Info::C_Content::TRetStart& CESearchResult_Base::C_Data::C_Info::C_Content::SetRetStart(void)
{
#ifdef _DEBUG
    if (!IsSetRetStart()) {
        m_RetStart = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_RetStart;
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetQueryKey(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetQueryKey(void) const
{
    return IsSetQueryKey();
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TQueryKey& CESearchResult_Base::C_Data::C_Info::C_Content::GetQueryKey(void) const
{
    if (!CanGetQueryKey()) {
        ThrowUnassigned(2);
    }
    return m_QueryKey;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetQueryKey(const CESearchResult_Base::C_Data::C_Info::C_Content::TQueryKey& value)
{
    m_QueryKey = value;
    m_set_State[0] |= 0x30;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetQueryKey(CESearchResult_Base::C_Data::C_Info::C_Content::TQueryKey&& value)
{
    m_QueryKey = std::forward<CESearchResult_Base::C_Data::C_Info::C_Content::TQueryKey>(value);
    m_set_State[0] |= 0x30;
}

inline
CESearchResult_Base::C_Data::C_Info::C_Content::TQueryKey& CESearchResult_Base::C_Data::C_Info::C_Content::SetQueryKey(void)
{
#ifdef _DEBUG
    if (!IsSetQueryKey()) {
        m_QueryKey = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_QueryKey;
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetWebEnv(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetWebEnv(void) const
{
    return IsSetWebEnv();
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TWebEnv& CESearchResult_Base::C_Data::C_Info::C_Content::GetWebEnv(void) const
{
    if (!CanGetWebEnv()) {
        ThrowUnassigned(3);
    }
    return m_WebEnv;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetWebEnv(const CESearchResult_Base::C_Data::C_Info::C_Content::TWebEnv& value)
{
    m_WebEnv = value;
    m_set_State[0] |= 0xc0;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetWebEnv(CESearchResult_Base::C_Data::C_Info::C_Content::TWebEnv&& value)
{
    m_WebEnv = std::forward<CESearchResult_Base::C_Data::C_Info::C_Content::TWebEnv>(value);
    m_set_State[0] |= 0xc0;
}

inline
CESearchResult_Base::C_Data::C_Info::C_Content::TWebEnv& CESearchResult_Base::C_Data::C_Info::C_Content::SetWebEnv(void)
{
#ifdef _DEBUG
    if (!IsSetWebEnv()) {
        m_WebEnv = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_WebEnv;
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetIdList(void) const
{
    return m_IdList.NotEmpty();
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetIdList(void) const
{
    return true;
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TIdList& CESearchResult_Base::C_Data::C_Info::C_Content::GetIdList(void) const
{
    if ( !m_IdList ) {
        const_cast<C_Content*>(this)->ResetIdList();
    }
    return (*m_IdList);
}

inline
CESearchResult_Base::C_Data::C_Info::C_Content::TIdList& CESearchResult_Base::C_Data::C_Info::C_Content::SetIdList(void)
{
    if ( !m_IdList ) {
        ResetIdList();
    }
    return (*m_IdList);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetTranslationSet(void) const
{
    return m_TranslationSet.NotEmpty();
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetTranslationSet(void) const
{
    return true;
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TTranslationSet& CESearchResult_Base::C_Data::C_Info::C_Content::GetTranslationSet(void) const
{
    if ( !m_TranslationSet ) {
        const_cast<C_Content*>(this)->ResetTranslationSet();
    }
    return (*m_TranslationSet);
}

inline
CESearchResult_Base::C_Data::C_Info::C_Content::TTranslationSet& CESearchResult_Base::C_Data::C_Info::C_Content::SetTranslationSet(void)
{
    if ( !m_TranslationSet ) {
        ResetTranslationSet();
    }
    return (*m_TranslationSet);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetTranslationStack(void) const
{
    return m_TranslationStack.NotEmpty();
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetTranslationStack(void) const
{
    return IsSetTranslationStack();
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TTranslationStack& CESearchResult_Base::C_Data::C_Info::C_Content::GetTranslationStack(void) const
{
    if (!CanGetTranslationStack()) {
        ThrowUnassigned(6);
    }
    return (*m_TranslationStack);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::IsSetQueryTranslation(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CESearchResult_Base::C_Data::C_Info::C_Content::CanGetQueryTranslation(void) const
{
    return IsSetQueryTranslation();
}

inline
const CESearchResult_Base::C_Data::C_Info::C_Content::TQueryTranslation& CESearchResult_Base::C_Data::C_Info::C_Content::GetQueryTranslation(void) const
{
    if (!CanGetQueryTranslation()) {
        ThrowUnassigned(7);
    }
    return m_QueryTranslation;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetQueryTranslation(const CESearchResult_Base::C_Data::C_Info::C_Content::TQueryTranslation& value)
{
    m_QueryTranslation = value;
    m_set_State[0] |= 0xc000;
}

inline
void CESearchResult_Base::C_Data::C_Info::C_Content::SetQueryTranslation(CESearchResult_Base::C_Data::C_Info::C_Content::TQueryTranslation&& value)
{
    m_QueryTranslation = std::forward<CESearchResult_Base::C_Data::C_Info::C_Content::TQueryTranslation>(value);
    m_set_State[0] |= 0xc000;
}

inline
CESearchResult_Base::C_Data::C_Info::C_Content::TQueryTranslation& CESearchResult_Base::C_Data::C_Info::C_Content::SetQueryTranslation(void)
{
#ifdef _DEBUG
    if (!IsSetQueryTranslation()) {
        m_QueryTranslation = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_QueryTranslation;
}

inline
bool CESearchResult_Base::C_Data::C_Info::IsSetCount(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CESearchResult_Base::C_Data::C_Info::CanGetCount(void) const
{
    return IsSetCount();
}

inline
const CESearchResult_Base::C_Data::C_Info::TCount& CESearchResult_Base::C_Data::C_Info::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(0);
    }
    return m_Count;
}

inline
void CESearchResult_Base::C_Data::C_Info::SetCount(const CESearchResult_Base::C_Data::C_Info::TCount& value)
{
    m_Count = value;
    m_set_State[0] |= 0x3;
}

inline
void CESearchResult_Base::C_Data::C_Info::SetCount(CESearchResult_Base::C_Data::C_Info::TCount&& value)
{
    m_Count = std::forward<CESearchResult_Base::C_Data::C_Info::TCount>(value);
    m_set_State[0] |= 0x3;
}

inline
CESearchResult_Base::C_Data::C_Info::TCount& CESearchResult_Base::C_Data::C_Info::SetCount(void)
{
#ifdef _DEBUG
    if (!IsSetCount()) {
        m_Count = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Count;
}

inline
bool CESearchResult_Base::C_Data::C_Info::IsSetContent(void) const
{
    return m_Content.NotEmpty();
}

inline
bool CESearchResult_Base::C_Data::C_Info::CanGetContent(void) const
{
    return IsSetContent();
}

inline
const CESearchResult_Base::C_Data::C_Info::TContent& CESearchResult_Base::C_Data::C_Info::GetContent(void) const
{
    if (!CanGetContent()) {
        ThrowUnassigned(1);
    }
    return (*m_Content);
}

inline
CESearchResult_Base::C_Data::E_Choice CESearchResult_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CESearchResult_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CESearchResult_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CESearchResult_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CESearchResult_Base::C_Data::IsInfo(void) const
{
    return m_choice == e_Info;
}

inline
bool CESearchResult_Base::C_Data::IsERROR(void) const
{
    return m_choice == e_ERROR;
}

inline
const CESearchResult_Base::C_Data::TERROR& CESearchResult_Base::C_Data::GetERROR(void) const
{
    CheckSelected(e_ERROR);
    return *m_string;
}

inline
CESearchResult_Base::C_Data::TERROR& CESearchResult_Base::C_Data::SetERROR(void)
{
    Select(e_ERROR, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CESearchResult_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CESearchResult_Base::CanGetData(void) const
{
    return true;
}

inline
const CESearchResult_Base::TData& CESearchResult_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CESearchResult_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CESearchResult_Base::TData& CESearchResult_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

inline
bool CESearchResult_Base::IsSetErrorList(void) const
{
    return m_ErrorList.NotEmpty();
}

inline
bool CESearchResult_Base::CanGetErrorList(void) const
{
    return IsSetErrorList();
}

inline
const CESearchResult_Base::TErrorList& CESearchResult_Base::GetErrorList(void) const
{
    if (!CanGetErrorList()) {
        ThrowUnassigned(1);
    }
    return (*m_ErrorList);
}

inline
bool CESearchResult_Base::IsSetWarningList(void) const
{
    return m_WarningList.NotEmpty();
}

inline
bool CESearchResult_Base::CanGetWarningList(void) const
{
    return IsSetWarningList();
}

inline
const CESearchResult_Base::TWarningList& CESearchResult_Base::GetWarningList(void) const
{
    if (!CanGetWarningList()) {
        ThrowUnassigned(2);
    }
    return (*m_WarningList);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esearch_SCOPE // namespace esearch::


#endif // esearch__OBJTOOLS_EUTILS_ESEARCH_ESEARCHRESULT_BASE_HPP
