/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Object_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_OBJECT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_OBJECT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CParam;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPubmedObject_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPubmedObject_Base(void);
    // destructor
    virtual ~CPubmedObject_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Type
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        const TType& GetType(void) const;
        void SetType(const TType& value);
        void SetType(TType&& value);
        TType& SetType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Type;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CParam > > TParam;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Param
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CParam > > TParam
    ///  Check whether the Param data member has been assigned a value.
    bool IsSetParam(void) const;
    /// Check whether it is safe or not to call GetParam method.
    bool CanGetParam(void) const;
    void ResetParam(void);
    const TParam& GetParam(void) const;
    TParam& SetParam(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubmedObject_Base(const CPubmedObject_Base&);
    CPubmedObject_Base& operator=(const CPubmedObject_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CParam > > m_Param;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubmedObject_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPubmedObject_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
const CPubmedObject_Base::C_Attlist::TType& CPubmedObject_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CPubmedObject_Base::C_Attlist::SetType(const CPubmedObject_Base::C_Attlist::TType& value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
void CPubmedObject_Base::C_Attlist::SetType(CPubmedObject_Base::C_Attlist::TType&& value)
{
    m_Type = std::forward<CPubmedObject_Base::C_Attlist::TType>(value);
    m_set_State[0] |= 0x3;
}

inline
CPubmedObject_Base::C_Attlist::TType& CPubmedObject_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        m_Type = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CPubmedObject_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CPubmedObject_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CPubmedObject_Base::TAttlist& CPubmedObject_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CPubmedObject_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CPubmedObject_Base::TAttlist& CPubmedObject_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CPubmedObject_Base::IsSetParam(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPubmedObject_Base::CanGetParam(void) const
{
    return true;
}

inline
const CPubmedObject_Base::TParam& CPubmedObject_Base::GetParam(void) const
{
    return m_Param;
}

inline
CPubmedObject_Base::TParam& CPubmedObject_Base::SetParam(void)
{
    m_set_State[0] |= 0x4;
    return m_Param;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_OBJECT_BASE_HPP
