/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mtable_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MTABLE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MTABLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CTableRowExpression;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMtable_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMtable_Base(void);
    // destructor
    virtual ~CMtable_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_frame {
            eAttlist_frame_none   = 1,
            eAttlist_frame_solid  = 2,
            eAttlist_frame_dashed = 3
        };
        
        /// Access to EAttlist_frame's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_frame)(void);
        
        enum EAttlist_equalrows {
            eAttlist_equalrows_true  = 1,
            eAttlist_equalrows_false = 2
        };
        
        /// Access to EAttlist_equalrows's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_equalrows)(void);
        
        enum EAttlist_equalcolumns {
            eAttlist_equalcolumns_true  = 1,
            eAttlist_equalcolumns_false = 2
        };
        
        /// Access to EAttlist_equalcolumns's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_equalcolumns)(void);
        
        enum EAttlist_displaystyle {
            eAttlist_displaystyle_true  = 1,
            eAttlist_displaystyle_false = 2
        };
        
        /// Access to EAttlist_displaystyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_displaystyle)(void);
        
        enum EAttlist_side {
            eAttlist_side_left         = 1,
            eAttlist_side_right        = 2,
            eAttlist_side_leftoverlap  = 3,
            eAttlist_side_rightoverlap = 4
        };
        
        /// Access to EAttlist_side's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_side)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TAlign;
        typedef NCBI_NS_STD::string TRowalign;
        typedef NCBI_NS_STD::string TColumnalign;
        typedef NCBI_NS_STD::string TGroupalign;
        typedef NCBI_NS_STD::string TAlignmentscope;
        typedef NCBI_NS_STD::string TColumnwidth;
        typedef NCBI_NS_STD::string TWidth;
        typedef NCBI_NS_STD::string TRowspacing;
        typedef NCBI_NS_STD::string TColumnspacing;
        typedef NCBI_NS_STD::string TRowlines;
        typedef NCBI_NS_STD::string TColumnlines;
        typedef EAttlist_frame TFrame;
        typedef NCBI_NS_STD::string TFramespacing;
        typedef EAttlist_equalrows TEqualrows;
        typedef EAttlist_equalcolumns TEqualcolumns;
        typedef EAttlist_displaystyle TDisplaystyle;
        typedef EAttlist_side TSide;
        typedef NCBI_NS_STD::string TMinlabelspacing;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_align,
            e_rowalign,
            e_columnalign,
            e_groupalign,
            e_alignmentscope,
            e_columnwidth,
            e_width,
            e_rowspacing,
            e_columnspacing,
            e_rowlines,
            e_columnlines,
            e_frame,
            e_framespacing,
            e_equalrows,
            e_equalcolumns,
            e_displaystyle,
            e_side,
            e_minlabelspacing
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 26> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAlign
        ///  Check whether the Align data member has been assigned a value.
        bool IsSetAlign(void) const;
        /// Check whether it is safe or not to call GetAlign method.
        bool CanGetAlign(void) const;
        void ResetAlign(void);
        const TAlign& GetAlign(void) const;
        void SetAlign(const TAlign& value);
        void SetAlign(TAlign&& value);
        TAlign& SetAlign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowalign
        ///  Check whether the Rowalign data member has been assigned a value.
        bool IsSetRowalign(void) const;
        /// Check whether it is safe or not to call GetRowalign method.
        bool CanGetRowalign(void) const;
        void ResetRowalign(void);
        const TRowalign& GetRowalign(void) const;
        void SetRowalign(const TRowalign& value);
        void SetRowalign(TRowalign&& value);
        TRowalign& SetRowalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnalign
        ///  Check whether the Columnalign data member has been assigned a value.
        bool IsSetColumnalign(void) const;
        /// Check whether it is safe or not to call GetColumnalign method.
        bool CanGetColumnalign(void) const;
        void ResetColumnalign(void);
        const TColumnalign& GetColumnalign(void) const;
        void SetColumnalign(const TColumnalign& value);
        void SetColumnalign(TColumnalign&& value);
        TColumnalign& SetColumnalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TGroupalign
        ///  Check whether the Groupalign data member has been assigned a value.
        bool IsSetGroupalign(void) const;
        /// Check whether it is safe or not to call GetGroupalign method.
        bool CanGetGroupalign(void) const;
        void ResetGroupalign(void);
        const TGroupalign& GetGroupalign(void) const;
        void SetGroupalign(const TGroupalign& value);
        void SetGroupalign(TGroupalign&& value);
        TGroupalign& SetGroupalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAlignmentscope
        ///  Check whether the Alignmentscope data member has been assigned a value.
        bool IsSetAlignmentscope(void) const;
        /// Check whether it is safe or not to call GetAlignmentscope method.
        bool CanGetAlignmentscope(void) const;
        void ResetAlignmentscope(void);
        const TAlignmentscope& GetAlignmentscope(void) const;
        void SetAlignmentscope(const TAlignmentscope& value);
        void SetAlignmentscope(TAlignmentscope&& value);
        TAlignmentscope& SetAlignmentscope(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnwidth
        ///  Check whether the Columnwidth data member has been assigned a value.
        bool IsSetColumnwidth(void) const;
        /// Check whether it is safe or not to call GetColumnwidth method.
        bool CanGetColumnwidth(void) const;
        void ResetColumnwidth(void);
        const TColumnwidth& GetColumnwidth(void) const;
        void SetColumnwidth(const TColumnwidth& value);
        void SetColumnwidth(TColumnwidth&& value);
        TColumnwidth& SetColumnwidth(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TWidth
        ///  Check whether the Width data member has been assigned a value.
        bool IsSetWidth(void) const;
        /// Check whether it is safe or not to call GetWidth method.
        bool CanGetWidth(void) const;
        void ResetWidth(void);
        const TWidth& GetWidth(void) const;
        void SetWidth(const TWidth& value);
        void SetWidth(TWidth&& value);
        TWidth& SetWidth(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowspacing
        ///  Check whether the Rowspacing data member has been assigned a value.
        bool IsSetRowspacing(void) const;
        /// Check whether it is safe or not to call GetRowspacing method.
        bool CanGetRowspacing(void) const;
        void ResetRowspacing(void);
        const TRowspacing& GetRowspacing(void) const;
        void SetRowspacing(const TRowspacing& value);
        void SetRowspacing(TRowspacing&& value);
        TRowspacing& SetRowspacing(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnspacing
        ///  Check whether the Columnspacing data member has been assigned a value.
        bool IsSetColumnspacing(void) const;
        /// Check whether it is safe or not to call GetColumnspacing method.
        bool CanGetColumnspacing(void) const;
        void ResetColumnspacing(void);
        const TColumnspacing& GetColumnspacing(void) const;
        void SetColumnspacing(const TColumnspacing& value);
        void SetColumnspacing(TColumnspacing&& value);
        TColumnspacing& SetColumnspacing(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowlines
        ///  Check whether the Rowlines data member has been assigned a value.
        bool IsSetRowlines(void) const;
        /// Check whether it is safe or not to call GetRowlines method.
        bool CanGetRowlines(void) const;
        void ResetRowlines(void);
        const TRowlines& GetRowlines(void) const;
        void SetRowlines(const TRowlines& value);
        void SetRowlines(TRowlines&& value);
        TRowlines& SetRowlines(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnlines
        ///  Check whether the Columnlines data member has been assigned a value.
        bool IsSetColumnlines(void) const;
        /// Check whether it is safe or not to call GetColumnlines method.
        bool CanGetColumnlines(void) const;
        void ResetColumnlines(void);
        const TColumnlines& GetColumnlines(void) const;
        void SetColumnlines(const TColumnlines& value);
        void SetColumnlines(TColumnlines&& value);
        TColumnlines& SetColumnlines(void);
    
        /// optional
        /// typedef EAttlist_frame TFrame
        ///  Check whether the Frame data member has been assigned a value.
        bool IsSetFrame(void) const;
        /// Check whether it is safe or not to call GetFrame method.
        bool CanGetFrame(void) const;
        void ResetFrame(void);
        TFrame GetFrame(void) const;
        void SetFrame(TFrame value);
        TFrame& SetFrame(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFramespacing
        ///  Check whether the Framespacing data member has been assigned a value.
        bool IsSetFramespacing(void) const;
        /// Check whether it is safe or not to call GetFramespacing method.
        bool CanGetFramespacing(void) const;
        void ResetFramespacing(void);
        const TFramespacing& GetFramespacing(void) const;
        void SetFramespacing(const TFramespacing& value);
        void SetFramespacing(TFramespacing&& value);
        TFramespacing& SetFramespacing(void);
    
        /// optional
        /// typedef EAttlist_equalrows TEqualrows
        ///  Check whether the Equalrows data member has been assigned a value.
        bool IsSetEqualrows(void) const;
        /// Check whether it is safe or not to call GetEqualrows method.
        bool CanGetEqualrows(void) const;
        void ResetEqualrows(void);
        TEqualrows GetEqualrows(void) const;
        void SetEqualrows(TEqualrows value);
        TEqualrows& SetEqualrows(void);
    
        /// optional
        /// typedef EAttlist_equalcolumns TEqualcolumns
        ///  Check whether the Equalcolumns data member has been assigned a value.
        bool IsSetEqualcolumns(void) const;
        /// Check whether it is safe or not to call GetEqualcolumns method.
        bool CanGetEqualcolumns(void) const;
        void ResetEqualcolumns(void);
        TEqualcolumns GetEqualcolumns(void) const;
        void SetEqualcolumns(TEqualcolumns value);
        TEqualcolumns& SetEqualcolumns(void);
    
        /// optional
        /// typedef EAttlist_displaystyle TDisplaystyle
        ///  Check whether the Displaystyle data member has been assigned a value.
        bool IsSetDisplaystyle(void) const;
        /// Check whether it is safe or not to call GetDisplaystyle method.
        bool CanGetDisplaystyle(void) const;
        void ResetDisplaystyle(void);
        TDisplaystyle GetDisplaystyle(void) const;
        void SetDisplaystyle(TDisplaystyle value);
        TDisplaystyle& SetDisplaystyle(void);
    
        /// optional
        /// typedef EAttlist_side TSide
        ///  Check whether the Side data member has been assigned a value.
        bool IsSetSide(void) const;
        /// Check whether it is safe or not to call GetSide method.
        bool CanGetSide(void) const;
        void ResetSide(void);
        TSide GetSide(void) const;
        void SetSide(TSide value);
        TSide& SetSide(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMinlabelspacing
        ///  Check whether the Minlabelspacing data member has been assigned a value.
        bool IsSetMinlabelspacing(void) const;
        /// Check whether it is safe or not to call GetMinlabelspacing method.
        bool CanGetMinlabelspacing(void) const;
        void ResetMinlabelspacing(void);
        const TMinlabelspacing& GetMinlabelspacing(void) const;
        void SetMinlabelspacing(const TMinlabelspacing& value);
        void SetMinlabelspacing(TMinlabelspacing&& value);
        TMinlabelspacing& SetMinlabelspacing(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[2];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Align;
        NCBI_NS_STD::string m_Rowalign;
        NCBI_NS_STD::string m_Columnalign;
        NCBI_NS_STD::string m_Groupalign;
        NCBI_NS_STD::string m_Alignmentscope;
        NCBI_NS_STD::string m_Columnwidth;
        NCBI_NS_STD::string m_Width;
        NCBI_NS_STD::string m_Rowspacing;
        NCBI_NS_STD::string m_Columnspacing;
        NCBI_NS_STD::string m_Rowlines;
        NCBI_NS_STD::string m_Columnlines;
        EAttlist_frame m_Frame;
        NCBI_NS_STD::string m_Framespacing;
        EAttlist_equalrows m_Equalrows;
        EAttlist_equalcolumns m_Equalcolumns;
        EAttlist_displaystyle m_Displaystyle;
        EAttlist_side m_Side;
        NCBI_NS_STD::string m_Minlabelspacing;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_TableRowExpression : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_TableRowExpression(void);
        // destructor
        ~C_TableRowExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CTableRowExpression C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CTableRowExpression > > TTableRowExpression;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_TableRowExpression
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CTableRowExpression > > TTableRowExpression
        ///  Check whether the TableRowExpression data member has been assigned a value.
        bool IsSetTableRowExpression(void) const;
        /// Check whether it is safe or not to call GetTableRowExpression method.
        bool CanGetTableRowExpression(void) const;
        void ResetTableRowExpression(void);
        const TTableRowExpression& GetTableRowExpression(void) const;
        TTableRowExpression& SetTableRowExpression(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_TableRowExpression(const C_TableRowExpression&);
        C_TableRowExpression& operator=(const C_TableRowExpression&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CTableRowExpression > > m_TableRowExpression;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_TableRowExpression TTableRowExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_TableRowExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef C_TableRowExpression TTableRowExpression
    ///  Check whether the TableRowExpression data member has been assigned a value.
    bool IsSetTableRowExpression(void) const;
    /// Check whether it is safe or not to call GetTableRowExpression method.
    bool CanGetTableRowExpression(void) const;
    void ResetTableRowExpression(void);
    const TTableRowExpression& GetTableRowExpression(void) const;
    void SetTableRowExpression(TTableRowExpression& value);
    TTableRowExpression& SetTableRowExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMtable_Base(const CMtable_Base&);
    CMtable_Base& operator=(const CMtable_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TTableRowExpression > m_TableRowExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMtable_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMtable_Base::C_Attlist::TId& CMtable_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMtable_Base::C_Attlist::SetId(const CMtable_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMtable_Base::C_Attlist::SetId(CMtable_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMtable_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMtable_Base::C_Attlist::TId& CMtable_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMtable_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMtable_Base::C_Attlist::TXref& CMtable_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMtable_Base::C_Attlist::SetXref(const CMtable_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMtable_Base::C_Attlist::SetXref(CMtable_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMtable_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMtable_Base::C_Attlist::TXref& CMtable_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMtable_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMtable_Base::C_Attlist::TClass& CMtable_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMtable_Base::C_Attlist::SetClass(const CMtable_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMtable_Base::C_Attlist::SetClass(CMtable_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMtable_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMtable_Base::C_Attlist::TClass& CMtable_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMtable_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMtable_Base::C_Attlist::TStyle& CMtable_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMtable_Base::C_Attlist::SetStyle(const CMtable_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMtable_Base::C_Attlist::SetStyle(CMtable_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMtable_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMtable_Base::C_Attlist::TStyle& CMtable_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMtable_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMtable_Base::C_Attlist::THref& CMtable_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMtable_Base::C_Attlist::SetHref(const CMtable_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMtable_Base::C_Attlist::SetHref(CMtable_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMtable_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMtable_Base::C_Attlist::THref& CMtable_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMtable_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMtable_Base::C_Attlist::TMathcolor& CMtable_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMtable_Base::C_Attlist::SetMathcolor(const CMtable_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMtable_Base::C_Attlist::SetMathcolor(CMtable_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMtable_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMtable_Base::C_Attlist::TMathcolor& CMtable_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMtable_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMtable_Base::C_Attlist::TMathbackground& CMtable_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMtable_Base::C_Attlist::SetMathbackground(const CMtable_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMtable_Base::C_Attlist::SetMathbackground(CMtable_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMtable_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMtable_Base::C_Attlist::TMathbackground& CMtable_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMtable_Base::C_Attlist::IsSetAlign(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetAlign(void) const
{
    return IsSetAlign();
}

inline
const CMtable_Base::C_Attlist::TAlign& CMtable_Base::C_Attlist::GetAlign(void) const
{
    if (!CanGetAlign()) {
        ThrowUnassigned(7);
    }
    return m_Align;
}

inline
void CMtable_Base::C_Attlist::SetAlign(const CMtable_Base::C_Attlist::TAlign& value)
{
    m_Align = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMtable_Base::C_Attlist::SetAlign(CMtable_Base::C_Attlist::TAlign&& value)
{
    m_Align = std::forward<CMtable_Base::C_Attlist::TAlign>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMtable_Base::C_Attlist::TAlign& CMtable_Base::C_Attlist::SetAlign(void)
{
#ifdef _DEBUG
    if (!IsSetAlign()) {
        m_Align = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Align;
}

inline
bool CMtable_Base::C_Attlist::IsSetRowalign(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetRowalign(void) const
{
    return IsSetRowalign();
}

inline
const CMtable_Base::C_Attlist::TRowalign& CMtable_Base::C_Attlist::GetRowalign(void) const
{
    if (!CanGetRowalign()) {
        ThrowUnassigned(8);
    }
    return m_Rowalign;
}

inline
void CMtable_Base::C_Attlist::SetRowalign(const CMtable_Base::C_Attlist::TRowalign& value)
{
    m_Rowalign = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMtable_Base::C_Attlist::SetRowalign(CMtable_Base::C_Attlist::TRowalign&& value)
{
    m_Rowalign = std::forward<CMtable_Base::C_Attlist::TRowalign>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMtable_Base::C_Attlist::TRowalign& CMtable_Base::C_Attlist::SetRowalign(void)
{
#ifdef _DEBUG
    if (!IsSetRowalign()) {
        m_Rowalign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Rowalign;
}

inline
bool CMtable_Base::C_Attlist::IsSetColumnalign(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetColumnalign(void) const
{
    return IsSetColumnalign();
}

inline
const CMtable_Base::C_Attlist::TColumnalign& CMtable_Base::C_Attlist::GetColumnalign(void) const
{
    if (!CanGetColumnalign()) {
        ThrowUnassigned(9);
    }
    return m_Columnalign;
}

inline
void CMtable_Base::C_Attlist::SetColumnalign(const CMtable_Base::C_Attlist::TColumnalign& value)
{
    m_Columnalign = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMtable_Base::C_Attlist::SetColumnalign(CMtable_Base::C_Attlist::TColumnalign&& value)
{
    m_Columnalign = std::forward<CMtable_Base::C_Attlist::TColumnalign>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMtable_Base::C_Attlist::TColumnalign& CMtable_Base::C_Attlist::SetColumnalign(void)
{
#ifdef _DEBUG
    if (!IsSetColumnalign()) {
        m_Columnalign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Columnalign;
}

inline
bool CMtable_Base::C_Attlist::IsSetGroupalign(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetGroupalign(void) const
{
    return IsSetGroupalign();
}

inline
const CMtable_Base::C_Attlist::TGroupalign& CMtable_Base::C_Attlist::GetGroupalign(void) const
{
    if (!CanGetGroupalign()) {
        ThrowUnassigned(10);
    }
    return m_Groupalign;
}

inline
void CMtable_Base::C_Attlist::SetGroupalign(const CMtable_Base::C_Attlist::TGroupalign& value)
{
    m_Groupalign = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMtable_Base::C_Attlist::SetGroupalign(CMtable_Base::C_Attlist::TGroupalign&& value)
{
    m_Groupalign = std::forward<CMtable_Base::C_Attlist::TGroupalign>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMtable_Base::C_Attlist::TGroupalign& CMtable_Base::C_Attlist::SetGroupalign(void)
{
#ifdef _DEBUG
    if (!IsSetGroupalign()) {
        m_Groupalign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Groupalign;
}

inline
bool CMtable_Base::C_Attlist::IsSetAlignmentscope(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetAlignmentscope(void) const
{
    return IsSetAlignmentscope();
}

inline
const CMtable_Base::C_Attlist::TAlignmentscope& CMtable_Base::C_Attlist::GetAlignmentscope(void) const
{
    if (!CanGetAlignmentscope()) {
        ThrowUnassigned(11);
    }
    return m_Alignmentscope;
}

inline
void CMtable_Base::C_Attlist::SetAlignmentscope(const CMtable_Base::C_Attlist::TAlignmentscope& value)
{
    m_Alignmentscope = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CMtable_Base::C_Attlist::SetAlignmentscope(CMtable_Base::C_Attlist::TAlignmentscope&& value)
{
    m_Alignmentscope = std::forward<CMtable_Base::C_Attlist::TAlignmentscope>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CMtable_Base::C_Attlist::TAlignmentscope& CMtable_Base::C_Attlist::SetAlignmentscope(void)
{
#ifdef _DEBUG
    if (!IsSetAlignmentscope()) {
        m_Alignmentscope = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Alignmentscope;
}

inline
bool CMtable_Base::C_Attlist::IsSetColumnwidth(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetColumnwidth(void) const
{
    return IsSetColumnwidth();
}

inline
const CMtable_Base::C_Attlist::TColumnwidth& CMtable_Base::C_Attlist::GetColumnwidth(void) const
{
    if (!CanGetColumnwidth()) {
        ThrowUnassigned(12);
    }
    return m_Columnwidth;
}

inline
void CMtable_Base::C_Attlist::SetColumnwidth(const CMtable_Base::C_Attlist::TColumnwidth& value)
{
    m_Columnwidth = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CMtable_Base::C_Attlist::SetColumnwidth(CMtable_Base::C_Attlist::TColumnwidth&& value)
{
    m_Columnwidth = std::forward<CMtable_Base::C_Attlist::TColumnwidth>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CMtable_Base::C_Attlist::TColumnwidth& CMtable_Base::C_Attlist::SetColumnwidth(void)
{
#ifdef _DEBUG
    if (!IsSetColumnwidth()) {
        m_Columnwidth = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Columnwidth;
}

inline
bool CMtable_Base::C_Attlist::IsSetWidth(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetWidth(void) const
{
    return IsSetWidth();
}

inline
const CMtable_Base::C_Attlist::TWidth& CMtable_Base::C_Attlist::GetWidth(void) const
{
    if (!CanGetWidth()) {
        ThrowUnassigned(13);
    }
    return m_Width;
}

inline
void CMtable_Base::C_Attlist::SetWidth(const CMtable_Base::C_Attlist::TWidth& value)
{
    m_Width = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CMtable_Base::C_Attlist::SetWidth(CMtable_Base::C_Attlist::TWidth&& value)
{
    m_Width = std::forward<CMtable_Base::C_Attlist::TWidth>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CMtable_Base::C_Attlist::TWidth& CMtable_Base::C_Attlist::SetWidth(void)
{
#ifdef _DEBUG
    if (!IsSetWidth()) {
        m_Width = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Width;
}

inline
bool CMtable_Base::C_Attlist::IsSetRowspacing(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetRowspacing(void) const
{
    return IsSetRowspacing();
}

inline
const CMtable_Base::C_Attlist::TRowspacing& CMtable_Base::C_Attlist::GetRowspacing(void) const
{
    if (!CanGetRowspacing()) {
        ThrowUnassigned(14);
    }
    return m_Rowspacing;
}

inline
void CMtable_Base::C_Attlist::SetRowspacing(const CMtable_Base::C_Attlist::TRowspacing& value)
{
    m_Rowspacing = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CMtable_Base::C_Attlist::SetRowspacing(CMtable_Base::C_Attlist::TRowspacing&& value)
{
    m_Rowspacing = std::forward<CMtable_Base::C_Attlist::TRowspacing>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CMtable_Base::C_Attlist::TRowspacing& CMtable_Base::C_Attlist::SetRowspacing(void)
{
#ifdef _DEBUG
    if (!IsSetRowspacing()) {
        m_Rowspacing = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Rowspacing;
}

inline
bool CMtable_Base::C_Attlist::IsSetColumnspacing(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetColumnspacing(void) const
{
    return IsSetColumnspacing();
}

inline
const CMtable_Base::C_Attlist::TColumnspacing& CMtable_Base::C_Attlist::GetColumnspacing(void) const
{
    if (!CanGetColumnspacing()) {
        ThrowUnassigned(15);
    }
    return m_Columnspacing;
}

inline
void CMtable_Base::C_Attlist::SetColumnspacing(const CMtable_Base::C_Attlist::TColumnspacing& value)
{
    m_Columnspacing = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CMtable_Base::C_Attlist::SetColumnspacing(CMtable_Base::C_Attlist::TColumnspacing&& value)
{
    m_Columnspacing = std::forward<CMtable_Base::C_Attlist::TColumnspacing>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CMtable_Base::C_Attlist::TColumnspacing& CMtable_Base::C_Attlist::SetColumnspacing(void)
{
#ifdef _DEBUG
    if (!IsSetColumnspacing()) {
        m_Columnspacing = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Columnspacing;
}

inline
bool CMtable_Base::C_Attlist::IsSetRowlines(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetRowlines(void) const
{
    return IsSetRowlines();
}

inline
const CMtable_Base::C_Attlist::TRowlines& CMtable_Base::C_Attlist::GetRowlines(void) const
{
    if (!CanGetRowlines()) {
        ThrowUnassigned(16);
    }
    return m_Rowlines;
}

inline
void CMtable_Base::C_Attlist::SetRowlines(const CMtable_Base::C_Attlist::TRowlines& value)
{
    m_Rowlines = value;
    m_set_State[1] |= 0x3;
}

inline
void CMtable_Base::C_Attlist::SetRowlines(CMtable_Base::C_Attlist::TRowlines&& value)
{
    m_Rowlines = std::forward<CMtable_Base::C_Attlist::TRowlines>(value);
    m_set_State[1] |= 0x3;
}

inline
CMtable_Base::C_Attlist::TRowlines& CMtable_Base::C_Attlist::SetRowlines(void)
{
#ifdef _DEBUG
    if (!IsSetRowlines()) {
        m_Rowlines = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Rowlines;
}

inline
bool CMtable_Base::C_Attlist::IsSetColumnlines(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetColumnlines(void) const
{
    return IsSetColumnlines();
}

inline
const CMtable_Base::C_Attlist::TColumnlines& CMtable_Base::C_Attlist::GetColumnlines(void) const
{
    if (!CanGetColumnlines()) {
        ThrowUnassigned(17);
    }
    return m_Columnlines;
}

inline
void CMtable_Base::C_Attlist::SetColumnlines(const CMtable_Base::C_Attlist::TColumnlines& value)
{
    m_Columnlines = value;
    m_set_State[1] |= 0xc;
}

inline
void CMtable_Base::C_Attlist::SetColumnlines(CMtable_Base::C_Attlist::TColumnlines&& value)
{
    m_Columnlines = std::forward<CMtable_Base::C_Attlist::TColumnlines>(value);
    m_set_State[1] |= 0xc;
}

inline
CMtable_Base::C_Attlist::TColumnlines& CMtable_Base::C_Attlist::SetColumnlines(void)
{
#ifdef _DEBUG
    if (!IsSetColumnlines()) {
        m_Columnlines = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Columnlines;
}

inline
bool CMtable_Base::C_Attlist::IsSetFrame(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetFrame(void) const
{
    return IsSetFrame();
}

inline
void CMtable_Base::C_Attlist::ResetFrame(void)
{
    m_Frame = (EAttlist_frame)(0);
    m_set_State[1] &= ~0x30;
}

inline
CMtable_Base::C_Attlist::TFrame CMtable_Base::C_Attlist::GetFrame(void) const
{
    if (!CanGetFrame()) {
        ThrowUnassigned(18);
    }
    return m_Frame;
}

inline
void CMtable_Base::C_Attlist::SetFrame(CMtable_Base::C_Attlist::TFrame value)
{
    m_Frame = value;
    m_set_State[1] |= 0x30;
}

inline
CMtable_Base::C_Attlist::TFrame& CMtable_Base::C_Attlist::SetFrame(void)
{
#ifdef _DEBUG
    if (!IsSetFrame()) {
        memset(&m_Frame,UnassignedByte(),sizeof(m_Frame));
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Frame;
}

inline
bool CMtable_Base::C_Attlist::IsSetFramespacing(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetFramespacing(void) const
{
    return IsSetFramespacing();
}

inline
const CMtable_Base::C_Attlist::TFramespacing& CMtable_Base::C_Attlist::GetFramespacing(void) const
{
    if (!CanGetFramespacing()) {
        ThrowUnassigned(19);
    }
    return m_Framespacing;
}

inline
void CMtable_Base::C_Attlist::SetFramespacing(const CMtable_Base::C_Attlist::TFramespacing& value)
{
    m_Framespacing = value;
    m_set_State[1] |= 0xc0;
}

inline
void CMtable_Base::C_Attlist::SetFramespacing(CMtable_Base::C_Attlist::TFramespacing&& value)
{
    m_Framespacing = std::forward<CMtable_Base::C_Attlist::TFramespacing>(value);
    m_set_State[1] |= 0xc0;
}

inline
CMtable_Base::C_Attlist::TFramespacing& CMtable_Base::C_Attlist::SetFramespacing(void)
{
#ifdef _DEBUG
    if (!IsSetFramespacing()) {
        m_Framespacing = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Framespacing;
}

inline
bool CMtable_Base::C_Attlist::IsSetEqualrows(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetEqualrows(void) const
{
    return IsSetEqualrows();
}

inline
void CMtable_Base::C_Attlist::ResetEqualrows(void)
{
    m_Equalrows = (EAttlist_equalrows)(0);
    m_set_State[1] &= ~0x300;
}

inline
CMtable_Base::C_Attlist::TEqualrows CMtable_Base::C_Attlist::GetEqualrows(void) const
{
    if (!CanGetEqualrows()) {
        ThrowUnassigned(20);
    }
    return m_Equalrows;
}

inline
void CMtable_Base::C_Attlist::SetEqualrows(CMtable_Base::C_Attlist::TEqualrows value)
{
    m_Equalrows = value;
    m_set_State[1] |= 0x300;
}

inline
CMtable_Base::C_Attlist::TEqualrows& CMtable_Base::C_Attlist::SetEqualrows(void)
{
#ifdef _DEBUG
    if (!IsSetEqualrows()) {
        memset(&m_Equalrows,UnassignedByte(),sizeof(m_Equalrows));
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Equalrows;
}

inline
bool CMtable_Base::C_Attlist::IsSetEqualcolumns(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetEqualcolumns(void) const
{
    return IsSetEqualcolumns();
}

inline
void CMtable_Base::C_Attlist::ResetEqualcolumns(void)
{
    m_Equalcolumns = (EAttlist_equalcolumns)(0);
    m_set_State[1] &= ~0xc00;
}

inline
CMtable_Base::C_Attlist::TEqualcolumns CMtable_Base::C_Attlist::GetEqualcolumns(void) const
{
    if (!CanGetEqualcolumns()) {
        ThrowUnassigned(21);
    }
    return m_Equalcolumns;
}

inline
void CMtable_Base::C_Attlist::SetEqualcolumns(CMtable_Base::C_Attlist::TEqualcolumns value)
{
    m_Equalcolumns = value;
    m_set_State[1] |= 0xc00;
}

inline
CMtable_Base::C_Attlist::TEqualcolumns& CMtable_Base::C_Attlist::SetEqualcolumns(void)
{
#ifdef _DEBUG
    if (!IsSetEqualcolumns()) {
        memset(&m_Equalcolumns,UnassignedByte(),sizeof(m_Equalcolumns));
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Equalcolumns;
}

inline
bool CMtable_Base::C_Attlist::IsSetDisplaystyle(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetDisplaystyle(void) const
{
    return IsSetDisplaystyle();
}

inline
void CMtable_Base::C_Attlist::ResetDisplaystyle(void)
{
    m_Displaystyle = (EAttlist_displaystyle)(0);
    m_set_State[1] &= ~0x3000;
}

inline
CMtable_Base::C_Attlist::TDisplaystyle CMtable_Base::C_Attlist::GetDisplaystyle(void) const
{
    if (!CanGetDisplaystyle()) {
        ThrowUnassigned(22);
    }
    return m_Displaystyle;
}

inline
void CMtable_Base::C_Attlist::SetDisplaystyle(CMtable_Base::C_Attlist::TDisplaystyle value)
{
    m_Displaystyle = value;
    m_set_State[1] |= 0x3000;
}

inline
CMtable_Base::C_Attlist::TDisplaystyle& CMtable_Base::C_Attlist::SetDisplaystyle(void)
{
#ifdef _DEBUG
    if (!IsSetDisplaystyle()) {
        memset(&m_Displaystyle,UnassignedByte(),sizeof(m_Displaystyle));
    }
#endif
    m_set_State[1] |= 0x1000;
    return m_Displaystyle;
}

inline
bool CMtable_Base::C_Attlist::IsSetSide(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetSide(void) const
{
    return IsSetSide();
}

inline
void CMtable_Base::C_Attlist::ResetSide(void)
{
    m_Side = (EAttlist_side)(0);
    m_set_State[1] &= ~0xc000;
}

inline
CMtable_Base::C_Attlist::TSide CMtable_Base::C_Attlist::GetSide(void) const
{
    if (!CanGetSide()) {
        ThrowUnassigned(23);
    }
    return m_Side;
}

inline
void CMtable_Base::C_Attlist::SetSide(CMtable_Base::C_Attlist::TSide value)
{
    m_Side = value;
    m_set_State[1] |= 0xc000;
}

inline
CMtable_Base::C_Attlist::TSide& CMtable_Base::C_Attlist::SetSide(void)
{
#ifdef _DEBUG
    if (!IsSetSide()) {
        memset(&m_Side,UnassignedByte(),sizeof(m_Side));
    }
#endif
    m_set_State[1] |= 0x4000;
    return m_Side;
}

inline
bool CMtable_Base::C_Attlist::IsSetMinlabelspacing(void) const
{
    return ((m_set_State[1] & 0x30000) != 0);
}

inline
bool CMtable_Base::C_Attlist::CanGetMinlabelspacing(void) const
{
    return IsSetMinlabelspacing();
}

inline
const CMtable_Base::C_Attlist::TMinlabelspacing& CMtable_Base::C_Attlist::GetMinlabelspacing(void) const
{
    if (!CanGetMinlabelspacing()) {
        ThrowUnassigned(24);
    }
    return m_Minlabelspacing;
}

inline
void CMtable_Base::C_Attlist::SetMinlabelspacing(const CMtable_Base::C_Attlist::TMinlabelspacing& value)
{
    m_Minlabelspacing = value;
    m_set_State[1] |= 0x30000;
}

inline
void CMtable_Base::C_Attlist::SetMinlabelspacing(CMtable_Base::C_Attlist::TMinlabelspacing&& value)
{
    m_Minlabelspacing = std::forward<CMtable_Base::C_Attlist::TMinlabelspacing>(value);
    m_set_State[1] |= 0x30000;
}

inline
CMtable_Base::C_Attlist::TMinlabelspacing& CMtable_Base::C_Attlist::SetMinlabelspacing(void)
{
#ifdef _DEBUG
    if (!IsSetMinlabelspacing()) {
        m_Minlabelspacing = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10000;
    return m_Minlabelspacing;
}

inline
bool CMtable_Base::C_TableRowExpression::IsSetTableRowExpression(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMtable_Base::C_TableRowExpression::CanGetTableRowExpression(void) const
{
    return true;
}

inline
const CMtable_Base::C_TableRowExpression::TTableRowExpression& CMtable_Base::C_TableRowExpression::GetTableRowExpression(void) const
{
    return m_TableRowExpression;
}

inline
CMtable_Base::C_TableRowExpression::TTableRowExpression& CMtable_Base::C_TableRowExpression::SetTableRowExpression(void)
{
    m_set_State[0] |= 0x1;
    return m_TableRowExpression;
}

inline
bool CMtable_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMtable_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMtable_Base::TAttlist& CMtable_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMtable_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMtable_Base::TAttlist& CMtable_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMtable_Base::IsSetTableRowExpression(void) const
{
    return m_TableRowExpression.NotEmpty();
}

inline
bool CMtable_Base::CanGetTableRowExpression(void) const
{
    return IsSetTableRowExpression();
}

inline
const CMtable_Base::TTableRowExpression& CMtable_Base::GetTableRowExpression(void) const
{
    if (!CanGetTableRowExpression()) {
        ThrowUnassigned(1);
    }
    return (*m_TableRowExpression);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MTABLE_BASE_HPP
