/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Msline_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MSLINE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MSLINE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMsline_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMsline_Base(void);
    // destructor
    virtual ~CMsline_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TPosition;
        typedef NCBI_NS_STD::string TLength;
        typedef NCBI_NS_STD::string TLeftoverhang;
        typedef NCBI_NS_STD::string TRightoverhang;
        typedef NCBI_NS_STD::string TMslinethickness;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_position,
            e_length,
            e_leftoverhang,
            e_rightoverhang,
            e_mslinethickness
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 13> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TPosition
        ///  Check whether the Position data member has been assigned a value.
        bool IsSetPosition(void) const;
        /// Check whether it is safe or not to call GetPosition method.
        bool CanGetPosition(void) const;
        void ResetPosition(void);
        const TPosition& GetPosition(void) const;
        void SetPosition(const TPosition& value);
        void SetPosition(TPosition&& value);
        TPosition& SetPosition(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLength
        ///  Check whether the Length data member has been assigned a value.
        bool IsSetLength(void) const;
        /// Check whether it is safe or not to call GetLength method.
        bool CanGetLength(void) const;
        void ResetLength(void);
        const TLength& GetLength(void) const;
        void SetLength(const TLength& value);
        void SetLength(TLength&& value);
        TLength& SetLength(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLeftoverhang
        ///  Check whether the Leftoverhang data member has been assigned a value.
        bool IsSetLeftoverhang(void) const;
        /// Check whether it is safe or not to call GetLeftoverhang method.
        bool CanGetLeftoverhang(void) const;
        void ResetLeftoverhang(void);
        const TLeftoverhang& GetLeftoverhang(void) const;
        void SetLeftoverhang(const TLeftoverhang& value);
        void SetLeftoverhang(TLeftoverhang&& value);
        TLeftoverhang& SetLeftoverhang(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRightoverhang
        ///  Check whether the Rightoverhang data member has been assigned a value.
        bool IsSetRightoverhang(void) const;
        /// Check whether it is safe or not to call GetRightoverhang method.
        bool CanGetRightoverhang(void) const;
        void ResetRightoverhang(void);
        const TRightoverhang& GetRightoverhang(void) const;
        void SetRightoverhang(const TRightoverhang& value);
        void SetRightoverhang(TRightoverhang&& value);
        TRightoverhang& SetRightoverhang(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMslinethickness
        ///  Check whether the Mslinethickness data member has been assigned a value.
        bool IsSetMslinethickness(void) const;
        /// Check whether it is safe or not to call GetMslinethickness method.
        bool CanGetMslinethickness(void) const;
        void ResetMslinethickness(void);
        const TMslinethickness& GetMslinethickness(void) const;
        void SetMslinethickness(const TMslinethickness& value);
        void SetMslinethickness(TMslinethickness&& value);
        TMslinethickness& SetMslinethickness(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Position;
        NCBI_NS_STD::string m_Length;
        NCBI_NS_STD::string m_Leftoverhang;
        NCBI_NS_STD::string m_Rightoverhang;
        NCBI_NS_STD::string m_Mslinethickness;
    };
    // types
    typedef C_Attlist TAttlist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_msline
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    ///  Check whether the Msline data member has been assigned a value.
    bool IsSetMsline(void) const;
    /// Check whether it is safe or not to call GetMsline method.
    bool CanGetMsline(void) const;
    void ResetMsline(void);
    void SetMsline(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMsline_Base(const CMsline_Base&);
    CMsline_Base& operator=(const CMsline_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMsline_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMsline_Base::C_Attlist::TId& CMsline_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMsline_Base::C_Attlist::SetId(const CMsline_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMsline_Base::C_Attlist::SetId(CMsline_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMsline_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMsline_Base::C_Attlist::TId& CMsline_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMsline_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMsline_Base::C_Attlist::TXref& CMsline_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMsline_Base::C_Attlist::SetXref(const CMsline_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMsline_Base::C_Attlist::SetXref(CMsline_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMsline_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMsline_Base::C_Attlist::TXref& CMsline_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMsline_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMsline_Base::C_Attlist::TClass& CMsline_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMsline_Base::C_Attlist::SetClass(const CMsline_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMsline_Base::C_Attlist::SetClass(CMsline_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMsline_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMsline_Base::C_Attlist::TClass& CMsline_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMsline_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMsline_Base::C_Attlist::TStyle& CMsline_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMsline_Base::C_Attlist::SetStyle(const CMsline_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMsline_Base::C_Attlist::SetStyle(CMsline_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMsline_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMsline_Base::C_Attlist::TStyle& CMsline_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMsline_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMsline_Base::C_Attlist::THref& CMsline_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMsline_Base::C_Attlist::SetHref(const CMsline_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMsline_Base::C_Attlist::SetHref(CMsline_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMsline_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMsline_Base::C_Attlist::THref& CMsline_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMsline_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMsline_Base::C_Attlist::TMathcolor& CMsline_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMsline_Base::C_Attlist::SetMathcolor(const CMsline_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMsline_Base::C_Attlist::SetMathcolor(CMsline_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMsline_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMsline_Base::C_Attlist::TMathcolor& CMsline_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMsline_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMsline_Base::C_Attlist::TMathbackground& CMsline_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMsline_Base::C_Attlist::SetMathbackground(const CMsline_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMsline_Base::C_Attlist::SetMathbackground(CMsline_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMsline_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMsline_Base::C_Attlist::TMathbackground& CMsline_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMsline_Base::C_Attlist::IsSetPosition(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetPosition(void) const
{
    return IsSetPosition();
}

inline
const CMsline_Base::C_Attlist::TPosition& CMsline_Base::C_Attlist::GetPosition(void) const
{
    if (!CanGetPosition()) {
        ThrowUnassigned(7);
    }
    return m_Position;
}

inline
void CMsline_Base::C_Attlist::SetPosition(const CMsline_Base::C_Attlist::TPosition& value)
{
    m_Position = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMsline_Base::C_Attlist::SetPosition(CMsline_Base::C_Attlist::TPosition&& value)
{
    m_Position = std::forward<CMsline_Base::C_Attlist::TPosition>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMsline_Base::C_Attlist::TPosition& CMsline_Base::C_Attlist::SetPosition(void)
{
#ifdef _DEBUG
    if (!IsSetPosition()) {
        m_Position = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Position;
}

inline
bool CMsline_Base::C_Attlist::IsSetLength(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetLength(void) const
{
    return IsSetLength();
}

inline
const CMsline_Base::C_Attlist::TLength& CMsline_Base::C_Attlist::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(8);
    }
    return m_Length;
}

inline
void CMsline_Base::C_Attlist::SetLength(const CMsline_Base::C_Attlist::TLength& value)
{
    m_Length = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMsline_Base::C_Attlist::SetLength(CMsline_Base::C_Attlist::TLength&& value)
{
    m_Length = std::forward<CMsline_Base::C_Attlist::TLength>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMsline_Base::C_Attlist::TLength& CMsline_Base::C_Attlist::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        m_Length = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Length;
}

inline
bool CMsline_Base::C_Attlist::IsSetLeftoverhang(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetLeftoverhang(void) const
{
    return IsSetLeftoverhang();
}

inline
const CMsline_Base::C_Attlist::TLeftoverhang& CMsline_Base::C_Attlist::GetLeftoverhang(void) const
{
    if (!CanGetLeftoverhang()) {
        ThrowUnassigned(9);
    }
    return m_Leftoverhang;
}

inline
void CMsline_Base::C_Attlist::SetLeftoverhang(const CMsline_Base::C_Attlist::TLeftoverhang& value)
{
    m_Leftoverhang = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMsline_Base::C_Attlist::SetLeftoverhang(CMsline_Base::C_Attlist::TLeftoverhang&& value)
{
    m_Leftoverhang = std::forward<CMsline_Base::C_Attlist::TLeftoverhang>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMsline_Base::C_Attlist::TLeftoverhang& CMsline_Base::C_Attlist::SetLeftoverhang(void)
{
#ifdef _DEBUG
    if (!IsSetLeftoverhang()) {
        m_Leftoverhang = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Leftoverhang;
}

inline
bool CMsline_Base::C_Attlist::IsSetRightoverhang(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetRightoverhang(void) const
{
    return IsSetRightoverhang();
}

inline
const CMsline_Base::C_Attlist::TRightoverhang& CMsline_Base::C_Attlist::GetRightoverhang(void) const
{
    if (!CanGetRightoverhang()) {
        ThrowUnassigned(10);
    }
    return m_Rightoverhang;
}

inline
void CMsline_Base::C_Attlist::SetRightoverhang(const CMsline_Base::C_Attlist::TRightoverhang& value)
{
    m_Rightoverhang = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMsline_Base::C_Attlist::SetRightoverhang(CMsline_Base::C_Attlist::TRightoverhang&& value)
{
    m_Rightoverhang = std::forward<CMsline_Base::C_Attlist::TRightoverhang>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMsline_Base::C_Attlist::TRightoverhang& CMsline_Base::C_Attlist::SetRightoverhang(void)
{
#ifdef _DEBUG
    if (!IsSetRightoverhang()) {
        m_Rightoverhang = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Rightoverhang;
}

inline
bool CMsline_Base::C_Attlist::IsSetMslinethickness(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMsline_Base::C_Attlist::CanGetMslinethickness(void) const
{
    return IsSetMslinethickness();
}

inline
const CMsline_Base::C_Attlist::TMslinethickness& CMsline_Base::C_Attlist::GetMslinethickness(void) const
{
    if (!CanGetMslinethickness()) {
        ThrowUnassigned(11);
    }
    return m_Mslinethickness;
}

inline
void CMsline_Base::C_Attlist::SetMslinethickness(const CMsline_Base::C_Attlist::TMslinethickness& value)
{
    m_Mslinethickness = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CMsline_Base::C_Attlist::SetMslinethickness(CMsline_Base::C_Attlist::TMslinethickness&& value)
{
    m_Mslinethickness = std::forward<CMsline_Base::C_Attlist::TMslinethickness>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CMsline_Base::C_Attlist::TMslinethickness& CMsline_Base::C_Attlist::SetMslinethickness(void)
{
#ifdef _DEBUG
    if (!IsSetMslinethickness()) {
        m_Mslinethickness = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Mslinethickness;
}

inline
bool CMsline_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMsline_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMsline_Base::TAttlist& CMsline_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMsline_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMsline_Base::TAttlist& CMsline_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    SetMsline();
    return (*m_Attlist);
}

inline
bool CMsline_Base::IsSetMsline(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMsline_Base::CanGetMsline(void) const
{
    return false;
}

inline
void CMsline_Base::ResetMsline(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CMsline_Base::SetMsline(void)
{
    m_set_State[0] |= 0xc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MSLINE_BASE_HPP
