/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mlabeledtr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MLABELEDTR_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MLABELEDTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CTableCellExpression;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMlabeledtr_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMlabeledtr_Base(void);
    // destructor
    virtual ~CMlabeledtr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_rowalign {
            eAttlist_rowalign_top      = 1,
            eAttlist_rowalign_bottom   = 2,
            eAttlist_rowalign_center   = 3,
            eAttlist_rowalign_baseline = 4,
            eAttlist_rowalign_axis     = 5
        };
        
        /// Access to EAttlist_rowalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_rowalign)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef EAttlist_rowalign TRowalign;
        typedef NCBI_NS_STD::string TColumnalign;
        typedef NCBI_NS_STD::string TGroupalign;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_rowalign,
            e_columnalign,
            e_groupalign
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef EAttlist_rowalign TRowalign
        ///  Check whether the Rowalign data member has been assigned a value.
        bool IsSetRowalign(void) const;
        /// Check whether it is safe or not to call GetRowalign method.
        bool CanGetRowalign(void) const;
        void ResetRowalign(void);
        TRowalign GetRowalign(void) const;
        void SetRowalign(TRowalign value);
        TRowalign& SetRowalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnalign
        ///  Check whether the Columnalign data member has been assigned a value.
        bool IsSetColumnalign(void) const;
        /// Check whether it is safe or not to call GetColumnalign method.
        bool CanGetColumnalign(void) const;
        void ResetColumnalign(void);
        const TColumnalign& GetColumnalign(void) const;
        void SetColumnalign(const TColumnalign& value);
        void SetColumnalign(TColumnalign&& value);
        TColumnalign& SetColumnalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TGroupalign
        ///  Check whether the Groupalign data member has been assigned a value.
        bool IsSetGroupalign(void) const;
        /// Check whether it is safe or not to call GetGroupalign method.
        bool CanGetGroupalign(void) const;
        void ResetGroupalign(void);
        const TGroupalign& GetGroupalign(void) const;
        void SetGroupalign(const TGroupalign& value);
        void SetGroupalign(TGroupalign&& value);
        TGroupalign& SetGroupalign(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        EAttlist_rowalign m_Rowalign;
        NCBI_NS_STD::string m_Columnalign;
        NCBI_NS_STD::string m_Groupalign;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_TableCellExpression : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_TableCellExpression(void);
        // destructor
        ~C_TableCellExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CTableCellExpression C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CTableCellExpression > > TTableCellExpression;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_TableCellExpression
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CTableCellExpression > > TTableCellExpression
        ///  Check whether the TableCellExpression data member has been assigned a value.
        bool IsSetTableCellExpression(void) const;
        /// Check whether it is safe or not to call GetTableCellExpression method.
        bool CanGetTableCellExpression(void) const;
        void ResetTableCellExpression(void);
        const TTableCellExpression& GetTableCellExpression(void) const;
        TTableCellExpression& SetTableCellExpression(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_TableCellExpression(const C_TableCellExpression&);
        C_TableCellExpression& operator=(const C_TableCellExpression&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CTableCellExpression > > m_TableCellExpression;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_TableCellExpression TTableCellExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_TableCellExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_TableCellExpression TTableCellExpression
    ///  Check whether the TableCellExpression data member has been assigned a value.
    bool IsSetTableCellExpression(void) const;
    /// Check whether it is safe or not to call GetTableCellExpression method.
    bool CanGetTableCellExpression(void) const;
    void ResetTableCellExpression(void);
    const TTableCellExpression& GetTableCellExpression(void) const;
    void SetTableCellExpression(TTableCellExpression& value);
    TTableCellExpression& SetTableCellExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMlabeledtr_Base(const CMlabeledtr_Base&);
    CMlabeledtr_Base& operator=(const CMlabeledtr_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TTableCellExpression > m_TableCellExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMlabeledtr_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMlabeledtr_Base::C_Attlist::TId& CMlabeledtr_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMlabeledtr_Base::C_Attlist::SetId(const CMlabeledtr_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMlabeledtr_Base::C_Attlist::SetId(CMlabeledtr_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMlabeledtr_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMlabeledtr_Base::C_Attlist::TId& CMlabeledtr_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMlabeledtr_Base::C_Attlist::TXref& CMlabeledtr_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMlabeledtr_Base::C_Attlist::SetXref(const CMlabeledtr_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMlabeledtr_Base::C_Attlist::SetXref(CMlabeledtr_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMlabeledtr_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMlabeledtr_Base::C_Attlist::TXref& CMlabeledtr_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMlabeledtr_Base::C_Attlist::TClass& CMlabeledtr_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMlabeledtr_Base::C_Attlist::SetClass(const CMlabeledtr_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMlabeledtr_Base::C_Attlist::SetClass(CMlabeledtr_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMlabeledtr_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMlabeledtr_Base::C_Attlist::TClass& CMlabeledtr_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMlabeledtr_Base::C_Attlist::TStyle& CMlabeledtr_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMlabeledtr_Base::C_Attlist::SetStyle(const CMlabeledtr_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMlabeledtr_Base::C_Attlist::SetStyle(CMlabeledtr_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMlabeledtr_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMlabeledtr_Base::C_Attlist::TStyle& CMlabeledtr_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMlabeledtr_Base::C_Attlist::THref& CMlabeledtr_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMlabeledtr_Base::C_Attlist::SetHref(const CMlabeledtr_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMlabeledtr_Base::C_Attlist::SetHref(CMlabeledtr_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMlabeledtr_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMlabeledtr_Base::C_Attlist::THref& CMlabeledtr_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMlabeledtr_Base::C_Attlist::TMathcolor& CMlabeledtr_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMlabeledtr_Base::C_Attlist::SetMathcolor(const CMlabeledtr_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMlabeledtr_Base::C_Attlist::SetMathcolor(CMlabeledtr_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMlabeledtr_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMlabeledtr_Base::C_Attlist::TMathcolor& CMlabeledtr_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMlabeledtr_Base::C_Attlist::TMathbackground& CMlabeledtr_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMlabeledtr_Base::C_Attlist::SetMathbackground(const CMlabeledtr_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMlabeledtr_Base::C_Attlist::SetMathbackground(CMlabeledtr_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMlabeledtr_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMlabeledtr_Base::C_Attlist::TMathbackground& CMlabeledtr_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetRowalign(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetRowalign(void) const
{
    return IsSetRowalign();
}

inline
void CMlabeledtr_Base::C_Attlist::ResetRowalign(void)
{
    m_Rowalign = (EAttlist_rowalign)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CMlabeledtr_Base::C_Attlist::TRowalign CMlabeledtr_Base::C_Attlist::GetRowalign(void) const
{
    if (!CanGetRowalign()) {
        ThrowUnassigned(7);
    }
    return m_Rowalign;
}

inline
void CMlabeledtr_Base::C_Attlist::SetRowalign(CMlabeledtr_Base::C_Attlist::TRowalign value)
{
    m_Rowalign = value;
    m_set_State[0] |= 0xc000;
}

inline
CMlabeledtr_Base::C_Attlist::TRowalign& CMlabeledtr_Base::C_Attlist::SetRowalign(void)
{
#ifdef _DEBUG
    if (!IsSetRowalign()) {
        memset(&m_Rowalign,UnassignedByte(),sizeof(m_Rowalign));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Rowalign;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetColumnalign(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetColumnalign(void) const
{
    return IsSetColumnalign();
}

inline
const CMlabeledtr_Base::C_Attlist::TColumnalign& CMlabeledtr_Base::C_Attlist::GetColumnalign(void) const
{
    if (!CanGetColumnalign()) {
        ThrowUnassigned(8);
    }
    return m_Columnalign;
}

inline
void CMlabeledtr_Base::C_Attlist::SetColumnalign(const CMlabeledtr_Base::C_Attlist::TColumnalign& value)
{
    m_Columnalign = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMlabeledtr_Base::C_Attlist::SetColumnalign(CMlabeledtr_Base::C_Attlist::TColumnalign&& value)
{
    m_Columnalign = std::forward<CMlabeledtr_Base::C_Attlist::TColumnalign>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMlabeledtr_Base::C_Attlist::TColumnalign& CMlabeledtr_Base::C_Attlist::SetColumnalign(void)
{
#ifdef _DEBUG
    if (!IsSetColumnalign()) {
        m_Columnalign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Columnalign;
}

inline
bool CMlabeledtr_Base::C_Attlist::IsSetGroupalign(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMlabeledtr_Base::C_Attlist::CanGetGroupalign(void) const
{
    return IsSetGroupalign();
}

inline
const CMlabeledtr_Base::C_Attlist::TGroupalign& CMlabeledtr_Base::C_Attlist::GetGroupalign(void) const
{
    if (!CanGetGroupalign()) {
        ThrowUnassigned(9);
    }
    return m_Groupalign;
}

inline
void CMlabeledtr_Base::C_Attlist::SetGroupalign(const CMlabeledtr_Base::C_Attlist::TGroupalign& value)
{
    m_Groupalign = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMlabeledtr_Base::C_Attlist::SetGroupalign(CMlabeledtr_Base::C_Attlist::TGroupalign&& value)
{
    m_Groupalign = std::forward<CMlabeledtr_Base::C_Attlist::TGroupalign>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMlabeledtr_Base::C_Attlist::TGroupalign& CMlabeledtr_Base::C_Attlist::SetGroupalign(void)
{
#ifdef _DEBUG
    if (!IsSetGroupalign()) {
        m_Groupalign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Groupalign;
}

inline
bool CMlabeledtr_Base::C_TableCellExpression::IsSetTableCellExpression(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMlabeledtr_Base::C_TableCellExpression::CanGetTableCellExpression(void) const
{
    return true;
}

inline
const CMlabeledtr_Base::C_TableCellExpression::TTableCellExpression& CMlabeledtr_Base::C_TableCellExpression::GetTableCellExpression(void) const
{
    return m_TableCellExpression;
}

inline
CMlabeledtr_Base::C_TableCellExpression::TTableCellExpression& CMlabeledtr_Base::C_TableCellExpression::SetTableCellExpression(void)
{
    m_set_State[0] |= 0x1;
    return m_TableCellExpression;
}

inline
bool CMlabeledtr_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMlabeledtr_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMlabeledtr_Base::TAttlist& CMlabeledtr_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMlabeledtr_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMlabeledtr_Base::TAttlist& CMlabeledtr_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMlabeledtr_Base::IsSetTableCellExpression(void) const
{
    return m_TableCellExpression.NotEmpty();
}

inline
bool CMlabeledtr_Base::CanGetTableCellExpression(void) const
{
    return true;
}

inline
const CMlabeledtr_Base::TTableCellExpression& CMlabeledtr_Base::GetTableCellExpression(void) const
{
    if ( !m_TableCellExpression ) {
        const_cast<CMlabeledtr_Base*>(this)->ResetTableCellExpression();
    }
    return (*m_TableCellExpression);
}

inline
CMlabeledtr_Base::TTableCellExpression& CMlabeledtr_Base::SetTableCellExpression(void)
{
    if ( !m_TableCellExpression ) {
        ResetTableCellExpression();
    }
    return (*m_TableCellExpression);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MLABELEDTR_BASE_HPP
