/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Article_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAbstract;
class CArticleDate;
class CArticleTitle;
class CAuthorList;
class CDataBankList;
class CELocationID;
class CGrantList;
class CJournal;
class CLanguage;
class CPagination;
class CPublicationTypeList;
class CVernacularTitle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CArticle_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CArticle_Base(void);
    // destructor
    virtual ~CArticle_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_PubModel {
            eAttlist_PubModel_Print                  = 1,
            eAttlist_PubModel_Print_Electronic       = 2,
            eAttlist_PubModel_Electronic             = 3,
            eAttlist_PubModel_Electronic_Print       = 4,
            eAttlist_PubModel_Electronic_eCollection = 5
        };
        
        /// Access to EAttlist_PubModel's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_PubModel)(void);
        
        // types
        typedef EAttlist_PubModel TPubModel;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_PubModel
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_PubModel TPubModel
        ///  Check whether the PubModel data member has been assigned a value.
        bool IsSetPubModel(void) const;
        /// Check whether it is safe or not to call GetPubModel method.
        bool CanGetPubModel(void) const;
        void ResetPubModel(void);
        TPubModel GetPubModel(void) const;
        void SetPubModel(TPubModel value);
        TPubModel& SetPubModel(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_PubModel m_PubModel;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_PE_2 : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_PE_2(void);
        // destructor
        ~C_PE_2(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_PE : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_PE(void);
            // destructor
            ~C_PE(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef CPagination TPagination;
            typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > TELocationID;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_Pagination,
                e_ELocationID
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef CPagination TPagination
            ///  Check whether the Pagination data member has been assigned a value.
            bool IsSetPagination(void) const;
            /// Check whether it is safe or not to call GetPagination method.
            bool CanGetPagination(void) const;
            void ResetPagination(void);
            const TPagination& GetPagination(void) const;
            void SetPagination(TPagination& value);
            TPagination& SetPagination(void);
        
            /// optional
            /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > TELocationID
            ///  Check whether the ELocationID data member has been assigned a value.
            bool IsSetELocationID(void) const;
            /// Check whether it is safe or not to call GetELocationID method.
            bool CanGetELocationID(void) const;
            void ResetELocationID(void);
            const TELocationID& GetELocationID(void) const;
            TELocationID& SetELocationID(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_PE(const C_PE&);
            C_PE& operator=(const C_PE&);
        
            // data
            Uint4 m_set_State[1];
            NCBI_NS_NCBI::CRef< TPagination > m_Pagination;
            NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > m_ELocationID;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_PE,
            e_ELocationID
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_ELocationID+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef C_PE TPE;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > TELocationID;
    
        // getters
        // setters
    
        // typedef C_PE TPE
        bool IsPE(void) const;
        const TPE& GetPE(void) const;
        TPE& SetPE(void);
        void SetPE(TPE& value);
    
        // typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > TELocationID
        bool IsELocationID(void) const;
        const TELocationID& GetELocationID(void) const;
        TELocationID& SetELocationID(void);
    
    
    private:
        // copy constructor and assignment operator
        C_PE_2(const C_PE_2& );
        C_PE_2& operator=(const C_PE_2& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TELocationID> m_ELocationID;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CJournal TJournal;
    typedef CArticleTitle TArticleTitle;
    typedef C_PE_2 TPE_2;
    typedef CAbstract TAbstract;
    typedef CAuthorList TAuthorList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLanguage > > TLanguage;
    typedef CDataBankList TDataBankList;
    typedef CGrantList TGrantList;
    typedef CPublicationTypeList TPublicationTypeList;
    typedef CVernacularTitle TVernacularTitle;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CArticleDate > > TArticleDate;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Journal,
        e_ArticleTitle,
        e_PE_2,
        e_Abstract,
        e_AuthorList,
        e_Language,
        e_DataBankList,
        e_GrantList,
        e_PublicationTypeList,
        e_VernacularTitle,
        e_ArticleDate
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 13> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef CJournal TJournal
    ///  Check whether the Journal data member has been assigned a value.
    bool IsSetJournal(void) const;
    /// Check whether it is safe or not to call GetJournal method.
    bool CanGetJournal(void) const;
    void ResetJournal(void);
    const TJournal& GetJournal(void) const;
    void SetJournal(TJournal& value);
    TJournal& SetJournal(void);

    /// mandatory
    /// typedef CArticleTitle TArticleTitle
    ///  Check whether the ArticleTitle data member has been assigned a value.
    bool IsSetArticleTitle(void) const;
    /// Check whether it is safe or not to call GetArticleTitle method.
    bool CanGetArticleTitle(void) const;
    void ResetArticleTitle(void);
    const TArticleTitle& GetArticleTitle(void) const;
    void SetArticleTitle(TArticleTitle& value);
    TArticleTitle& SetArticleTitle(void);

    /// mandatory
    /// typedef C_PE_2 TPE_2
    ///  Check whether the PE_2 data member has been assigned a value.
    bool IsSetPE_2(void) const;
    /// Check whether it is safe or not to call GetPE_2 method.
    bool CanGetPE_2(void) const;
    void ResetPE_2(void);
    const TPE_2& GetPE_2(void) const;
    void SetPE_2(TPE_2& value);
    TPE_2& SetPE_2(void);

    /// optional
    /// typedef CAbstract TAbstract
    ///  Check whether the Abstract data member has been assigned a value.
    bool IsSetAbstract(void) const;
    /// Check whether it is safe or not to call GetAbstract method.
    bool CanGetAbstract(void) const;
    void ResetAbstract(void);
    const TAbstract& GetAbstract(void) const;
    void SetAbstract(TAbstract& value);
    TAbstract& SetAbstract(void);

    /// optional
    /// typedef CAuthorList TAuthorList
    ///  Check whether the AuthorList data member has been assigned a value.
    bool IsSetAuthorList(void) const;
    /// Check whether it is safe or not to call GetAuthorList method.
    bool CanGetAuthorList(void) const;
    void ResetAuthorList(void);
    const TAuthorList& GetAuthorList(void) const;
    void SetAuthorList(TAuthorList& value);
    TAuthorList& SetAuthorList(void);

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLanguage > > TLanguage
    ///  Check whether the Language data member has been assigned a value.
    bool IsSetLanguage(void) const;
    /// Check whether it is safe or not to call GetLanguage method.
    bool CanGetLanguage(void) const;
    void ResetLanguage(void);
    const TLanguage& GetLanguage(void) const;
    TLanguage& SetLanguage(void);

    /// optional
    /// typedef CDataBankList TDataBankList
    ///  Check whether the DataBankList data member has been assigned a value.
    bool IsSetDataBankList(void) const;
    /// Check whether it is safe or not to call GetDataBankList method.
    bool CanGetDataBankList(void) const;
    void ResetDataBankList(void);
    const TDataBankList& GetDataBankList(void) const;
    void SetDataBankList(TDataBankList& value);
    TDataBankList& SetDataBankList(void);

    /// optional
    /// typedef CGrantList TGrantList
    ///  Check whether the GrantList data member has been assigned a value.
    bool IsSetGrantList(void) const;
    /// Check whether it is safe or not to call GetGrantList method.
    bool CanGetGrantList(void) const;
    void ResetGrantList(void);
    const TGrantList& GetGrantList(void) const;
    void SetGrantList(TGrantList& value);
    TGrantList& SetGrantList(void);

    /// mandatory
    /// typedef CPublicationTypeList TPublicationTypeList
    ///  Check whether the PublicationTypeList data member has been assigned a value.
    bool IsSetPublicationTypeList(void) const;
    /// Check whether it is safe or not to call GetPublicationTypeList method.
    bool CanGetPublicationTypeList(void) const;
    void ResetPublicationTypeList(void);
    const TPublicationTypeList& GetPublicationTypeList(void) const;
    void SetPublicationTypeList(TPublicationTypeList& value);
    TPublicationTypeList& SetPublicationTypeList(void);

    /// optional
    /// typedef CVernacularTitle TVernacularTitle
    ///  Check whether the VernacularTitle data member has been assigned a value.
    bool IsSetVernacularTitle(void) const;
    /// Check whether it is safe or not to call GetVernacularTitle method.
    bool CanGetVernacularTitle(void) const;
    void ResetVernacularTitle(void);
    const TVernacularTitle& GetVernacularTitle(void) const;
    void SetVernacularTitle(TVernacularTitle& value);
    TVernacularTitle& SetVernacularTitle(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CArticleDate > > TArticleDate
    ///  Check whether the ArticleDate data member has been assigned a value.
    bool IsSetArticleDate(void) const;
    /// Check whether it is safe or not to call GetArticleDate method.
    bool CanGetArticleDate(void) const;
    void ResetArticleDate(void);
    const TArticleDate& GetArticleDate(void) const;
    TArticleDate& SetArticleDate(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CArticle_Base(const CArticle_Base&);
    CArticle_Base& operator=(const CArticle_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TJournal > m_Journal;
    NCBI_NS_NCBI::CRef< TArticleTitle > m_ArticleTitle;
    NCBI_NS_NCBI::CRef< TPE_2 > m_PE_2;
    NCBI_NS_NCBI::CRef< TAbstract > m_Abstract;
    NCBI_NS_NCBI::CRef< TAuthorList > m_AuthorList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CLanguage > > m_Language;
    NCBI_NS_NCBI::CRef< TDataBankList > m_DataBankList;
    NCBI_NS_NCBI::CRef< TGrantList > m_GrantList;
    NCBI_NS_NCBI::CRef< TPublicationTypeList > m_PublicationTypeList;
    NCBI_NS_NCBI::CRef< TVernacularTitle > m_VernacularTitle;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CArticleDate > > m_ArticleDate;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CArticle_Base::C_Attlist::IsSetPubModel(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CArticle_Base::C_Attlist::CanGetPubModel(void) const
{
    return IsSetPubModel();
}

inline
void CArticle_Base::C_Attlist::ResetPubModel(void)
{
    m_PubModel = (EAttlist_PubModel)(0);
    m_set_State[0] &= ~0x3;
}

inline
CArticle_Base::C_Attlist::TPubModel CArticle_Base::C_Attlist::GetPubModel(void) const
{
    if (!CanGetPubModel()) {
        ThrowUnassigned(0);
    }
    return m_PubModel;
}

inline
void CArticle_Base::C_Attlist::SetPubModel(CArticle_Base::C_Attlist::TPubModel value)
{
    m_PubModel = value;
    m_set_State[0] |= 0x3;
}

inline
CArticle_Base::C_Attlist::TPubModel& CArticle_Base::C_Attlist::SetPubModel(void)
{
#ifdef _DEBUG
    if (!IsSetPubModel()) {
        memset(&m_PubModel,UnassignedByte(),sizeof(m_PubModel));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_PubModel;
}

inline
bool CArticle_Base::C_PE_2::C_PE::IsSetPagination(void) const
{
    return m_Pagination.NotEmpty();
}

inline
bool CArticle_Base::C_PE_2::C_PE::CanGetPagination(void) const
{
    return true;
}

inline
const CArticle_Base::C_PE_2::C_PE::TPagination& CArticle_Base::C_PE_2::C_PE::GetPagination(void) const
{
    if ( !m_Pagination ) {
        const_cast<C_PE*>(this)->ResetPagination();
    }
    return (*m_Pagination);
}

inline
CArticle_Base::C_PE_2::C_PE::TPagination& CArticle_Base::C_PE_2::C_PE::SetPagination(void)
{
    if ( !m_Pagination ) {
        ResetPagination();
    }
    return (*m_Pagination);
}

inline
bool CArticle_Base::C_PE_2::C_PE::IsSetELocationID(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CArticle_Base::C_PE_2::C_PE::CanGetELocationID(void) const
{
    return true;
}

inline
const CArticle_Base::C_PE_2::C_PE::TELocationID& CArticle_Base::C_PE_2::C_PE::GetELocationID(void) const
{
    return m_ELocationID;
}

inline
CArticle_Base::C_PE_2::C_PE::TELocationID& CArticle_Base::C_PE_2::C_PE::SetELocationID(void)
{
    m_set_State[0] |= 0x4;
    return m_ELocationID;
}

inline
CArticle_Base::C_PE_2::E_Choice CArticle_Base::C_PE_2::Which(void) const
{
    return m_choice;
}

inline
void CArticle_Base::C_PE_2::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CArticle_Base::C_PE_2::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CArticle_Base::C_PE_2::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CArticle_Base::C_PE_2::IsPE(void) const
{
    return m_choice == e_PE;
}

inline
bool CArticle_Base::C_PE_2::IsELocationID(void) const
{
    return m_choice == e_ELocationID;
}

inline
const CArticle_Base::C_PE_2::TELocationID& CArticle_Base::C_PE_2::GetELocationID(void) const
{
    CheckSelected(e_ELocationID);
    return *m_ELocationID;
}

inline
CArticle_Base::C_PE_2::TELocationID& CArticle_Base::C_PE_2::SetELocationID(void)
{
    Select(e_ELocationID, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_ELocationID;
}

inline
bool CArticle_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CArticle_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CArticle_Base::TAttlist& CArticle_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CArticle_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CArticle_Base::TAttlist& CArticle_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CArticle_Base::IsSetJournal(void) const
{
    return m_Journal.NotEmpty();
}

inline
bool CArticle_Base::CanGetJournal(void) const
{
    return true;
}

inline
const CArticle_Base::TJournal& CArticle_Base::GetJournal(void) const
{
    if ( !m_Journal ) {
        const_cast<CArticle_Base*>(this)->ResetJournal();
    }
    return (*m_Journal);
}

inline
CArticle_Base::TJournal& CArticle_Base::SetJournal(void)
{
    if ( !m_Journal ) {
        ResetJournal();
    }
    return (*m_Journal);
}

inline
bool CArticle_Base::IsSetArticleTitle(void) const
{
    return m_ArticleTitle.NotEmpty();
}

inline
bool CArticle_Base::CanGetArticleTitle(void) const
{
    return true;
}

inline
const CArticle_Base::TArticleTitle& CArticle_Base::GetArticleTitle(void) const
{
    if ( !m_ArticleTitle ) {
        const_cast<CArticle_Base*>(this)->ResetArticleTitle();
    }
    return (*m_ArticleTitle);
}

inline
CArticle_Base::TArticleTitle& CArticle_Base::SetArticleTitle(void)
{
    if ( !m_ArticleTitle ) {
        ResetArticleTitle();
    }
    return (*m_ArticleTitle);
}

inline
bool CArticle_Base::IsSetPE_2(void) const
{
    return m_PE_2.NotEmpty();
}

inline
bool CArticle_Base::CanGetPE_2(void) const
{
    return true;
}

inline
const CArticle_Base::TPE_2& CArticle_Base::GetPE_2(void) const
{
    if ( !m_PE_2 ) {
        const_cast<CArticle_Base*>(this)->ResetPE_2();
    }
    return (*m_PE_2);
}

inline
CArticle_Base::TPE_2& CArticle_Base::SetPE_2(void)
{
    if ( !m_PE_2 ) {
        ResetPE_2();
    }
    return (*m_PE_2);
}

inline
bool CArticle_Base::IsSetAbstract(void) const
{
    return m_Abstract.NotEmpty();
}

inline
bool CArticle_Base::CanGetAbstract(void) const
{
    return IsSetAbstract();
}

inline
const CArticle_Base::TAbstract& CArticle_Base::GetAbstract(void) const
{
    if (!CanGetAbstract()) {
        ThrowUnassigned(4);
    }
    return (*m_Abstract);
}

inline
bool CArticle_Base::IsSetAuthorList(void) const
{
    return m_AuthorList.NotEmpty();
}

inline
bool CArticle_Base::CanGetAuthorList(void) const
{
    return IsSetAuthorList();
}

inline
const CArticle_Base::TAuthorList& CArticle_Base::GetAuthorList(void) const
{
    if (!CanGetAuthorList()) {
        ThrowUnassigned(5);
    }
    return (*m_AuthorList);
}

inline
bool CArticle_Base::IsSetLanguage(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CArticle_Base::CanGetLanguage(void) const
{
    return true;
}

inline
const CArticle_Base::TLanguage& CArticle_Base::GetLanguage(void) const
{
    return m_Language;
}

inline
CArticle_Base::TLanguage& CArticle_Base::SetLanguage(void)
{
    m_set_State[0] |= 0x1000;
    return m_Language;
}

inline
bool CArticle_Base::IsSetDataBankList(void) const
{
    return m_DataBankList.NotEmpty();
}

inline
bool CArticle_Base::CanGetDataBankList(void) const
{
    return IsSetDataBankList();
}

inline
const CArticle_Base::TDataBankList& CArticle_Base::GetDataBankList(void) const
{
    if (!CanGetDataBankList()) {
        ThrowUnassigned(7);
    }
    return (*m_DataBankList);
}

inline
bool CArticle_Base::IsSetGrantList(void) const
{
    return m_GrantList.NotEmpty();
}

inline
bool CArticle_Base::CanGetGrantList(void) const
{
    return IsSetGrantList();
}

inline
const CArticle_Base::TGrantList& CArticle_Base::GetGrantList(void) const
{
    if (!CanGetGrantList()) {
        ThrowUnassigned(8);
    }
    return (*m_GrantList);
}

inline
bool CArticle_Base::IsSetPublicationTypeList(void) const
{
    return m_PublicationTypeList.NotEmpty();
}

inline
bool CArticle_Base::CanGetPublicationTypeList(void) const
{
    return true;
}

inline
const CArticle_Base::TPublicationTypeList& CArticle_Base::GetPublicationTypeList(void) const
{
    if ( !m_PublicationTypeList ) {
        const_cast<CArticle_Base*>(this)->ResetPublicationTypeList();
    }
    return (*m_PublicationTypeList);
}

inline
CArticle_Base::TPublicationTypeList& CArticle_Base::SetPublicationTypeList(void)
{
    if ( !m_PublicationTypeList ) {
        ResetPublicationTypeList();
    }
    return (*m_PublicationTypeList);
}

inline
bool CArticle_Base::IsSetVernacularTitle(void) const
{
    return m_VernacularTitle.NotEmpty();
}

inline
bool CArticle_Base::CanGetVernacularTitle(void) const
{
    return IsSetVernacularTitle();
}

inline
const CArticle_Base::TVernacularTitle& CArticle_Base::GetVernacularTitle(void) const
{
    if (!CanGetVernacularTitle()) {
        ThrowUnassigned(10);
    }
    return (*m_VernacularTitle);
}

inline
bool CArticle_Base::IsSetArticleDate(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CArticle_Base::CanGetArticleDate(void) const
{
    return true;
}

inline
const CArticle_Base::TArticleDate& CArticle_Base::GetArticleDate(void) const
{
    return m_ArticleDate;
}

inline
CArticle_Base::TArticleDate& CArticle_Base::SetArticleDate(void)
{
    m_set_State[0] |= 0x400000;
    return m_ArticleDate;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ARTICLE_BASE_HPP
