/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DbsnpTooltipSection_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'dbsnp_tooltip_service.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSECTION_BASE_HPP
#define OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSECTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbsnpTooltipSectionValue;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDbsnpTooltipSection_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDbsnpTooltipSection_Base(void);
    // destructor
    virtual ~CDbsnpTooltipSection_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TSection;
    typedef list< CRef< CDbsnpTooltipSectionValue > > TValues;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_section,
        e_values
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Section name.
    /// Some of section have predefined names
    /// for details please check https://confluence.ncbi.nlm.nih.gov/display/VAR/SViewer+Tooltips
    /// optional
    /// typedef string TSection
    ///  Check whether the Section data member has been assigned a value.
    bool IsSetSection(void) const;
    /// Check whether it is safe or not to call GetSection method.
    bool CanGetSection(void) const;
    void ResetSection(void);
    const TSection& GetSection(void) const;
    void SetSection(const TSection& value);
    void SetSection(TSection&& value);
    TSection& SetSection(void);

    /// A list of values pertaining to this section.
    /// mandatory
    /// typedef list< CRef< CDbsnpTooltipSectionValue > > TValues
    ///  Check whether the Values data member has been assigned a value.
    bool IsSetValues(void) const;
    /// Check whether it is safe or not to call GetValues method.
    bool CanGetValues(void) const;
    void ResetValues(void);
    const TValues& GetValues(void) const;
    TValues& SetValues(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDbsnpTooltipSection_Base(const CDbsnpTooltipSection_Base&);
    CDbsnpTooltipSection_Base& operator=(const CDbsnpTooltipSection_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Section;
    list< CRef< CDbsnpTooltipSectionValue > > m_Values;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDbsnpTooltipSection_Base::IsSetSection(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDbsnpTooltipSection_Base::CanGetSection(void) const
{
    return IsSetSection();
}

inline
const CDbsnpTooltipSection_Base::TSection& CDbsnpTooltipSection_Base::GetSection(void) const
{
    if (!CanGetSection()) {
        ThrowUnassigned(0);
    }
    return m_Section;
}

inline
void CDbsnpTooltipSection_Base::SetSection(const CDbsnpTooltipSection_Base::TSection& value)
{
    m_Section = value;
    m_set_State[0] |= 0x3;
}

inline
void CDbsnpTooltipSection_Base::SetSection(CDbsnpTooltipSection_Base::TSection&& value)
{
    m_Section = std::forward<CDbsnpTooltipSection_Base::TSection>(value);
    m_set_State[0] |= 0x3;
}

inline
CDbsnpTooltipSection_Base::TSection& CDbsnpTooltipSection_Base::SetSection(void)
{
#ifdef _DEBUG
    if (!IsSetSection()) {
        m_Section = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Section;
}

inline
bool CDbsnpTooltipSection_Base::IsSetValues(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDbsnpTooltipSection_Base::CanGetValues(void) const
{
    return true;
}

inline
const CDbsnpTooltipSection_Base::TValues& CDbsnpTooltipSection_Base::GetValues(void) const
{
    return m_Values;
}

inline
CDbsnpTooltipSection_Base::TValues& CDbsnpTooltipSection_Base::SetValues(void)
{
    m_set_State[0] |= 0x4;
    return m_Values;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSECTION_BASE_HPP
