/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_DisplayTrackRequest_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_DISPLAYTRACKREQUEST_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_DISPLAYTRACKREQUEST_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_AttrSpec;
class CTMgr_ClientInfo;
class CTMgr_GenomeContext;
class CTMgr_Identity;
class CTMgr_TrackACL_Authorization;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_DisplayTrackRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_DisplayTrackRequest_Base(void);
    // destructor
    virtual ~CTMgr_DisplayTrackRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_TRACKMGR_EXPORT C_Flags : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Flags(void);
        // destructor
        ~C_Flags(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef bool TInclude_stats;
        typedef bool TInclude_default_tracks;
        typedef bool TInclude_track_items;
        typedef bool TExpanded_rid_details;
        typedef bool TInclude_track_hubs;
        typedef bool TInclude_TMS_tracks;
        typedef bool TInclude_user_tracks;
        typedef bool TInclude_remote_tracks;
        typedef bool TUse_multiple_containers;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_include_stats,
            e_include_default_tracks,
            e_include_track_items,
            e_expanded_rid_details,
            e_include_track_hubs,
            e_include_TMS_tracks,
            e_include_user_tracks,
            e_include_remote_tracks,
            e_use_multiple_containers
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default false
        /// typedef bool TInclude_stats
        ///  Check whether the Include_stats data member has been assigned a value.
        bool IsSetInclude_stats(void) const;
        /// Check whether it is safe or not to call GetInclude_stats method.
        bool CanGetInclude_stats(void) const;
        void ResetInclude_stats(void);
        void SetDefaultInclude_stats(void);
        TInclude_stats GetInclude_stats(void) const;
        void SetInclude_stats(TInclude_stats value);
        TInclude_stats& SetInclude_stats(void);
    
        /// optional with default false
        /// typedef bool TInclude_default_tracks
        ///  Check whether the Include_default_tracks data member has been assigned a value.
        bool IsSetInclude_default_tracks(void) const;
        /// Check whether it is safe or not to call GetInclude_default_tracks method.
        bool CanGetInclude_default_tracks(void) const;
        void ResetInclude_default_tracks(void);
        void SetDefaultInclude_default_tracks(void);
        TInclude_default_tracks GetInclude_default_tracks(void) const;
        void SetInclude_default_tracks(TInclude_default_tracks value);
        TInclude_default_tracks& SetInclude_default_tracks(void);
    
        /// optional with default false
        /// typedef bool TInclude_track_items
        ///  Check whether the Include_track_items data member has been assigned a value.
        bool IsSetInclude_track_items(void) const;
        /// Check whether it is safe or not to call GetInclude_track_items method.
        bool CanGetInclude_track_items(void) const;
        void ResetInclude_track_items(void);
        void SetDefaultInclude_track_items(void);
        TInclude_track_items GetInclude_track_items(void) const;
        void SetInclude_track_items(TInclude_track_items value);
        TInclude_track_items& SetInclude_track_items(void);
    
        /// optional with default false
        /// typedef bool TExpanded_rid_details
        ///  Check whether the Expanded_rid_details data member has been assigned a value.
        bool IsSetExpanded_rid_details(void) const;
        /// Check whether it is safe or not to call GetExpanded_rid_details method.
        bool CanGetExpanded_rid_details(void) const;
        void ResetExpanded_rid_details(void);
        void SetDefaultExpanded_rid_details(void);
        TExpanded_rid_details GetExpanded_rid_details(void) const;
        void SetExpanded_rid_details(TExpanded_rid_details value);
        TExpanded_rid_details& SetExpanded_rid_details(void);
    
        /// optional with default false
        /// typedef bool TInclude_track_hubs
        ///  Check whether the Include_track_hubs data member has been assigned a value.
        bool IsSetInclude_track_hubs(void) const;
        /// Check whether it is safe or not to call GetInclude_track_hubs method.
        bool CanGetInclude_track_hubs(void) const;
        void ResetInclude_track_hubs(void);
        void SetDefaultInclude_track_hubs(void);
        TInclude_track_hubs GetInclude_track_hubs(void) const;
        void SetInclude_track_hubs(TInclude_track_hubs value);
        TInclude_track_hubs& SetInclude_track_hubs(void);
    
        /// optional with default true
        /// typedef bool TInclude_TMS_tracks
        ///  Check whether the Include_TMS_tracks data member has been assigned a value.
        bool IsSetInclude_TMS_tracks(void) const;
        /// Check whether it is safe or not to call GetInclude_TMS_tracks method.
        bool CanGetInclude_TMS_tracks(void) const;
        void ResetInclude_TMS_tracks(void);
        void SetDefaultInclude_TMS_tracks(void);
        TInclude_TMS_tracks GetInclude_TMS_tracks(void) const;
        void SetInclude_TMS_tracks(TInclude_TMS_tracks value);
        TInclude_TMS_tracks& SetInclude_TMS_tracks(void);
    
        /// optional with default true
        /// typedef bool TInclude_user_tracks
        ///  Check whether the Include_user_tracks data member has been assigned a value.
        bool IsSetInclude_user_tracks(void) const;
        /// Check whether it is safe or not to call GetInclude_user_tracks method.
        bool CanGetInclude_user_tracks(void) const;
        void ResetInclude_user_tracks(void);
        void SetDefaultInclude_user_tracks(void);
        TInclude_user_tracks GetInclude_user_tracks(void) const;
        void SetInclude_user_tracks(TInclude_user_tracks value);
        TInclude_user_tracks& SetInclude_user_tracks(void);
    
        /// optional with default true
        /// typedef bool TInclude_remote_tracks
        ///  Check whether the Include_remote_tracks data member has been assigned a value.
        bool IsSetInclude_remote_tracks(void) const;
        /// Check whether it is safe or not to call GetInclude_remote_tracks method.
        bool CanGetInclude_remote_tracks(void) const;
        void ResetInclude_remote_tracks(void);
        void SetDefaultInclude_remote_tracks(void);
        TInclude_remote_tracks GetInclude_remote_tracks(void) const;
        void SetInclude_remote_tracks(TInclude_remote_tracks value);
        TInclude_remote_tracks& SetInclude_remote_tracks(void);
    
        /// optional with default false
        /// typedef bool TUse_multiple_containers
        ///  Check whether the Use_multiple_containers data member has been assigned a value.
        bool IsSetUse_multiple_containers(void) const;
        /// Check whether it is safe or not to call GetUse_multiple_containers method.
        bool CanGetUse_multiple_containers(void) const;
        void ResetUse_multiple_containers(void);
        void SetDefaultUse_multiple_containers(void);
        TUse_multiple_containers GetUse_multiple_containers(void) const;
        void SetUse_multiple_containers(TUse_multiple_containers value);
        TUse_multiple_containers& SetUse_multiple_containers(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Flags(const C_Flags&);
        C_Flags& operator=(const C_Flags&);
    
        // data
        Uint4 m_set_State[1];
        bool m_Include_stats;
        bool m_Include_default_tracks;
        bool m_Include_track_items;
        bool m_Expanded_rid_details;
        bool m_Include_track_hubs;
        bool m_Include_TMS_tracks;
        bool m_Include_user_tracks;
        bool m_Include_remote_tracks;
        bool m_Use_multiple_containers;
    };
    // types
    typedef CTMgr_ClientInfo TClient;
    typedef CTMgr_GenomeContext TGenome_context;
    typedef list< CRef< CTMgr_AttrSpec > > TAttrs;
    typedef CTMgr_Identity TIdentity;
    typedef CTMgr_TrackACL_Authorization TAuthorization;
    typedef C_Flags TFlags;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_client,
        e_genome_context,
        e_attrs,
        e_identity,
        e_authorization,
        e_flags
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CTMgr_ClientInfo TClient
    ///  Check whether the Client data member has been assigned a value.
    bool IsSetClient(void) const;
    /// Check whether it is safe or not to call GetClient method.
    bool CanGetClient(void) const;
    void ResetClient(void);
    const TClient& GetClient(void) const;
    void SetClient(TClient& value);
    TClient& SetClient(void);

    /// mandatory
    /// typedef CTMgr_GenomeContext TGenome_context
    ///  Check whether the Genome_context data member has been assigned a value.
    bool IsSetGenome_context(void) const;
    /// Check whether it is safe or not to call GetGenome_context method.
    bool CanGetGenome_context(void) const;
    void ResetGenome_context(void);
    const TGenome_context& GetGenome_context(void) const;
    void SetGenome_context(TGenome_context& value);
    TGenome_context& SetGenome_context(void);

    /// optional
    /// typedef list< CRef< CTMgr_AttrSpec > > TAttrs
    ///  Check whether the Attrs data member has been assigned a value.
    bool IsSetAttrs(void) const;
    /// Check whether it is safe or not to call GetAttrs method.
    bool CanGetAttrs(void) const;
    void ResetAttrs(void);
    const TAttrs& GetAttrs(void) const;
    TAttrs& SetAttrs(void);

    /// optional
    /// typedef CTMgr_Identity TIdentity
    ///  Check whether the Identity data member has been assigned a value.
    bool IsSetIdentity(void) const;
    /// Check whether it is safe or not to call GetIdentity method.
    bool CanGetIdentity(void) const;
    void ResetIdentity(void);
    const TIdentity& GetIdentity(void) const;
    void SetIdentity(TIdentity& value);
    TIdentity& SetIdentity(void);

    /// optional
    /// typedef CTMgr_TrackACL_Authorization TAuthorization
    ///  Check whether the Authorization data member has been assigned a value.
    bool IsSetAuthorization(void) const;
    /// Check whether it is safe or not to call GetAuthorization method.
    bool CanGetAuthorization(void) const;
    void ResetAuthorization(void);
    const TAuthorization& GetAuthorization(void) const;
    void SetAuthorization(TAuthorization& value);
    TAuthorization& SetAuthorization(void);

    /// optional
    /// typedef C_Flags TFlags
    ///  Check whether the Flags data member has been assigned a value.
    bool IsSetFlags(void) const;
    /// Check whether it is safe or not to call GetFlags method.
    bool CanGetFlags(void) const;
    void ResetFlags(void);
    const TFlags& GetFlags(void) const;
    void SetFlags(TFlags& value);
    TFlags& SetFlags(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_DisplayTrackRequest_Base(const CTMgr_DisplayTrackRequest_Base&);
    CTMgr_DisplayTrackRequest_Base& operator=(const CTMgr_DisplayTrackRequest_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TClient > m_Client;
    CRef< TGenome_context > m_Genome_context;
    list< CRef< CTMgr_AttrSpec > > m_Attrs;
    CRef< TIdentity > m_Identity;
    CRef< TAuthorization > m_Authorization;
    CRef< TFlags > m_Flags;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetInclude_stats(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetInclude_stats(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetInclude_stats(void)
{
    m_Include_stats = false;
    m_set_State[0] &= ~0x3;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultInclude_stats(void)
{
    ResetInclude_stats();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_stats CTMgr_DisplayTrackRequest_Base::C_Flags::GetInclude_stats(void) const
{
    return m_Include_stats;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_stats(CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_stats value)
{
    m_Include_stats = value;
    m_set_State[0] |= 0x3;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_stats& CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_stats(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_stats()) {
        memset(&m_Include_stats,UnassignedByte(),sizeof(m_Include_stats));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Include_stats;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetInclude_default_tracks(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetInclude_default_tracks(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetInclude_default_tracks(void)
{
    m_Include_default_tracks = false;
    m_set_State[0] &= ~0xc;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultInclude_default_tracks(void)
{
    ResetInclude_default_tracks();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_default_tracks CTMgr_DisplayTrackRequest_Base::C_Flags::GetInclude_default_tracks(void) const
{
    return m_Include_default_tracks;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_default_tracks(CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_default_tracks value)
{
    m_Include_default_tracks = value;
    m_set_State[0] |= 0xc;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_default_tracks& CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_default_tracks(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_default_tracks()) {
        memset(&m_Include_default_tracks,UnassignedByte(),sizeof(m_Include_default_tracks));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Include_default_tracks;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetInclude_track_items(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetInclude_track_items(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetInclude_track_items(void)
{
    m_Include_track_items = false;
    m_set_State[0] &= ~0x30;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultInclude_track_items(void)
{
    ResetInclude_track_items();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_track_items CTMgr_DisplayTrackRequest_Base::C_Flags::GetInclude_track_items(void) const
{
    return m_Include_track_items;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_track_items(CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_track_items value)
{
    m_Include_track_items = value;
    m_set_State[0] |= 0x30;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_track_items& CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_track_items(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_track_items()) {
        memset(&m_Include_track_items,UnassignedByte(),sizeof(m_Include_track_items));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Include_track_items;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetExpanded_rid_details(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetExpanded_rid_details(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetExpanded_rid_details(void)
{
    m_Expanded_rid_details = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultExpanded_rid_details(void)
{
    ResetExpanded_rid_details();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TExpanded_rid_details CTMgr_DisplayTrackRequest_Base::C_Flags::GetExpanded_rid_details(void) const
{
    return m_Expanded_rid_details;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetExpanded_rid_details(CTMgr_DisplayTrackRequest_Base::C_Flags::TExpanded_rid_details value)
{
    m_Expanded_rid_details = value;
    m_set_State[0] |= 0xc0;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TExpanded_rid_details& CTMgr_DisplayTrackRequest_Base::C_Flags::SetExpanded_rid_details(void)
{
#ifdef _DEBUG
    if (!IsSetExpanded_rid_details()) {
        memset(&m_Expanded_rid_details,UnassignedByte(),sizeof(m_Expanded_rid_details));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Expanded_rid_details;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetInclude_track_hubs(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetInclude_track_hubs(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetInclude_track_hubs(void)
{
    m_Include_track_hubs = false;
    m_set_State[0] &= ~0x300;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultInclude_track_hubs(void)
{
    ResetInclude_track_hubs();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_track_hubs CTMgr_DisplayTrackRequest_Base::C_Flags::GetInclude_track_hubs(void) const
{
    return m_Include_track_hubs;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_track_hubs(CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_track_hubs value)
{
    m_Include_track_hubs = value;
    m_set_State[0] |= 0x300;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_track_hubs& CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_track_hubs(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_track_hubs()) {
        memset(&m_Include_track_hubs,UnassignedByte(),sizeof(m_Include_track_hubs));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Include_track_hubs;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetInclude_TMS_tracks(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetInclude_TMS_tracks(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetInclude_TMS_tracks(void)
{
    m_Include_TMS_tracks = true;
    m_set_State[0] &= ~0xc00;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultInclude_TMS_tracks(void)
{
    ResetInclude_TMS_tracks();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_TMS_tracks CTMgr_DisplayTrackRequest_Base::C_Flags::GetInclude_TMS_tracks(void) const
{
    return m_Include_TMS_tracks;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_TMS_tracks(CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_TMS_tracks value)
{
    m_Include_TMS_tracks = value;
    m_set_State[0] |= 0xc00;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_TMS_tracks& CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_TMS_tracks(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_TMS_tracks()) {
        memset(&m_Include_TMS_tracks,UnassignedByte(),sizeof(m_Include_TMS_tracks));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Include_TMS_tracks;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetInclude_user_tracks(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetInclude_user_tracks(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetInclude_user_tracks(void)
{
    m_Include_user_tracks = true;
    m_set_State[0] &= ~0x3000;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultInclude_user_tracks(void)
{
    ResetInclude_user_tracks();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_user_tracks CTMgr_DisplayTrackRequest_Base::C_Flags::GetInclude_user_tracks(void) const
{
    return m_Include_user_tracks;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_user_tracks(CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_user_tracks value)
{
    m_Include_user_tracks = value;
    m_set_State[0] |= 0x3000;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_user_tracks& CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_user_tracks(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_user_tracks()) {
        memset(&m_Include_user_tracks,UnassignedByte(),sizeof(m_Include_user_tracks));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Include_user_tracks;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetInclude_remote_tracks(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetInclude_remote_tracks(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetInclude_remote_tracks(void)
{
    m_Include_remote_tracks = true;
    m_set_State[0] &= ~0xc000;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultInclude_remote_tracks(void)
{
    ResetInclude_remote_tracks();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_remote_tracks CTMgr_DisplayTrackRequest_Base::C_Flags::GetInclude_remote_tracks(void) const
{
    return m_Include_remote_tracks;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_remote_tracks(CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_remote_tracks value)
{
    m_Include_remote_tracks = value;
    m_set_State[0] |= 0xc000;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TInclude_remote_tracks& CTMgr_DisplayTrackRequest_Base::C_Flags::SetInclude_remote_tracks(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_remote_tracks()) {
        memset(&m_Include_remote_tracks,UnassignedByte(),sizeof(m_Include_remote_tracks));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Include_remote_tracks;
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::IsSetUse_multiple_containers(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::C_Flags::CanGetUse_multiple_containers(void) const
{
    return true;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::ResetUse_multiple_containers(void)
{
    m_Use_multiple_containers = false;
    m_set_State[0] &= ~0x30000;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetDefaultUse_multiple_containers(void)
{
    ResetUse_multiple_containers();
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TUse_multiple_containers CTMgr_DisplayTrackRequest_Base::C_Flags::GetUse_multiple_containers(void) const
{
    return m_Use_multiple_containers;
}

inline
void CTMgr_DisplayTrackRequest_Base::C_Flags::SetUse_multiple_containers(CTMgr_DisplayTrackRequest_Base::C_Flags::TUse_multiple_containers value)
{
    m_Use_multiple_containers = value;
    m_set_State[0] |= 0x30000;
}

inline
CTMgr_DisplayTrackRequest_Base::C_Flags::TUse_multiple_containers& CTMgr_DisplayTrackRequest_Base::C_Flags::SetUse_multiple_containers(void)
{
#ifdef _DEBUG
    if (!IsSetUse_multiple_containers()) {
        memset(&m_Use_multiple_containers,UnassignedByte(),sizeof(m_Use_multiple_containers));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Use_multiple_containers;
}

inline
bool CTMgr_DisplayTrackRequest_Base::IsSetClient(void) const
{
    return m_Client.NotEmpty();
}

inline
bool CTMgr_DisplayTrackRequest_Base::CanGetClient(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackRequest_Base::TClient& CTMgr_DisplayTrackRequest_Base::GetClient(void) const
{
    if ( !m_Client ) {
        const_cast<CTMgr_DisplayTrackRequest_Base*>(this)->ResetClient();
    }
    return (*m_Client);
}

inline
CTMgr_DisplayTrackRequest_Base::TClient& CTMgr_DisplayTrackRequest_Base::SetClient(void)
{
    if ( !m_Client ) {
        ResetClient();
    }
    return (*m_Client);
}

inline
bool CTMgr_DisplayTrackRequest_Base::IsSetGenome_context(void) const
{
    return m_Genome_context.NotEmpty();
}

inline
bool CTMgr_DisplayTrackRequest_Base::CanGetGenome_context(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackRequest_Base::TGenome_context& CTMgr_DisplayTrackRequest_Base::GetGenome_context(void) const
{
    if ( !m_Genome_context ) {
        const_cast<CTMgr_DisplayTrackRequest_Base*>(this)->ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
CTMgr_DisplayTrackRequest_Base::TGenome_context& CTMgr_DisplayTrackRequest_Base::SetGenome_context(void)
{
    if ( !m_Genome_context ) {
        ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
bool CTMgr_DisplayTrackRequest_Base::IsSetAttrs(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_DisplayTrackRequest_Base::CanGetAttrs(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrackRequest_Base::TAttrs& CTMgr_DisplayTrackRequest_Base::GetAttrs(void) const
{
    return m_Attrs;
}

inline
CTMgr_DisplayTrackRequest_Base::TAttrs& CTMgr_DisplayTrackRequest_Base::SetAttrs(void)
{
    m_set_State[0] |= 0x10;
    return m_Attrs;
}

inline
bool CTMgr_DisplayTrackRequest_Base::IsSetIdentity(void) const
{
    return m_Identity.NotEmpty();
}

inline
bool CTMgr_DisplayTrackRequest_Base::CanGetIdentity(void) const
{
    return IsSetIdentity();
}

inline
const CTMgr_DisplayTrackRequest_Base::TIdentity& CTMgr_DisplayTrackRequest_Base::GetIdentity(void) const
{
    if (!CanGetIdentity()) {
        ThrowUnassigned(3);
    }
    return (*m_Identity);
}

inline
bool CTMgr_DisplayTrackRequest_Base::IsSetAuthorization(void) const
{
    return m_Authorization.NotEmpty();
}

inline
bool CTMgr_DisplayTrackRequest_Base::CanGetAuthorization(void) const
{
    return IsSetAuthorization();
}

inline
const CTMgr_DisplayTrackRequest_Base::TAuthorization& CTMgr_DisplayTrackRequest_Base::GetAuthorization(void) const
{
    if (!CanGetAuthorization()) {
        ThrowUnassigned(4);
    }
    return (*m_Authorization);
}

inline
bool CTMgr_DisplayTrackRequest_Base::IsSetFlags(void) const
{
    return m_Flags.NotEmpty();
}

inline
bool CTMgr_DisplayTrackRequest_Base::CanGetFlags(void) const
{
    return IsSetFlags();
}

inline
const CTMgr_DisplayTrackRequest_Base::TFlags& CTMgr_DisplayTrackRequest_Base::GetFlags(void) const
{
    if (!CanGetFlags()) {
        ThrowUnassigned(5);
    }
    return (*m_Flags);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_DISPLAYTRACKREQUEST_BASE_HPP
