/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_DatasetItemSeq_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_DATASETITEMSEQ_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_DATASETITEMSEQ_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;
class CTMgr_AnnotCounts;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_DatasetItemSeq_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_DatasetItemSeq_Base(void);
    // destructor
    virtual ~CTMgr_DatasetItemSeq_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TSeq_id;
    typedef CTMgr_AnnotCounts TCounts;
    typedef CSeq_id TSeq_id2;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq_id,
        e_counts,
        e_seq_id2
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeq_id TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    void SetSeq_id(TSeq_id& value);
    TSeq_id& SetSeq_id(void);

    /// optional
    /// typedef CTMgr_AnnotCounts TCounts
    ///  Check whether the Counts data member has been assigned a value.
    bool IsSetCounts(void) const;
    /// Check whether it is safe or not to call GetCounts method.
    bool CanGetCounts(void) const;
    void ResetCounts(void);
    const TCounts& GetCounts(void) const;
    void SetCounts(TCounts& value);
    TCounts& SetCounts(void);

    /// optional
    /// typedef CSeq_id TSeq_id2
    ///  Check whether the Seq_id2 data member has been assigned a value.
    bool IsSetSeq_id2(void) const;
    /// Check whether it is safe or not to call GetSeq_id2 method.
    bool CanGetSeq_id2(void) const;
    void ResetSeq_id2(void);
    const TSeq_id2& GetSeq_id2(void) const;
    void SetSeq_id2(TSeq_id2& value);
    TSeq_id2& SetSeq_id2(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_DatasetItemSeq_Base(const CTMgr_DatasetItemSeq_Base&);
    CTMgr_DatasetItemSeq_Base& operator=(const CTMgr_DatasetItemSeq_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeq_id > m_Seq_id;
    CRef< TCounts > m_Counts;
    CRef< TSeq_id2 > m_Seq_id2;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_DatasetItemSeq_Base::IsSetSeq_id(void) const
{
    return m_Seq_id.NotEmpty();
}

inline
bool CTMgr_DatasetItemSeq_Base::CanGetSeq_id(void) const
{
    return true;
}

inline
const CTMgr_DatasetItemSeq_Base::TSeq_id& CTMgr_DatasetItemSeq_Base::GetSeq_id(void) const
{
    if ( !m_Seq_id ) {
        const_cast<CTMgr_DatasetItemSeq_Base*>(this)->ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
CTMgr_DatasetItemSeq_Base::TSeq_id& CTMgr_DatasetItemSeq_Base::SetSeq_id(void)
{
    if ( !m_Seq_id ) {
        ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
bool CTMgr_DatasetItemSeq_Base::IsSetCounts(void) const
{
    return m_Counts.NotEmpty();
}

inline
bool CTMgr_DatasetItemSeq_Base::CanGetCounts(void) const
{
    return IsSetCounts();
}

inline
const CTMgr_DatasetItemSeq_Base::TCounts& CTMgr_DatasetItemSeq_Base::GetCounts(void) const
{
    if (!CanGetCounts()) {
        ThrowUnassigned(1);
    }
    return (*m_Counts);
}

inline
bool CTMgr_DatasetItemSeq_Base::IsSetSeq_id2(void) const
{
    return m_Seq_id2.NotEmpty();
}

inline
bool CTMgr_DatasetItemSeq_Base::CanGetSeq_id2(void) const
{
    return IsSetSeq_id2();
}

inline
const CTMgr_DatasetItemSeq_Base::TSeq_id2& CTMgr_DatasetItemSeq_Base::GetSeq_id2(void) const
{
    if (!CanGetSeq_id2()) {
        ThrowUnassigned(2);
    }
    return (*m_Seq_id2);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_DATASETITEMSEQ_BASE_HPP
