/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Giimport_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_GIIMPORT_ID_BASE_HPP
#define OBJECTS_SEQLOC_GIIMPORT_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQLOC_EXPORT CGiimport_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGiimport_id_Base(void);
    // destructor
    virtual ~CGiimport_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TId;
    typedef string TDb;
    typedef string TRelease;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_db,
        e_release
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// the id to use here
    /// mandatory
    /// typedef int TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    TId GetId(void) const;
    void SetId(TId value);
    TId& SetId(void);

    /// dbase used in
    /// optional
    /// typedef string TDb
    ///  Check whether the Db data member has been assigned a value.
    bool IsSetDb(void) const;
    /// Check whether it is safe or not to call GetDb method.
    bool CanGetDb(void) const;
    void ResetDb(void);
    const TDb& GetDb(void) const;
    void SetDb(const TDb& value);
    void SetDb(TDb&& value);
    TDb& SetDb(void);

    /// the release
    /// optional
    /// typedef string TRelease
    ///  Check whether the Release data member has been assigned a value.
    bool IsSetRelease(void) const;
    /// Check whether it is safe or not to call GetRelease method.
    bool CanGetRelease(void) const;
    void ResetRelease(void);
    const TRelease& GetRelease(void) const;
    void SetRelease(const TRelease& value);
    void SetRelease(TRelease&& value);
    TRelease& SetRelease(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGiimport_id_Base(const CGiimport_id_Base&);
    CGiimport_id_Base& operator=(const CGiimport_id_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Id;
    string m_Db;
    string m_Release;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGiimport_id_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGiimport_id_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CGiimport_id_Base::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CGiimport_id_Base::TId CGiimport_id_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CGiimport_id_Base::SetId(CGiimport_id_Base::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CGiimport_id_Base::TId& CGiimport_id_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CGiimport_id_Base::IsSetDb(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGiimport_id_Base::CanGetDb(void) const
{
    return IsSetDb();
}

inline
const CGiimport_id_Base::TDb& CGiimport_id_Base::GetDb(void) const
{
    if (!CanGetDb()) {
        ThrowUnassigned(1);
    }
    return m_Db;
}

inline
void CGiimport_id_Base::SetDb(const CGiimport_id_Base::TDb& value)
{
    m_Db = value;
    m_set_State[0] |= 0xc;
}

inline
void CGiimport_id_Base::SetDb(CGiimport_id_Base::TDb&& value)
{
    m_Db = std::forward<CGiimport_id_Base::TDb>(value);
    m_set_State[0] |= 0xc;
}

inline
CGiimport_id_Base::TDb& CGiimport_id_Base::SetDb(void)
{
#ifdef _DEBUG
    if (!IsSetDb()) {
        m_Db = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Db;
}

inline
bool CGiimport_id_Base::IsSetRelease(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGiimport_id_Base::CanGetRelease(void) const
{
    return IsSetRelease();
}

inline
const CGiimport_id_Base::TRelease& CGiimport_id_Base::GetRelease(void) const
{
    if (!CanGetRelease()) {
        ThrowUnassigned(2);
    }
    return m_Release;
}

inline
void CGiimport_id_Base::SetRelease(const CGiimport_id_Base::TRelease& value)
{
    m_Release = value;
    m_set_State[0] |= 0x30;
}

inline
void CGiimport_id_Base::SetRelease(CGiimport_id_Base::TRelease&& value)
{
    m_Release = std::forward<CGiimport_id_Base::TRelease>(value);
    m_set_State[0] |= 0x30;
}

inline
CGiimport_id_Base::TRelease& CGiimport_id_Base::SetRelease(void)
{
#ifdef _DEBUG
    if (!IsSetRelease()) {
        m_Release = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Release;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_GIIMPORT_ID_BASE_HPP
