/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqEdit_Cmd_ResetSeqAttr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqedit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQEDIT_SEQEDIT_CMD_RESETSEQATTR_BASE_HPP
#define OBJECTS_SEQEDIT_SEQEDIT_CMD_RESETSEQATTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeqEdit_Id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Reset bioseq's attribute
class NCBI_SEQEDIT_EXPORT CSeqEdit_Cmd_ResetSeqAttr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqEdit_Cmd_ResetSeqAttr_Base(void);
    // destructor
    virtual ~CSeqEdit_Cmd_ResetSeqAttr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EWhat {
        eWhat_not_set  =  0,
        eWhat_inst     =  1,  ///< whole seq-inst object
        eWhat_repr     =  2,  ///< repr field of seq-inst object
        eWhat_mol      =  3,  ///< mol field of seq-inst object
        eWhat_length   =  4,  ///< length field of seq-inst object
        eWhat_fuzz     =  5,  ///< fuzz field of seq-inst object
        eWhat_topology =  6,  ///< topology field of seq-inst object
        eWhat_strand   =  7,  ///< strand field of seq-inst object
        eWhat_ext      =  8,  ///< extr field of seq-inst object
        eWhat_hist     =  9,  ///< hist field of seq-inst object
        eWhat_seq_data = 10  ///< seq-data field of seq-inst object
    };
    
    /// Access to EWhat's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EWhat)(void);
    
    // types
    typedef CSeqEdit_Id TId;
    typedef EWhat TWhat;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_what
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Bioseq id
    /// mandatory
    /// typedef CSeqEdit_Id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef EWhat TWhat
    ///  Check whether the What data member has been assigned a value.
    bool IsSetWhat(void) const;
    /// Check whether it is safe or not to call GetWhat method.
    bool CanGetWhat(void) const;
    void ResetWhat(void);
    TWhat GetWhat(void) const;
    void SetWhat(TWhat value);
    TWhat& SetWhat(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqEdit_Cmd_ResetSeqAttr_Base(const CSeqEdit_Cmd_ResetSeqAttr_Base&);
    CSeqEdit_Cmd_ResetSeqAttr_Base& operator=(const CSeqEdit_Cmd_ResetSeqAttr_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    EWhat m_What;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqEdit_Cmd_ResetSeqAttr_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeqEdit_Cmd_ResetSeqAttr_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_ResetSeqAttr_Base::TId& CSeqEdit_Cmd_ResetSeqAttr_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CSeqEdit_Cmd_ResetSeqAttr_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CSeqEdit_Cmd_ResetSeqAttr_Base::TId& CSeqEdit_Cmd_ResetSeqAttr_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CSeqEdit_Cmd_ResetSeqAttr_Base::IsSetWhat(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeqEdit_Cmd_ResetSeqAttr_Base::CanGetWhat(void) const
{
    return IsSetWhat();
}

inline
void CSeqEdit_Cmd_ResetSeqAttr_Base::ResetWhat(void)
{
    m_What = (EWhat)(0);
    m_set_State[0] &= ~0xc;
}

inline
CSeqEdit_Cmd_ResetSeqAttr_Base::TWhat CSeqEdit_Cmd_ResetSeqAttr_Base::GetWhat(void) const
{
    if (!CanGetWhat()) {
        ThrowUnassigned(1);
    }
    return m_What;
}

inline
void CSeqEdit_Cmd_ResetSeqAttr_Base::SetWhat(CSeqEdit_Cmd_ResetSeqAttr_Base::TWhat value)
{
    m_What = value;
    m_set_State[0] |= 0xc;
}

inline
CSeqEdit_Cmd_ResetSeqAttr_Base::TWhat& CSeqEdit_Cmd_ResetSeqAttr_Base::SetWhat(void)
{
#ifdef _DEBUG
    if (!IsSetWhat()) {
        memset(&m_What,UnassignedByte(),sizeof(m_What));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_What;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQEDIT_SEQEDIT_CMD_RESETSEQATTR_BASE_HPP
