/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EMBL_xref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqblock.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQBLOCK_EMBL_XREF_BASE_HPP
#define OBJECTS_SEQBLOCK_EMBL_XREF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEMBL_dbname;
class CObject_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQBLOCK_EXPORT CEMBL_xref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEMBL_xref_Base(void);
    // destructor
    virtual ~CEMBL_xref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEMBL_dbname TDbname;
    typedef list< CRef< CObject_id > > TId;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dbname,
        e_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CEMBL_dbname TDbname
    ///  Check whether the Dbname data member has been assigned a value.
    bool IsSetDbname(void) const;
    /// Check whether it is safe or not to call GetDbname method.
    bool CanGetDbname(void) const;
    void ResetDbname(void);
    const TDbname& GetDbname(void) const;
    void SetDbname(TDbname& value);
    TDbname& SetDbname(void);

    /// mandatory
    /// typedef list< CRef< CObject_id > > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEMBL_xref_Base(const CEMBL_xref_Base&);
    CEMBL_xref_Base& operator=(const CEMBL_xref_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDbname > m_Dbname;
    list< CRef< CObject_id > > m_Id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEMBL_xref_Base::IsSetDbname(void) const
{
    return m_Dbname.NotEmpty();
}

inline
bool CEMBL_xref_Base::CanGetDbname(void) const
{
    return true;
}

inline
const CEMBL_xref_Base::TDbname& CEMBL_xref_Base::GetDbname(void) const
{
    if ( !m_Dbname ) {
        const_cast<CEMBL_xref_Base*>(this)->ResetDbname();
    }
    return (*m_Dbname);
}

inline
CEMBL_xref_Base::TDbname& CEMBL_xref_Base::SetDbname(void)
{
    if ( !m_Dbname ) {
        ResetDbname();
    }
    return (*m_Dbname);
}

inline
bool CEMBL_xref_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEMBL_xref_Base::CanGetId(void) const
{
    return true;
}

inline
const CEMBL_xref_Base::TId& CEMBL_xref_Base::GetId(void) const
{
    return m_Id;
}

inline
CEMBL_xref_Base::TId& CEMBL_xref_Base::SetId(void)
{
    m_set_State[0] |= 0x4;
    return m_Id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQBLOCK_EMBL_XREF_BASE_HPP
