/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_hist_rec_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_SEQ_HIST_REC_BASE_HPP
#define OBJECTS_SEQ_SEQ_HIST_REC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeq_hist_rec_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_hist_rec_Base(void);
    // destructor
    virtual ~CSeq_hist_rec_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CDate TDate;
    typedef list< CRef< CSeq_id > > TIds;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_date,
        e_ids
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// mandatory
    /// typedef list< CRef< CSeq_id > > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_hist_rec_Base(const CSeq_hist_rec_Base&);
    CSeq_hist_rec_Base& operator=(const CSeq_hist_rec_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDate > m_Date;
    list< CRef< CSeq_id > > m_Ids;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_hist_rec_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CSeq_hist_rec_Base::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CSeq_hist_rec_Base::TDate& CSeq_hist_rec_Base::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(0);
    }
    return (*m_Date);
}

inline
bool CSeq_hist_rec_Base::IsSetIds(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_hist_rec_Base::CanGetIds(void) const
{
    return true;
}

inline
const CSeq_hist_rec_Base::TIds& CSeq_hist_rec_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CSeq_hist_rec_Base::TIds& CSeq_hist_rec_Base::SetIds(void)
{
    m_set_State[0] |= 0x4;
    return m_Ids;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_SEQ_HIST_REC_BASE_HPP
