/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_gap_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_SEQ_GAP_BASE_HPP
#define OBJECTS_SEQ_SEQ_GAP_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CLinkage_evidence;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeq_gap_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_gap_Base(void);
    // destructor
    virtual ~CSeq_gap_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_unknown         =   0,
        eType_fragment        =   1,  ///< Deprecated. Used only for AGP 1.1
        eType_clone           =   2,  ///< Deprecated. Used only for AGP 1.1
        eType_short_arm       =   3,
        eType_heterochromatin =   4,
        eType_centromere      =   5,
        eType_telomere        =   6,
        eType_repeat          =   7,
        eType_contig          =   8,
        eType_scaffold        =   9,
        eType_contamination   =  10,
        eType_other           = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    enum ELinkage {
        eLinkage_unlinked =   0,
        eLinkage_linked   =   1,
        eLinkage_other    = 255
    };
    
    /// Access to ELinkage's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ELinkage)(void);
    
    // types
    typedef int TType;
    typedef int TLinkage;
    typedef list< CRef< CLinkage_evidence > > TLinkage_evidence;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_linkage,
        e_linkage_evidence
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef int TLinkage
    ///  Check whether the Linkage data member has been assigned a value.
    bool IsSetLinkage(void) const;
    /// Check whether it is safe or not to call GetLinkage method.
    bool CanGetLinkage(void) const;
    void ResetLinkage(void);
    TLinkage GetLinkage(void) const;
    void SetLinkage(TLinkage value);
    TLinkage& SetLinkage(void);

    /// optional
    /// typedef list< CRef< CLinkage_evidence > > TLinkage_evidence
    ///  Check whether the Linkage_evidence data member has been assigned a value.
    bool IsSetLinkage_evidence(void) const;
    /// Check whether it is safe or not to call GetLinkage_evidence method.
    bool CanGetLinkage_evidence(void) const;
    void ResetLinkage_evidence(void);
    const TLinkage_evidence& GetLinkage_evidence(void) const;
    TLinkage_evidence& SetLinkage_evidence(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_gap_Base(const CSeq_gap_Base&);
    CSeq_gap_Base& operator=(const CSeq_gap_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    int m_Linkage;
    list< CRef< CLinkage_evidence > > m_Linkage_evidence;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_gap_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_gap_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CSeq_gap_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSeq_gap_Base::TType CSeq_gap_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CSeq_gap_Base::SetType(CSeq_gap_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_gap_Base::TType& CSeq_gap_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CSeq_gap_Base::IsSetLinkage(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_gap_Base::CanGetLinkage(void) const
{
    return IsSetLinkage();
}

inline
void CSeq_gap_Base::ResetLinkage(void)
{
    m_Linkage = (ELinkage)(0);
    m_set_State[0] &= ~0xc;
}

inline
CSeq_gap_Base::TLinkage CSeq_gap_Base::GetLinkage(void) const
{
    if (!CanGetLinkage()) {
        ThrowUnassigned(1);
    }
    return m_Linkage;
}

inline
void CSeq_gap_Base::SetLinkage(CSeq_gap_Base::TLinkage value)
{
    m_Linkage = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_gap_Base::TLinkage& CSeq_gap_Base::SetLinkage(void)
{
#ifdef _DEBUG
    if (!IsSetLinkage()) {
        memset(&m_Linkage,UnassignedByte(),sizeof(m_Linkage));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Linkage;
}

inline
bool CSeq_gap_Base::IsSetLinkage_evidence(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_gap_Base::CanGetLinkage_evidence(void) const
{
    return true;
}

inline
const CSeq_gap_Base::TLinkage_evidence& CSeq_gap_Base::GetLinkage_evidence(void) const
{
    return m_Linkage_evidence;
}

inline
CSeq_gap_Base::TLinkage_evidence& CSeq_gap_Base::SetLinkage_evidence(void)
{
    m_set_State[0] |= 0x10;
    return m_Linkage_evidence;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_SEQ_GAP_BASE_HPP
