/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pssm_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_PSSM_BASE_HPP
#define OBJECTS_SCOREMAT_PSSM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CObject_id;
class CPssmFinalData;
class CPssmIntermediateData;
class CSeq_entry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Position-specific scoring matrix
///
/// Column indices on the PSSM refer to the positions corresponding to the
/// query/master sequence, i.e. the number of columns (N) is the same
/// as the length of the query/master sequence. 
/// Row indices refer to individual amino acid types, i.e. the number of 
/// rows (M) is the same as the number of different residues in the 
/// alphabet we use. Consequently, row labels are amino acid identifiers.
///
/// PSSMs are stored as linear arrays of integers. By default, we store
/// them column-by-column, M values for the first column followed by M
/// values for the second column, and so on. In order to provide
/// flexibility for external applications, the boolean field "byrow" is 
/// provided to specify the storage order.
class NCBI_SCOREMAT_EXPORT CPssm_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPssm_Base(void);
    // destructor
    virtual ~CPssm_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TIsProtein;
    typedef CObject_id TIdentifier;
    typedef int TNumRows;
    typedef int TNumColumns;
    typedef list< string > TRowLabels;
    typedef bool TByRow;
    typedef CSeq_entry TQuery;
    typedef CPssmIntermediateData TIntermediateData;
    typedef CPssmFinalData TFinalData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_isProtein,
        e_identifier,
        e_numRows,
        e_numColumns,
        e_rowLabels,
        e_byRow,
        e_query,
        e_intermediateData,
        e_finalData
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// Is the this a protein or nucleotide scoring matrix?
    /// optional with default true
    /// typedef bool TIsProtein
    ///  Check whether the IsProtein data member has been assigned a value.
    bool IsSetIsProtein(void) const;
    /// Check whether it is safe or not to call GetIsProtein method.
    bool CanGetIsProtein(void) const;
    void ResetIsProtein(void);
    void SetDefaultIsProtein(void);
    TIsProtein GetIsProtein(void) const;
    void SetIsProtein(TIsProtein value);
    TIsProtein& SetIsProtein(void);

    /// PSSM identifier
    /// optional
    /// typedef CObject_id TIdentifier
    ///  Check whether the Identifier data member has been assigned a value.
    bool IsSetIdentifier(void) const;
    /// Check whether it is safe or not to call GetIdentifier method.
    bool CanGetIdentifier(void) const;
    void ResetIdentifier(void);
    const TIdentifier& GetIdentifier(void) const;
    void SetIdentifier(TIdentifier& value);
    TIdentifier& SetIdentifier(void);

    /// The dimensions of the matrix are returned so the client can
    /// verify that all data was received.
    /// number of rows
    /// mandatory
    /// typedef int TNumRows
    ///  Check whether the NumRows data member has been assigned a value.
    bool IsSetNumRows(void) const;
    /// Check whether it is safe or not to call GetNumRows method.
    bool CanGetNumRows(void) const;
    void ResetNumRows(void);
    TNumRows GetNumRows(void) const;
    void SetNumRows(TNumRows value);
    TNumRows& SetNumRows(void);

    /// number of columns
    /// mandatory
    /// typedef int TNumColumns
    ///  Check whether the NumColumns data member has been assigned a value.
    bool IsSetNumColumns(void) const;
    /// Check whether it is safe or not to call GetNumColumns method.
    bool CanGetNumColumns(void) const;
    void ResetNumColumns(void);
    TNumColumns GetNumColumns(void) const;
    void SetNumColumns(TNumColumns value);
    TNumColumns& SetNumColumns(void);

    /// row-labels is given to note the order of residue types so that it can
    /// be cross-checked between applications.
    /// If this field is not given, the matrix values are presented in 
    /// order of the alphabet ncbistdaa is used for protein, ncbi4na for nucl.
    /// for proteins the values returned correspond to 
    /// (-,-), (-,A), (-,B), (-,C) ... (A,-), (A,A), (A,B), (A,C) ...
    /// optional
    /// typedef list< string > TRowLabels
    ///  Check whether the RowLabels data member has been assigned a value.
    bool IsSetRowLabels(void) const;
    /// Check whether it is safe or not to call GetRowLabels method.
    bool CanGetRowLabels(void) const;
    void ResetRowLabels(void);
    const TRowLabels& GetRowLabels(void) const;
    TRowLabels& SetRowLabels(void);

    /// are matrices stored row by row?
    /// optional with default false
    /// typedef bool TByRow
    ///  Check whether the ByRow data member has been assigned a value.
    bool IsSetByRow(void) const;
    /// Check whether it is safe or not to call GetByRow method.
    bool CanGetByRow(void) const;
    void ResetByRow(void);
    void SetDefaultByRow(void);
    TByRow GetByRow(void) const;
    void SetByRow(TByRow value);
    TByRow& SetByRow(void);

    /// PSSM representative sequence (master) 
    /// optional
    /// typedef CSeq_entry TQuery
    ///  Check whether the Query data member has been assigned a value.
    bool IsSetQuery(void) const;
    /// Check whether it is safe or not to call GetQuery method.
    bool CanGetQuery(void) const;
    void ResetQuery(void);
    const TQuery& GetQuery(void) const;
    void SetQuery(TQuery& value);
    TQuery& SetQuery(void);

    /// both intermediateData and finalData can be provided, but at least one of
    /// them must be provided.
    /// N.B.: by default PSI-BLAST will return the PSSM in its PssmIntermediateData 
    /// representation. 
    /// Intermediate or final data for the PSSM
    /// optional
    /// typedef CPssmIntermediateData TIntermediateData
    ///  Check whether the IntermediateData data member has been assigned a value.
    bool IsSetIntermediateData(void) const;
    /// Check whether it is safe or not to call GetIntermediateData method.
    bool CanGetIntermediateData(void) const;
    void ResetIntermediateData(void);
    const TIntermediateData& GetIntermediateData(void) const;
    void SetIntermediateData(TIntermediateData& value);
    TIntermediateData& SetIntermediateData(void);

    /// Final representation for the PSSM
    /// optional
    /// typedef CPssmFinalData TFinalData
    ///  Check whether the FinalData data member has been assigned a value.
    bool IsSetFinalData(void) const;
    /// Check whether it is safe or not to call GetFinalData method.
    bool CanGetFinalData(void) const;
    void ResetFinalData(void);
    const TFinalData& GetFinalData(void) const;
    void SetFinalData(TFinalData& value);
    TFinalData& SetFinalData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPssm_Base(const CPssm_Base&);
    CPssm_Base& operator=(const CPssm_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_IsProtein;
    CRef< TIdentifier > m_Identifier;
    int m_NumRows;
    int m_NumColumns;
    list< string > m_RowLabels;
    bool m_ByRow;
    CRef< TQuery > m_Query;
    CRef< TIntermediateData > m_IntermediateData;
    CRef< TFinalData > m_FinalData;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPssm_Base::IsSetIsProtein(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPssm_Base::CanGetIsProtein(void) const
{
    return true;
}

inline
void CPssm_Base::ResetIsProtein(void)
{
    m_IsProtein = true;
    m_set_State[0] &= ~0x3;
}

inline
void CPssm_Base::SetDefaultIsProtein(void)
{
    ResetIsProtein();
}

inline
CPssm_Base::TIsProtein CPssm_Base::GetIsProtein(void) const
{
    return m_IsProtein;
}

inline
void CPssm_Base::SetIsProtein(CPssm_Base::TIsProtein value)
{
    m_IsProtein = value;
    m_set_State[0] |= 0x3;
}

inline
CPssm_Base::TIsProtein& CPssm_Base::SetIsProtein(void)
{
#ifdef _DEBUG
    if (!IsSetIsProtein()) {
        memset(&m_IsProtein,UnassignedByte(),sizeof(m_IsProtein));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_IsProtein;
}

inline
bool CPssm_Base::IsSetIdentifier(void) const
{
    return m_Identifier.NotEmpty();
}

inline
bool CPssm_Base::CanGetIdentifier(void) const
{
    return IsSetIdentifier();
}

inline
const CPssm_Base::TIdentifier& CPssm_Base::GetIdentifier(void) const
{
    if (!CanGetIdentifier()) {
        ThrowUnassigned(1);
    }
    return (*m_Identifier);
}

inline
bool CPssm_Base::IsSetNumRows(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPssm_Base::CanGetNumRows(void) const
{
    return IsSetNumRows();
}

inline
void CPssm_Base::ResetNumRows(void)
{
    m_NumRows = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPssm_Base::TNumRows CPssm_Base::GetNumRows(void) const
{
    if (!CanGetNumRows()) {
        ThrowUnassigned(2);
    }
    return m_NumRows;
}

inline
void CPssm_Base::SetNumRows(CPssm_Base::TNumRows value)
{
    m_NumRows = value;
    m_set_State[0] |= 0x30;
}

inline
CPssm_Base::TNumRows& CPssm_Base::SetNumRows(void)
{
#ifdef _DEBUG
    if (!IsSetNumRows()) {
        memset(&m_NumRows,UnassignedByte(),sizeof(m_NumRows));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_NumRows;
}

inline
bool CPssm_Base::IsSetNumColumns(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPssm_Base::CanGetNumColumns(void) const
{
    return IsSetNumColumns();
}

inline
void CPssm_Base::ResetNumColumns(void)
{
    m_NumColumns = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPssm_Base::TNumColumns CPssm_Base::GetNumColumns(void) const
{
    if (!CanGetNumColumns()) {
        ThrowUnassigned(3);
    }
    return m_NumColumns;
}

inline
void CPssm_Base::SetNumColumns(CPssm_Base::TNumColumns value)
{
    m_NumColumns = value;
    m_set_State[0] |= 0xc0;
}

inline
CPssm_Base::TNumColumns& CPssm_Base::SetNumColumns(void)
{
#ifdef _DEBUG
    if (!IsSetNumColumns()) {
        memset(&m_NumColumns,UnassignedByte(),sizeof(m_NumColumns));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_NumColumns;
}

inline
bool CPssm_Base::IsSetRowLabels(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPssm_Base::CanGetRowLabels(void) const
{
    return true;
}

inline
const CPssm_Base::TRowLabels& CPssm_Base::GetRowLabels(void) const
{
    return m_RowLabels;
}

inline
CPssm_Base::TRowLabels& CPssm_Base::SetRowLabels(void)
{
    m_set_State[0] |= 0x100;
    return m_RowLabels;
}

inline
bool CPssm_Base::IsSetByRow(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPssm_Base::CanGetByRow(void) const
{
    return true;
}

inline
void CPssm_Base::ResetByRow(void)
{
    m_ByRow = false;
    m_set_State[0] &= ~0xc00;
}

inline
void CPssm_Base::SetDefaultByRow(void)
{
    ResetByRow();
}

inline
CPssm_Base::TByRow CPssm_Base::GetByRow(void) const
{
    return m_ByRow;
}

inline
void CPssm_Base::SetByRow(CPssm_Base::TByRow value)
{
    m_ByRow = value;
    m_set_State[0] |= 0xc00;
}

inline
CPssm_Base::TByRow& CPssm_Base::SetByRow(void)
{
#ifdef _DEBUG
    if (!IsSetByRow()) {
        memset(&m_ByRow,UnassignedByte(),sizeof(m_ByRow));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_ByRow;
}

inline
bool CPssm_Base::IsSetQuery(void) const
{
    return m_Query.NotEmpty();
}

inline
bool CPssm_Base::CanGetQuery(void) const
{
    return IsSetQuery();
}

inline
const CPssm_Base::TQuery& CPssm_Base::GetQuery(void) const
{
    if (!CanGetQuery()) {
        ThrowUnassigned(6);
    }
    return (*m_Query);
}

inline
bool CPssm_Base::IsSetIntermediateData(void) const
{
    return m_IntermediateData.NotEmpty();
}

inline
bool CPssm_Base::CanGetIntermediateData(void) const
{
    return IsSetIntermediateData();
}

inline
const CPssm_Base::TIntermediateData& CPssm_Base::GetIntermediateData(void) const
{
    if (!CanGetIntermediateData()) {
        ThrowUnassigned(7);
    }
    return (*m_IntermediateData);
}

inline
bool CPssm_Base::IsSetFinalData(void) const
{
    return m_FinalData.NotEmpty();
}

inline
bool CPssm_Base::CanGetFinalData(void) const
{
    return IsSetFinalData();
}

inline
const CPssm_Base::TFinalData& CPssm_Base::GetFinalData(void) const
{
    if (!CanGetFinalData()) {
        ThrowUnassigned(8);
    }
    return (*m_FinalData);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_PSSM_BASE_HPP
