/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pubmed_url_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pubmed.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PUBMED_PUBMED_URL_BASE_HPP
#define OBJECTS_PUBMED_PUBMED_URL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_PUBMED_EXPORT CPubmed_url_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPubmed_url_Base(void);
    // destructor
    virtual ~CPubmed_url_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TLocation;
    typedef string TUrl;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_location,
        e_url
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Location code
    /// optional
    /// typedef string TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(const TLocation& value);
    void SetLocation(TLocation&& value);
    TLocation& SetLocation(void);

    /// Selected URL for location
    /// mandatory
    /// typedef string TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(const TUrl& value);
    void SetUrl(TUrl&& value);
    TUrl& SetUrl(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubmed_url_Base(const CPubmed_url_Base&);
    CPubmed_url_Base& operator=(const CPubmed_url_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Location;
    string m_Url;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubmed_url_Base::IsSetLocation(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPubmed_url_Base::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
const CPubmed_url_Base::TLocation& CPubmed_url_Base::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(0);
    }
    return m_Location;
}

inline
void CPubmed_url_Base::SetLocation(const CPubmed_url_Base::TLocation& value)
{
    m_Location = value;
    m_set_State[0] |= 0x3;
}

inline
void CPubmed_url_Base::SetLocation(CPubmed_url_Base::TLocation&& value)
{
    m_Location = std::forward<CPubmed_url_Base::TLocation>(value);
    m_set_State[0] |= 0x3;
}

inline
CPubmed_url_Base::TLocation& CPubmed_url_Base::SetLocation(void)
{
#ifdef _DEBUG
    if (!IsSetLocation()) {
        m_Location = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Location;
}

inline
bool CPubmed_url_Base::IsSetUrl(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPubmed_url_Base::CanGetUrl(void) const
{
    return IsSetUrl();
}

inline
const CPubmed_url_Base::TUrl& CPubmed_url_Base::GetUrl(void) const
{
    if (!CanGetUrl()) {
        ThrowUnassigned(1);
    }
    return m_Url;
}

inline
void CPubmed_url_Base::SetUrl(const CPubmed_url_Base::TUrl& value)
{
    m_Url = value;
    m_set_State[0] |= 0xc;
}

inline
void CPubmed_url_Base::SetUrl(CPubmed_url_Base::TUrl&& value)
{
    m_Url = std::forward<CPubmed_url_Base::TUrl>(value);
    m_set_State[0] |= 0xc;
}

inline
CPubmed_url_Base::TUrl& CPubmed_url_Base::SetUrl(void)
{
#ifdef _DEBUG
    if (!IsSetUrl()) {
        m_Url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Url;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PUBMED_PUBMED_URL_BASE_HPP
