/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_align_seq_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'ncbimime.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_NCBIMIME_BIOSTRUC_ALIGN_SEQ_BASE_HPP
#define OBJECTS_NCBIMIME_BIOSTRUC_ALIGN_SEQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCn3d_style_dictionary;
class CCn3d_user_annotations;
class CSeq_annot;
class CSeq_entry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// display seq structure align only
class NCBI_NCBIMIME_EXPORT CBiostruc_align_seq_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_align_seq_Base(void);
    // destructor
    virtual ~CBiostruc_align_seq_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CSeq_entry > > TSequences;
    typedef list< CRef< CSeq_annot > > TSeqalign;
    typedef CCn3d_style_dictionary TStyle_dictionary;
    typedef CCn3d_user_annotations TUser_annotations;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_sequences,
        e_seqalign,
        e_style_dictionary,
        e_user_annotations
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// sequences
    /// mandatory
    /// typedef list< CRef< CSeq_entry > > TSequences
    ///  Check whether the Sequences data member has been assigned a value.
    bool IsSetSequences(void) const;
    /// Check whether it is safe or not to call GetSequences method.
    bool CanGetSequences(void) const;
    void ResetSequences(void);
    const TSequences& GetSequences(void) const;
    TSequences& SetSequences(void);

    /// mandatory
    /// typedef list< CRef< CSeq_annot > > TSeqalign
    ///  Check whether the Seqalign data member has been assigned a value.
    bool IsSetSeqalign(void) const;
    /// Check whether it is safe or not to call GetSeqalign method.
    bool CanGetSeqalign(void) const;
    void ResetSeqalign(void);
    const TSeqalign& GetSeqalign(void) const;
    TSeqalign& SetSeqalign(void);

    /// optional
    /// typedef CCn3d_style_dictionary TStyle_dictionary
    ///  Check whether the Style_dictionary data member has been assigned a value.
    bool IsSetStyle_dictionary(void) const;
    /// Check whether it is safe or not to call GetStyle_dictionary method.
    bool CanGetStyle_dictionary(void) const;
    void ResetStyle_dictionary(void);
    const TStyle_dictionary& GetStyle_dictionary(void) const;
    void SetStyle_dictionary(TStyle_dictionary& value);
    TStyle_dictionary& SetStyle_dictionary(void);

    /// optional
    /// typedef CCn3d_user_annotations TUser_annotations
    ///  Check whether the User_annotations data member has been assigned a value.
    bool IsSetUser_annotations(void) const;
    /// Check whether it is safe or not to call GetUser_annotations method.
    bool CanGetUser_annotations(void) const;
    void ResetUser_annotations(void);
    const TUser_annotations& GetUser_annotations(void) const;
    void SetUser_annotations(TUser_annotations& value);
    TUser_annotations& SetUser_annotations(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBiostruc_align_seq_Base(const CBiostruc_align_seq_Base&);
    CBiostruc_align_seq_Base& operator=(const CBiostruc_align_seq_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CSeq_entry > > m_Sequences;
    list< CRef< CSeq_annot > > m_Seqalign;
    CRef< TStyle_dictionary > m_Style_dictionary;
    CRef< TUser_annotations > m_User_annotations;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBiostruc_align_seq_Base::IsSetSequences(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBiostruc_align_seq_Base::CanGetSequences(void) const
{
    return true;
}

inline
const CBiostruc_align_seq_Base::TSequences& CBiostruc_align_seq_Base::GetSequences(void) const
{
    return m_Sequences;
}

inline
CBiostruc_align_seq_Base::TSequences& CBiostruc_align_seq_Base::SetSequences(void)
{
    m_set_State[0] |= 0x1;
    return m_Sequences;
}

inline
bool CBiostruc_align_seq_Base::IsSetSeqalign(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBiostruc_align_seq_Base::CanGetSeqalign(void) const
{
    return true;
}

inline
const CBiostruc_align_seq_Base::TSeqalign& CBiostruc_align_seq_Base::GetSeqalign(void) const
{
    return m_Seqalign;
}

inline
CBiostruc_align_seq_Base::TSeqalign& CBiostruc_align_seq_Base::SetSeqalign(void)
{
    m_set_State[0] |= 0x4;
    return m_Seqalign;
}

inline
bool CBiostruc_align_seq_Base::IsSetStyle_dictionary(void) const
{
    return m_Style_dictionary.NotEmpty();
}

inline
bool CBiostruc_align_seq_Base::CanGetStyle_dictionary(void) const
{
    return IsSetStyle_dictionary();
}

inline
const CBiostruc_align_seq_Base::TStyle_dictionary& CBiostruc_align_seq_Base::GetStyle_dictionary(void) const
{
    if (!CanGetStyle_dictionary()) {
        ThrowUnassigned(2);
    }
    return (*m_Style_dictionary);
}

inline
bool CBiostruc_align_seq_Base::IsSetUser_annotations(void) const
{
    return m_User_annotations.NotEmpty();
}

inline
bool CBiostruc_align_seq_Base::CanGetUser_annotations(void) const
{
    return IsSetUser_annotations();
}

inline
const CBiostruc_align_seq_Base::TUser_annotations& CBiostruc_align_seq_Base::GetUser_annotations(void) const
{
    if (!CanGetUser_annotations()) {
        ThrowUnassigned(3);
    }
    return (*m_User_annotations);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_NCBIMIME_BIOSTRUC_ALIGN_SEQ_BASE_HPP
