/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GL_matrix_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_GL_MATRIX_BASE_HPP
#define OBJECTS_MMDB3_GL_MATRIX_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CGL_matrix_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGL_matrix_Base(void);
    // destructor
    virtual ~CGL_matrix_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TScale;
    typedef int TM11;
    typedef int TM12;
    typedef int TM13;
    typedef int TM14;
    typedef int TM21;
    typedef int TM22;
    typedef int TM23;
    typedef int TM24;
    typedef int TM31;
    typedef int TM32;
    typedef int TM33;
    typedef int TM34;
    typedef int TM41;
    typedef int TM42;
    typedef int TM43;
    typedef int TM44;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scale,
        e_m11,
        e_m12,
        e_m13,
        e_m14,
        e_m21,
        e_m22,
        e_m23,
        e_m24,
        e_m31,
        e_m32,
        e_m33,
        e_m34,
        e_m41,
        e_m42,
        e_m43,
        e_m44
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 18> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TScale
    ///  Check whether the Scale data member has been assigned a value.
    bool IsSetScale(void) const;
    /// Check whether it is safe or not to call GetScale method.
    bool CanGetScale(void) const;
    void ResetScale(void);
    TScale GetScale(void) const;
    void SetScale(TScale value);
    TScale& SetScale(void);

    /// mandatory
    /// typedef int TM11
    ///  Check whether the M11 data member has been assigned a value.
    bool IsSetM11(void) const;
    /// Check whether it is safe or not to call GetM11 method.
    bool CanGetM11(void) const;
    void ResetM11(void);
    TM11 GetM11(void) const;
    void SetM11(TM11 value);
    TM11& SetM11(void);

    /// mandatory
    /// typedef int TM12
    ///  Check whether the M12 data member has been assigned a value.
    bool IsSetM12(void) const;
    /// Check whether it is safe or not to call GetM12 method.
    bool CanGetM12(void) const;
    void ResetM12(void);
    TM12 GetM12(void) const;
    void SetM12(TM12 value);
    TM12& SetM12(void);

    /// mandatory
    /// typedef int TM13
    ///  Check whether the M13 data member has been assigned a value.
    bool IsSetM13(void) const;
    /// Check whether it is safe or not to call GetM13 method.
    bool CanGetM13(void) const;
    void ResetM13(void);
    TM13 GetM13(void) const;
    void SetM13(TM13 value);
    TM13& SetM13(void);

    /// mandatory
    /// typedef int TM14
    ///  Check whether the M14 data member has been assigned a value.
    bool IsSetM14(void) const;
    /// Check whether it is safe or not to call GetM14 method.
    bool CanGetM14(void) const;
    void ResetM14(void);
    TM14 GetM14(void) const;
    void SetM14(TM14 value);
    TM14& SetM14(void);

    /// mandatory
    /// typedef int TM21
    ///  Check whether the M21 data member has been assigned a value.
    bool IsSetM21(void) const;
    /// Check whether it is safe or not to call GetM21 method.
    bool CanGetM21(void) const;
    void ResetM21(void);
    TM21 GetM21(void) const;
    void SetM21(TM21 value);
    TM21& SetM21(void);

    /// mandatory
    /// typedef int TM22
    ///  Check whether the M22 data member has been assigned a value.
    bool IsSetM22(void) const;
    /// Check whether it is safe or not to call GetM22 method.
    bool CanGetM22(void) const;
    void ResetM22(void);
    TM22 GetM22(void) const;
    void SetM22(TM22 value);
    TM22& SetM22(void);

    /// mandatory
    /// typedef int TM23
    ///  Check whether the M23 data member has been assigned a value.
    bool IsSetM23(void) const;
    /// Check whether it is safe or not to call GetM23 method.
    bool CanGetM23(void) const;
    void ResetM23(void);
    TM23 GetM23(void) const;
    void SetM23(TM23 value);
    TM23& SetM23(void);

    /// mandatory
    /// typedef int TM24
    ///  Check whether the M24 data member has been assigned a value.
    bool IsSetM24(void) const;
    /// Check whether it is safe or not to call GetM24 method.
    bool CanGetM24(void) const;
    void ResetM24(void);
    TM24 GetM24(void) const;
    void SetM24(TM24 value);
    TM24& SetM24(void);

    /// mandatory
    /// typedef int TM31
    ///  Check whether the M31 data member has been assigned a value.
    bool IsSetM31(void) const;
    /// Check whether it is safe or not to call GetM31 method.
    bool CanGetM31(void) const;
    void ResetM31(void);
    TM31 GetM31(void) const;
    void SetM31(TM31 value);
    TM31& SetM31(void);

    /// mandatory
    /// typedef int TM32
    ///  Check whether the M32 data member has been assigned a value.
    bool IsSetM32(void) const;
    /// Check whether it is safe or not to call GetM32 method.
    bool CanGetM32(void) const;
    void ResetM32(void);
    TM32 GetM32(void) const;
    void SetM32(TM32 value);
    TM32& SetM32(void);

    /// mandatory
    /// typedef int TM33
    ///  Check whether the M33 data member has been assigned a value.
    bool IsSetM33(void) const;
    /// Check whether it is safe or not to call GetM33 method.
    bool CanGetM33(void) const;
    void ResetM33(void);
    TM33 GetM33(void) const;
    void SetM33(TM33 value);
    TM33& SetM33(void);

    /// mandatory
    /// typedef int TM34
    ///  Check whether the M34 data member has been assigned a value.
    bool IsSetM34(void) const;
    /// Check whether it is safe or not to call GetM34 method.
    bool CanGetM34(void) const;
    void ResetM34(void);
    TM34 GetM34(void) const;
    void SetM34(TM34 value);
    TM34& SetM34(void);

    /// mandatory
    /// typedef int TM41
    ///  Check whether the M41 data member has been assigned a value.
    bool IsSetM41(void) const;
    /// Check whether it is safe or not to call GetM41 method.
    bool CanGetM41(void) const;
    void ResetM41(void);
    TM41 GetM41(void) const;
    void SetM41(TM41 value);
    TM41& SetM41(void);

    /// mandatory
    /// typedef int TM42
    ///  Check whether the M42 data member has been assigned a value.
    bool IsSetM42(void) const;
    /// Check whether it is safe or not to call GetM42 method.
    bool CanGetM42(void) const;
    void ResetM42(void);
    TM42 GetM42(void) const;
    void SetM42(TM42 value);
    TM42& SetM42(void);

    /// mandatory
    /// typedef int TM43
    ///  Check whether the M43 data member has been assigned a value.
    bool IsSetM43(void) const;
    /// Check whether it is safe or not to call GetM43 method.
    bool CanGetM43(void) const;
    void ResetM43(void);
    TM43 GetM43(void) const;
    void SetM43(TM43 value);
    TM43& SetM43(void);

    /// mandatory
    /// typedef int TM44
    ///  Check whether the M44 data member has been assigned a value.
    bool IsSetM44(void) const;
    /// Check whether it is safe or not to call GetM44 method.
    bool CanGetM44(void) const;
    void ResetM44(void);
    TM44 GetM44(void) const;
    void SetM44(TM44 value);
    TM44& SetM44(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGL_matrix_Base(const CGL_matrix_Base&);
    CGL_matrix_Base& operator=(const CGL_matrix_Base&);

    // data
    Uint4 m_set_State[2];
    int m_Scale;
    int m_M11;
    int m_M12;
    int m_M13;
    int m_M14;
    int m_M21;
    int m_M22;
    int m_M23;
    int m_M24;
    int m_M31;
    int m_M32;
    int m_M33;
    int m_M34;
    int m_M41;
    int m_M42;
    int m_M43;
    int m_M44;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGL_matrix_Base::IsSetScale(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGL_matrix_Base::CanGetScale(void) const
{
    return IsSetScale();
}

inline
void CGL_matrix_Base::ResetScale(void)
{
    m_Scale = 0;
    m_set_State[0] &= ~0x3;
}

inline
CGL_matrix_Base::TScale CGL_matrix_Base::GetScale(void) const
{
    if (!CanGetScale()) {
        ThrowUnassigned(0);
    }
    return m_Scale;
}

inline
void CGL_matrix_Base::SetScale(CGL_matrix_Base::TScale value)
{
    m_Scale = value;
    m_set_State[0] |= 0x3;
}

inline
CGL_matrix_Base::TScale& CGL_matrix_Base::SetScale(void)
{
#ifdef _DEBUG
    if (!IsSetScale()) {
        memset(&m_Scale,UnassignedByte(),sizeof(m_Scale));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scale;
}

inline
bool CGL_matrix_Base::IsSetM11(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGL_matrix_Base::CanGetM11(void) const
{
    return IsSetM11();
}

inline
void CGL_matrix_Base::ResetM11(void)
{
    m_M11 = 0;
    m_set_State[0] &= ~0xc;
}

inline
CGL_matrix_Base::TM11 CGL_matrix_Base::GetM11(void) const
{
    if (!CanGetM11()) {
        ThrowUnassigned(1);
    }
    return m_M11;
}

inline
void CGL_matrix_Base::SetM11(CGL_matrix_Base::TM11 value)
{
    m_M11 = value;
    m_set_State[0] |= 0xc;
}

inline
CGL_matrix_Base::TM11& CGL_matrix_Base::SetM11(void)
{
#ifdef _DEBUG
    if (!IsSetM11()) {
        memset(&m_M11,UnassignedByte(),sizeof(m_M11));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_M11;
}

inline
bool CGL_matrix_Base::IsSetM12(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGL_matrix_Base::CanGetM12(void) const
{
    return IsSetM12();
}

inline
void CGL_matrix_Base::ResetM12(void)
{
    m_M12 = 0;
    m_set_State[0] &= ~0x30;
}

inline
CGL_matrix_Base::TM12 CGL_matrix_Base::GetM12(void) const
{
    if (!CanGetM12()) {
        ThrowUnassigned(2);
    }
    return m_M12;
}

inline
void CGL_matrix_Base::SetM12(CGL_matrix_Base::TM12 value)
{
    m_M12 = value;
    m_set_State[0] |= 0x30;
}

inline
CGL_matrix_Base::TM12& CGL_matrix_Base::SetM12(void)
{
#ifdef _DEBUG
    if (!IsSetM12()) {
        memset(&m_M12,UnassignedByte(),sizeof(m_M12));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_M12;
}

inline
bool CGL_matrix_Base::IsSetM13(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGL_matrix_Base::CanGetM13(void) const
{
    return IsSetM13();
}

inline
void CGL_matrix_Base::ResetM13(void)
{
    m_M13 = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CGL_matrix_Base::TM13 CGL_matrix_Base::GetM13(void) const
{
    if (!CanGetM13()) {
        ThrowUnassigned(3);
    }
    return m_M13;
}

inline
void CGL_matrix_Base::SetM13(CGL_matrix_Base::TM13 value)
{
    m_M13 = value;
    m_set_State[0] |= 0xc0;
}

inline
CGL_matrix_Base::TM13& CGL_matrix_Base::SetM13(void)
{
#ifdef _DEBUG
    if (!IsSetM13()) {
        memset(&m_M13,UnassignedByte(),sizeof(m_M13));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_M13;
}

inline
bool CGL_matrix_Base::IsSetM14(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGL_matrix_Base::CanGetM14(void) const
{
    return IsSetM14();
}

inline
void CGL_matrix_Base::ResetM14(void)
{
    m_M14 = 0;
    m_set_State[0] &= ~0x300;
}

inline
CGL_matrix_Base::TM14 CGL_matrix_Base::GetM14(void) const
{
    if (!CanGetM14()) {
        ThrowUnassigned(4);
    }
    return m_M14;
}

inline
void CGL_matrix_Base::SetM14(CGL_matrix_Base::TM14 value)
{
    m_M14 = value;
    m_set_State[0] |= 0x300;
}

inline
CGL_matrix_Base::TM14& CGL_matrix_Base::SetM14(void)
{
#ifdef _DEBUG
    if (!IsSetM14()) {
        memset(&m_M14,UnassignedByte(),sizeof(m_M14));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_M14;
}

inline
bool CGL_matrix_Base::IsSetM21(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CGL_matrix_Base::CanGetM21(void) const
{
    return IsSetM21();
}

inline
void CGL_matrix_Base::ResetM21(void)
{
    m_M21 = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CGL_matrix_Base::TM21 CGL_matrix_Base::GetM21(void) const
{
    if (!CanGetM21()) {
        ThrowUnassigned(5);
    }
    return m_M21;
}

inline
void CGL_matrix_Base::SetM21(CGL_matrix_Base::TM21 value)
{
    m_M21 = value;
    m_set_State[0] |= 0xc00;
}

inline
CGL_matrix_Base::TM21& CGL_matrix_Base::SetM21(void)
{
#ifdef _DEBUG
    if (!IsSetM21()) {
        memset(&m_M21,UnassignedByte(),sizeof(m_M21));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_M21;
}

inline
bool CGL_matrix_Base::IsSetM22(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM22(void) const
{
    return IsSetM22();
}

inline
void CGL_matrix_Base::ResetM22(void)
{
    m_M22 = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CGL_matrix_Base::TM22 CGL_matrix_Base::GetM22(void) const
{
    if (!CanGetM22()) {
        ThrowUnassigned(6);
    }
    return m_M22;
}

inline
void CGL_matrix_Base::SetM22(CGL_matrix_Base::TM22 value)
{
    m_M22 = value;
    m_set_State[0] |= 0x3000;
}

inline
CGL_matrix_Base::TM22& CGL_matrix_Base::SetM22(void)
{
#ifdef _DEBUG
    if (!IsSetM22()) {
        memset(&m_M22,UnassignedByte(),sizeof(m_M22));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_M22;
}

inline
bool CGL_matrix_Base::IsSetM23(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM23(void) const
{
    return IsSetM23();
}

inline
void CGL_matrix_Base::ResetM23(void)
{
    m_M23 = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CGL_matrix_Base::TM23 CGL_matrix_Base::GetM23(void) const
{
    if (!CanGetM23()) {
        ThrowUnassigned(7);
    }
    return m_M23;
}

inline
void CGL_matrix_Base::SetM23(CGL_matrix_Base::TM23 value)
{
    m_M23 = value;
    m_set_State[0] |= 0xc000;
}

inline
CGL_matrix_Base::TM23& CGL_matrix_Base::SetM23(void)
{
#ifdef _DEBUG
    if (!IsSetM23()) {
        memset(&m_M23,UnassignedByte(),sizeof(m_M23));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_M23;
}

inline
bool CGL_matrix_Base::IsSetM24(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM24(void) const
{
    return IsSetM24();
}

inline
void CGL_matrix_Base::ResetM24(void)
{
    m_M24 = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CGL_matrix_Base::TM24 CGL_matrix_Base::GetM24(void) const
{
    if (!CanGetM24()) {
        ThrowUnassigned(8);
    }
    return m_M24;
}

inline
void CGL_matrix_Base::SetM24(CGL_matrix_Base::TM24 value)
{
    m_M24 = value;
    m_set_State[0] |= 0x30000;
}

inline
CGL_matrix_Base::TM24& CGL_matrix_Base::SetM24(void)
{
#ifdef _DEBUG
    if (!IsSetM24()) {
        memset(&m_M24,UnassignedByte(),sizeof(m_M24));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_M24;
}

inline
bool CGL_matrix_Base::IsSetM31(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM31(void) const
{
    return IsSetM31();
}

inline
void CGL_matrix_Base::ResetM31(void)
{
    m_M31 = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CGL_matrix_Base::TM31 CGL_matrix_Base::GetM31(void) const
{
    if (!CanGetM31()) {
        ThrowUnassigned(9);
    }
    return m_M31;
}

inline
void CGL_matrix_Base::SetM31(CGL_matrix_Base::TM31 value)
{
    m_M31 = value;
    m_set_State[0] |= 0xc0000;
}

inline
CGL_matrix_Base::TM31& CGL_matrix_Base::SetM31(void)
{
#ifdef _DEBUG
    if (!IsSetM31()) {
        memset(&m_M31,UnassignedByte(),sizeof(m_M31));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_M31;
}

inline
bool CGL_matrix_Base::IsSetM32(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM32(void) const
{
    return IsSetM32();
}

inline
void CGL_matrix_Base::ResetM32(void)
{
    m_M32 = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CGL_matrix_Base::TM32 CGL_matrix_Base::GetM32(void) const
{
    if (!CanGetM32()) {
        ThrowUnassigned(10);
    }
    return m_M32;
}

inline
void CGL_matrix_Base::SetM32(CGL_matrix_Base::TM32 value)
{
    m_M32 = value;
    m_set_State[0] |= 0x300000;
}

inline
CGL_matrix_Base::TM32& CGL_matrix_Base::SetM32(void)
{
#ifdef _DEBUG
    if (!IsSetM32()) {
        memset(&m_M32,UnassignedByte(),sizeof(m_M32));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_M32;
}

inline
bool CGL_matrix_Base::IsSetM33(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM33(void) const
{
    return IsSetM33();
}

inline
void CGL_matrix_Base::ResetM33(void)
{
    m_M33 = 0;
    m_set_State[0] &= ~0xc00000;
}

inline
CGL_matrix_Base::TM33 CGL_matrix_Base::GetM33(void) const
{
    if (!CanGetM33()) {
        ThrowUnassigned(11);
    }
    return m_M33;
}

inline
void CGL_matrix_Base::SetM33(CGL_matrix_Base::TM33 value)
{
    m_M33 = value;
    m_set_State[0] |= 0xc00000;
}

inline
CGL_matrix_Base::TM33& CGL_matrix_Base::SetM33(void)
{
#ifdef _DEBUG
    if (!IsSetM33()) {
        memset(&m_M33,UnassignedByte(),sizeof(m_M33));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_M33;
}

inline
bool CGL_matrix_Base::IsSetM34(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM34(void) const
{
    return IsSetM34();
}

inline
void CGL_matrix_Base::ResetM34(void)
{
    m_M34 = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CGL_matrix_Base::TM34 CGL_matrix_Base::GetM34(void) const
{
    if (!CanGetM34()) {
        ThrowUnassigned(12);
    }
    return m_M34;
}

inline
void CGL_matrix_Base::SetM34(CGL_matrix_Base::TM34 value)
{
    m_M34 = value;
    m_set_State[0] |= 0x3000000;
}

inline
CGL_matrix_Base::TM34& CGL_matrix_Base::SetM34(void)
{
#ifdef _DEBUG
    if (!IsSetM34()) {
        memset(&m_M34,UnassignedByte(),sizeof(m_M34));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_M34;
}

inline
bool CGL_matrix_Base::IsSetM41(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM41(void) const
{
    return IsSetM41();
}

inline
void CGL_matrix_Base::ResetM41(void)
{
    m_M41 = 0;
    m_set_State[0] &= ~0xc000000;
}

inline
CGL_matrix_Base::TM41 CGL_matrix_Base::GetM41(void) const
{
    if (!CanGetM41()) {
        ThrowUnassigned(13);
    }
    return m_M41;
}

inline
void CGL_matrix_Base::SetM41(CGL_matrix_Base::TM41 value)
{
    m_M41 = value;
    m_set_State[0] |= 0xc000000;
}

inline
CGL_matrix_Base::TM41& CGL_matrix_Base::SetM41(void)
{
#ifdef _DEBUG
    if (!IsSetM41()) {
        memset(&m_M41,UnassignedByte(),sizeof(m_M41));
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_M41;
}

inline
bool CGL_matrix_Base::IsSetM42(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM42(void) const
{
    return IsSetM42();
}

inline
void CGL_matrix_Base::ResetM42(void)
{
    m_M42 = 0;
    m_set_State[0] &= ~0x30000000;
}

inline
CGL_matrix_Base::TM42 CGL_matrix_Base::GetM42(void) const
{
    if (!CanGetM42()) {
        ThrowUnassigned(14);
    }
    return m_M42;
}

inline
void CGL_matrix_Base::SetM42(CGL_matrix_Base::TM42 value)
{
    m_M42 = value;
    m_set_State[0] |= 0x30000000;
}

inline
CGL_matrix_Base::TM42& CGL_matrix_Base::SetM42(void)
{
#ifdef _DEBUG
    if (!IsSetM42()) {
        memset(&m_M42,UnassignedByte(),sizeof(m_M42));
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_M42;
}

inline
bool CGL_matrix_Base::IsSetM43(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CGL_matrix_Base::CanGetM43(void) const
{
    return IsSetM43();
}

inline
void CGL_matrix_Base::ResetM43(void)
{
    m_M43 = 0;
    m_set_State[0] &= ~0xc0000000;
}

inline
CGL_matrix_Base::TM43 CGL_matrix_Base::GetM43(void) const
{
    if (!CanGetM43()) {
        ThrowUnassigned(15);
    }
    return m_M43;
}

inline
void CGL_matrix_Base::SetM43(CGL_matrix_Base::TM43 value)
{
    m_M43 = value;
    m_set_State[0] |= 0xc0000000;
}

inline
CGL_matrix_Base::TM43& CGL_matrix_Base::SetM43(void)
{
#ifdef _DEBUG
    if (!IsSetM43()) {
        memset(&m_M43,UnassignedByte(),sizeof(m_M43));
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_M43;
}

inline
bool CGL_matrix_Base::IsSetM44(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CGL_matrix_Base::CanGetM44(void) const
{
    return IsSetM44();
}

inline
void CGL_matrix_Base::ResetM44(void)
{
    m_M44 = 0;
    m_set_State[1] &= ~0x3;
}

inline
CGL_matrix_Base::TM44 CGL_matrix_Base::GetM44(void) const
{
    if (!CanGetM44()) {
        ThrowUnassigned(16);
    }
    return m_M44;
}

inline
void CGL_matrix_Base::SetM44(CGL_matrix_Base::TM44 value)
{
    m_M44 = value;
    m_set_State[1] |= 0x3;
}

inline
CGL_matrix_Base::TM44& CGL_matrix_Base::SetM44(void)
{
#ifdef _DEBUG
    if (!IsSetM44()) {
        memset(&m_M44,UnassignedByte(),sizeof(m_M44));
    }
#endif
    m_set_State[1] |= 0x1;
    return m_M44;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_GL_MATRIX_BASE_HPP
