/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_model_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_BIOSTRUC_MODEL_BASE_HPP
#define OBJECTS_MMDB2_BIOSTRUC_MODEL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/mmdb2/Model_id.hpp>
#include <objects/mmdb2/Model_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CModel_coordinate_set;
class CModel_descr;
class CModel_space;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A structural model maps chemical components into a measured three-
/// dimensional space. PDB-derived biostrucs generally contain 4 models, 
/// corresponding to "views" of the structure of a biomolecular assemble with 
/// increasing levels of complexity.  Model types indicate the complexity of the
/// view.  
/// The model named "NCBI all atom" represents a view suitable for most 
/// computational biology applications.  It provides complete atomic coordinate 
/// data for a "single best" model, omitting statistical disorder information 
/// and/or ensemble structure descriptions provided in the source PDB file.  
/// Construction of the single best model is based on the assumption that the 
/// contents of the "alternate conformation" field from pdb imply no correlation
/// among the occupancies of multiple sites assigned to sets of atoms: the best 
/// site is chosen only on the basis of highest occupancy. Note, however, that 
/// alternate conformation sets where correlation is implied are generally 
/// constrained in crystallographic refinement to have uniform occupancy, and 
/// will thus be selected as a set. For ensemble models the model which assigns 
/// coordinates to the most atoms is chosen.  If numbers of coordinates are the 
/// same, the model occurring first in the PDB file is selected.  The single 
/// best model includes complete coordinates for all nonpolymer components, but 
/// omits those classified as "solvent".  Model type is 3 for this model. 
/// The model named "NCBI backbone" represents a simple view intended for 
/// graphic displays and rapid transmission over a network.  It includes only 
/// alpha carbon or backbone phosphate coordinates for biopolymers. It is based 
/// on selection of alpha-carbon and backbone phosphate atoms from the "NCBI
/// all atom" model. The model type is set to 2.  An even simpler model gives 
/// only a cartoon representation, using cylinders corresponding to secondary 
/// structure elements.  This is named "NCBI vector", and has model type 1.
/// The models named "PDB Model 1", "PDB Model 2", etc. represent the complete
/// information provided by PDB, including full descriptions of statistical
/// disorder.  The name of the model is based on the contents of the PDB MODEL
/// record, with a default name of "PDB Model 1" for PDB files which contain 
/// only a single model.  Construction of these models is based on the 
/// assumption that contents of the PDB "alternate conformation" field are 
/// intended to imply correlation among the occupancies of atom sets flagged by
/// the same identifier.  The special flag " " (blank) is assumed to indicate 
/// sites occupied in all alternate conformations, and sites flagged otherwise,
/// together with " ", to indicate a distinct member of an ensemble of 
/// alternate conformations.  Note that construction of ensemble members 
/// according to these assumption requires two validation checks on PDB 
/// "alternate conformation" flags: they must be unique among sites assigned to 
/// the same atom, and that the special " " flag must occur only for unique
/// sites.  Sites which violate the first check are flagged as "u", for 
/// "unknown"; they are omitted from all ensemble definitions but are 
/// nontheless retained in the coordinate list.  Sites which violate the second
/// check are flagged "b" for "blank", and are included in an appropriately
/// named ensemble.  The model type for pdb all models is 4.
/// Note that in the MMDB database models are stored in the ASN.1 stream in
/// order of increasing model type value.  Since models occur as the last item
/// in a biostruc, parsers may avoid reading the entire stream if the desired
/// model is one of the simplified types, which occur first in the stream. This
/// can save considerable I/O time, particularly for large ensemble models from 
/// NMR determinations.
class NCBI_MMDB2_EXPORT CBiostruc_model_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_model_Base(void);
    // destructor
    virtual ~CBiostruc_model_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CModel_id TId;
    typedef int TType;
    typedef list< CRef< CModel_descr > > TDescr;
    typedef CModel_space TModel_space;
    typedef list< CRef< CModel_coordinate_set > > TModel_coordinates;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_type,
        e_descr,
        e_model_space,
        e_model_coordinates
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CModel_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef list< CRef< CModel_descr > > TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    TDescr& SetDescr(void);

    /// optional
    /// typedef CModel_space TModel_space
    ///  Check whether the Model_space data member has been assigned a value.
    bool IsSetModel_space(void) const;
    /// Check whether it is safe or not to call GetModel_space method.
    bool CanGetModel_space(void) const;
    void ResetModel_space(void);
    const TModel_space& GetModel_space(void) const;
    void SetModel_space(TModel_space& value);
    TModel_space& SetModel_space(void);

    /// optional
    /// typedef list< CRef< CModel_coordinate_set > > TModel_coordinates
    ///  Check whether the Model_coordinates data member has been assigned a value.
    bool IsSetModel_coordinates(void) const;
    /// Check whether it is safe or not to call GetModel_coordinates method.
    bool CanGetModel_coordinates(void) const;
    void ResetModel_coordinates(void);
    const TModel_coordinates& GetModel_coordinates(void) const;
    TModel_coordinates& SetModel_coordinates(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBiostruc_model_Base(const CBiostruc_model_Base&);
    CBiostruc_model_Base& operator=(const CBiostruc_model_Base&);

    // data
    Uint4 m_set_State[1];
    CModel_id m_Id;
    int m_Type;
    list< CRef< CModel_descr > > m_Descr;
    CRef< TModel_space > m_Model_space;
    list< CRef< CModel_coordinate_set > > m_Model_coordinates;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBiostruc_model_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBiostruc_model_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CBiostruc_model_Base::ResetId(void)
{
    m_Id = CModel_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CBiostruc_model_Base::TId& CBiostruc_model_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CBiostruc_model_Base::SetId(const CBiostruc_model_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CBiostruc_model_Base::TId& CBiostruc_model_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CBiostruc_model_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBiostruc_model_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CBiostruc_model_Base::ResetType(void)
{
    m_Type = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CBiostruc_model_Base::TType CBiostruc_model_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CBiostruc_model_Base::SetType(CBiostruc_model_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CBiostruc_model_Base::TType& CBiostruc_model_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CBiostruc_model_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBiostruc_model_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CBiostruc_model_Base::TDescr& CBiostruc_model_Base::GetDescr(void) const
{
    return m_Descr;
}

inline
CBiostruc_model_Base::TDescr& CBiostruc_model_Base::SetDescr(void)
{
    m_set_State[0] |= 0x10;
    return m_Descr;
}

inline
bool CBiostruc_model_Base::IsSetModel_space(void) const
{
    return m_Model_space.NotEmpty();
}

inline
bool CBiostruc_model_Base::CanGetModel_space(void) const
{
    return IsSetModel_space();
}

inline
const CBiostruc_model_Base::TModel_space& CBiostruc_model_Base::GetModel_space(void) const
{
    if (!CanGetModel_space()) {
        ThrowUnassigned(3);
    }
    return (*m_Model_space);
}

inline
bool CBiostruc_model_Base::IsSetModel_coordinates(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBiostruc_model_Base::CanGetModel_coordinates(void) const
{
    return true;
}

inline
const CBiostruc_model_Base::TModel_coordinates& CBiostruc_model_Base::GetModel_coordinates(void) const
{
    return m_Model_coordinates;
}

inline
CBiostruc_model_Base::TModel_coordinates& CBiostruc_model_Base::SetModel_coordinates(void)
{
    m_set_State[0] |= 0x100;
    return m_Model_coordinates;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_BIOSTRUC_MODEL_BASE_HPP
