/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Anisotro_temperatu_factors_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_ANISOTRO_TEMPERATU_FACTORS_BASE_HPP
#define OBJECTS_MMDB2_ANISOTRO_TEMPERATU_FACTORS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB2_EXPORT CAnisotropic_temperature_factors_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAnisotropic_temperature_factors_Base(void);
    // destructor
    virtual ~CAnisotropic_temperature_factors_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TScale_factor;
    typedef list< int > TB_11;
    typedef list< int > TB_12;
    typedef list< int > TB_13;
    typedef list< int > TB_22;
    typedef list< int > TB_23;
    typedef list< int > TB_33;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scale_factor,
        e_b_11,
        e_b_12,
        e_b_13,
        e_b_22,
        e_b_23,
        e_b_33
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef list< int > TB_11
    ///  Check whether the B_11 data member has been assigned a value.
    bool IsSetB_11(void) const;
    /// Check whether it is safe or not to call GetB_11 method.
    bool CanGetB_11(void) const;
    void ResetB_11(void);
    const TB_11& GetB_11(void) const;
    TB_11& SetB_11(void);

    /// mandatory
    /// typedef list< int > TB_12
    ///  Check whether the B_12 data member has been assigned a value.
    bool IsSetB_12(void) const;
    /// Check whether it is safe or not to call GetB_12 method.
    bool CanGetB_12(void) const;
    void ResetB_12(void);
    const TB_12& GetB_12(void) const;
    TB_12& SetB_12(void);

    /// mandatory
    /// typedef list< int > TB_13
    ///  Check whether the B_13 data member has been assigned a value.
    bool IsSetB_13(void) const;
    /// Check whether it is safe or not to call GetB_13 method.
    bool CanGetB_13(void) const;
    void ResetB_13(void);
    const TB_13& GetB_13(void) const;
    TB_13& SetB_13(void);

    /// mandatory
    /// typedef list< int > TB_22
    ///  Check whether the B_22 data member has been assigned a value.
    bool IsSetB_22(void) const;
    /// Check whether it is safe or not to call GetB_22 method.
    bool CanGetB_22(void) const;
    void ResetB_22(void);
    const TB_22& GetB_22(void) const;
    TB_22& SetB_22(void);

    /// mandatory
    /// typedef list< int > TB_23
    ///  Check whether the B_23 data member has been assigned a value.
    bool IsSetB_23(void) const;
    /// Check whether it is safe or not to call GetB_23 method.
    bool CanGetB_23(void) const;
    void ResetB_23(void);
    const TB_23& GetB_23(void) const;
    TB_23& SetB_23(void);

    /// mandatory
    /// typedef list< int > TB_33
    ///  Check whether the B_33 data member has been assigned a value.
    bool IsSetB_33(void) const;
    /// Check whether it is safe or not to call GetB_33 method.
    bool CanGetB_33(void) const;
    void ResetB_33(void);
    const TB_33& GetB_33(void) const;
    TB_33& SetB_33(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAnisotropic_temperature_factors_Base(const CAnisotropic_temperature_factors_Base&);
    CAnisotropic_temperature_factors_Base& operator=(const CAnisotropic_temperature_factors_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Scale_factor;
    list< int > m_B_11;
    list< int > m_B_12;
    list< int > m_B_13;
    list< int > m_B_22;
    list< int > m_B_23;
    list< int > m_B_33;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAnisotropic_temperature_factors_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAnisotropic_temperature_factors_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CAnisotropic_temperature_factors_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0x3;
}

inline
CAnisotropic_temperature_factors_Base::TScale_factor CAnisotropic_temperature_factors_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(0);
    }
    return m_Scale_factor;
}

inline
void CAnisotropic_temperature_factors_Base::SetScale_factor(CAnisotropic_temperature_factors_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0x3;
}

inline
CAnisotropic_temperature_factors_Base::TScale_factor& CAnisotropic_temperature_factors_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scale_factor;
}

inline
bool CAnisotropic_temperature_factors_Base::IsSetB_11(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAnisotropic_temperature_factors_Base::CanGetB_11(void) const
{
    return true;
}

inline
const CAnisotropic_temperature_factors_Base::TB_11& CAnisotropic_temperature_factors_Base::GetB_11(void) const
{
    return m_B_11;
}

inline
CAnisotropic_temperature_factors_Base::TB_11& CAnisotropic_temperature_factors_Base::SetB_11(void)
{
    m_set_State[0] |= 0x4;
    return m_B_11;
}

inline
bool CAnisotropic_temperature_factors_Base::IsSetB_12(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAnisotropic_temperature_factors_Base::CanGetB_12(void) const
{
    return true;
}

inline
const CAnisotropic_temperature_factors_Base::TB_12& CAnisotropic_temperature_factors_Base::GetB_12(void) const
{
    return m_B_12;
}

inline
CAnisotropic_temperature_factors_Base::TB_12& CAnisotropic_temperature_factors_Base::SetB_12(void)
{
    m_set_State[0] |= 0x10;
    return m_B_12;
}

inline
bool CAnisotropic_temperature_factors_Base::IsSetB_13(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAnisotropic_temperature_factors_Base::CanGetB_13(void) const
{
    return true;
}

inline
const CAnisotropic_temperature_factors_Base::TB_13& CAnisotropic_temperature_factors_Base::GetB_13(void) const
{
    return m_B_13;
}

inline
CAnisotropic_temperature_factors_Base::TB_13& CAnisotropic_temperature_factors_Base::SetB_13(void)
{
    m_set_State[0] |= 0x40;
    return m_B_13;
}

inline
bool CAnisotropic_temperature_factors_Base::IsSetB_22(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAnisotropic_temperature_factors_Base::CanGetB_22(void) const
{
    return true;
}

inline
const CAnisotropic_temperature_factors_Base::TB_22& CAnisotropic_temperature_factors_Base::GetB_22(void) const
{
    return m_B_22;
}

inline
CAnisotropic_temperature_factors_Base::TB_22& CAnisotropic_temperature_factors_Base::SetB_22(void)
{
    m_set_State[0] |= 0x100;
    return m_B_22;
}

inline
bool CAnisotropic_temperature_factors_Base::IsSetB_23(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAnisotropic_temperature_factors_Base::CanGetB_23(void) const
{
    return true;
}

inline
const CAnisotropic_temperature_factors_Base::TB_23& CAnisotropic_temperature_factors_Base::GetB_23(void) const
{
    return m_B_23;
}

inline
CAnisotropic_temperature_factors_Base::TB_23& CAnisotropic_temperature_factors_Base::SetB_23(void)
{
    m_set_State[0] |= 0x400;
    return m_B_23;
}

inline
bool CAnisotropic_temperature_factors_Base::IsSetB_33(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAnisotropic_temperature_factors_Base::CanGetB_33(void) const
{
    return true;
}

inline
const CAnisotropic_temperature_factors_Base::TB_33& CAnisotropic_temperature_factors_Base::GetB_33(void) const
{
    return m_B_33;
}

inline
CAnisotropic_temperature_factors_Base::TB_33& CAnisotropic_temperature_factors_Base::SetB_33(void)
{
    m_set_State[0] |= 0x1000;
    return m_B_33;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_ANISOTRO_TEMPERATU_FACTORS_BASE_HPP
