/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Text_transform_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_TEXT_TRANSFORM_BASE_HPP
#define OBJECTS_MACRO_TEXT_TRANSFORM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Cap_change.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CField_edit;
class CText_portion;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CText_transform_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CText_transform_Base(void);
    // destructor
    virtual ~CText_transform_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Edit,
        e_Caps,
        e_Remove
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Remove+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CField_edit TEdit;
    typedef ECap_change TCaps;
    typedef CText_portion TRemove;

    // getters
    // setters

    // typedef CField_edit TEdit
    bool IsEdit(void) const;
    const TEdit& GetEdit(void) const;
    TEdit& SetEdit(void);
    void SetEdit(TEdit& value);

    // typedef ECap_change TCaps
    bool IsCaps(void) const;
    TCaps GetCaps(void) const;
    TCaps& SetCaps(void);
    void SetCaps(TCaps value);

    // typedef CText_portion TRemove
    bool IsRemove(void) const;
    const TRemove& GetRemove(void) const;
    TRemove& SetRemove(void);
    void SetRemove(TRemove& value);


private:
    // copy constructor and assignment operator
    CText_transform_Base(const CText_transform_Base& );
    CText_transform_Base& operator=(const CText_transform_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TCaps m_Caps;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CText_transform_Base::E_Choice CText_transform_Base::Which(void) const
{
    return m_choice;
}

inline
void CText_transform_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CText_transform_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CText_transform_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CText_transform_Base::IsEdit(void) const
{
    return m_choice == e_Edit;
}

inline
bool CText_transform_Base::IsCaps(void) const
{
    return m_choice == e_Caps;
}

inline
CText_transform_Base::TCaps CText_transform_Base::GetCaps(void) const
{
    CheckSelected(e_Caps);
    return m_Caps;
}

inline
CText_transform_Base::TCaps& CText_transform_Base::SetCaps(void)
{
    Select(e_Caps, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Caps;
}

inline
void CText_transform_Base::SetCaps(CText_transform_Base::TCaps value)
{
    Select(e_Caps, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Caps = value;
}

inline
bool CText_transform_Base::IsRemove(void) const
{
    return m_choice == e_Remove;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_TEXT_TRANSFORM_BASE_HPP
