/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Sequence_constraint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_SEQUENCE_CONSTRAINT_BASE_HPP
#define OBJECTS_MACRO_SEQUENCE_CONSTRAINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Feature_stranded_constrain.hpp>
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CQuantity_constraint;
class CSequence_constraint_mol_type_constraint;
class CString_constraint;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSequence_constraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSequence_constraint_Base(void);
    // destructor
    virtual ~CSequence_constraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSequence_constraint_mol_type_constraint TSeqtype;
    typedef CString_constraint TId;
    typedef EMacro_feature_type TFeature;
    typedef CQuantity_constraint TNum_type_features;
    typedef CQuantity_constraint TNum_features;
    typedef CQuantity_constraint TLength;
    typedef EFeature_strandedness_constraint TStrandedness;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seqtype,
        e_id,
        e_feature,
        e_num_type_features,
        e_num_features,
        e_length,
        e_strandedness
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CSequence_constraint_mol_type_constraint TSeqtype
    ///  Check whether the Seqtype data member has been assigned a value.
    bool IsSetSeqtype(void) const;
    /// Check whether it is safe or not to call GetSeqtype method.
    bool CanGetSeqtype(void) const;
    void ResetSeqtype(void);
    const TSeqtype& GetSeqtype(void) const;
    void SetSeqtype(TSeqtype& value);
    TSeqtype& SetSeqtype(void);

    /// optional
    /// typedef CString_constraint TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef EMacro_feature_type TFeature
    ///  Check whether the Feature data member has been assigned a value.
    bool IsSetFeature(void) const;
    /// Check whether it is safe or not to call GetFeature method.
    bool CanGetFeature(void) const;
    void ResetFeature(void);
    TFeature GetFeature(void) const;
    void SetFeature(TFeature value);
    TFeature& SetFeature(void);

    /// optional
    /// typedef CQuantity_constraint TNum_type_features
    ///  Check whether the Num_type_features data member has been assigned a value.
    bool IsSetNum_type_features(void) const;
    /// Check whether it is safe or not to call GetNum_type_features method.
    bool CanGetNum_type_features(void) const;
    void ResetNum_type_features(void);
    const TNum_type_features& GetNum_type_features(void) const;
    void SetNum_type_features(TNum_type_features& value);
    TNum_type_features& SetNum_type_features(void);

    /// optional
    /// typedef CQuantity_constraint TNum_features
    ///  Check whether the Num_features data member has been assigned a value.
    bool IsSetNum_features(void) const;
    /// Check whether it is safe or not to call GetNum_features method.
    bool CanGetNum_features(void) const;
    void ResetNum_features(void);
    const TNum_features& GetNum_features(void) const;
    void SetNum_features(TNum_features& value);
    TNum_features& SetNum_features(void);

    /// optional
    /// typedef CQuantity_constraint TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    const TLength& GetLength(void) const;
    void SetLength(TLength& value);
    TLength& SetLength(void);

    /// optional with default eFeature_strandedness_constraint_any
    /// typedef EFeature_strandedness_constraint TStrandedness
    ///  Check whether the Strandedness data member has been assigned a value.
    bool IsSetStrandedness(void) const;
    /// Check whether it is safe or not to call GetStrandedness method.
    bool CanGetStrandedness(void) const;
    void ResetStrandedness(void);
    void SetDefaultStrandedness(void);
    TStrandedness GetStrandedness(void) const;
    void SetStrandedness(TStrandedness value);
    TStrandedness& SetStrandedness(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSequence_constraint_Base(const CSequence_constraint_Base&);
    CSequence_constraint_Base& operator=(const CSequence_constraint_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeqtype > m_Seqtype;
    CRef< TId > m_Id;
    EMacro_feature_type m_Feature;
    CRef< TNum_type_features > m_Num_type_features;
    CRef< TNum_features > m_Num_features;
    CRef< TLength > m_Length;
    EFeature_strandedness_constraint m_Strandedness;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSequence_constraint_Base::IsSetSeqtype(void) const
{
    return m_Seqtype.NotEmpty();
}

inline
bool CSequence_constraint_Base::CanGetSeqtype(void) const
{
    return IsSetSeqtype();
}

inline
const CSequence_constraint_Base::TSeqtype& CSequence_constraint_Base::GetSeqtype(void) const
{
    if (!CanGetSeqtype()) {
        ThrowUnassigned(0);
    }
    return (*m_Seqtype);
}

inline
bool CSequence_constraint_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSequence_constraint_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CSequence_constraint_Base::TId& CSequence_constraint_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(1);
    }
    return (*m_Id);
}

inline
bool CSequence_constraint_Base::IsSetFeature(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSequence_constraint_Base::CanGetFeature(void) const
{
    return IsSetFeature();
}

inline
void CSequence_constraint_Base::ResetFeature(void)
{
    m_Feature = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x30;
}

inline
CSequence_constraint_Base::TFeature CSequence_constraint_Base::GetFeature(void) const
{
    if (!CanGetFeature()) {
        ThrowUnassigned(2);
    }
    return m_Feature;
}

inline
void CSequence_constraint_Base::SetFeature(CSequence_constraint_Base::TFeature value)
{
    m_Feature = value;
    m_set_State[0] |= 0x30;
}

inline
CSequence_constraint_Base::TFeature& CSequence_constraint_Base::SetFeature(void)
{
#ifdef _DEBUG
    if (!IsSetFeature()) {
        memset(&m_Feature,UnassignedByte(),sizeof(m_Feature));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Feature;
}

inline
bool CSequence_constraint_Base::IsSetNum_type_features(void) const
{
    return m_Num_type_features.NotEmpty();
}

inline
bool CSequence_constraint_Base::CanGetNum_type_features(void) const
{
    return IsSetNum_type_features();
}

inline
const CSequence_constraint_Base::TNum_type_features& CSequence_constraint_Base::GetNum_type_features(void) const
{
    if (!CanGetNum_type_features()) {
        ThrowUnassigned(3);
    }
    return (*m_Num_type_features);
}

inline
bool CSequence_constraint_Base::IsSetNum_features(void) const
{
    return m_Num_features.NotEmpty();
}

inline
bool CSequence_constraint_Base::CanGetNum_features(void) const
{
    return IsSetNum_features();
}

inline
const CSequence_constraint_Base::TNum_features& CSequence_constraint_Base::GetNum_features(void) const
{
    if (!CanGetNum_features()) {
        ThrowUnassigned(4);
    }
    return (*m_Num_features);
}

inline
bool CSequence_constraint_Base::IsSetLength(void) const
{
    return m_Length.NotEmpty();
}

inline
bool CSequence_constraint_Base::CanGetLength(void) const
{
    return IsSetLength();
}

inline
const CSequence_constraint_Base::TLength& CSequence_constraint_Base::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(5);
    }
    return (*m_Length);
}

inline
bool CSequence_constraint_Base::IsSetStrandedness(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSequence_constraint_Base::CanGetStrandedness(void) const
{
    return true;
}

inline
void CSequence_constraint_Base::ResetStrandedness(void)
{
    m_Strandedness = eFeature_strandedness_constraint_any;
    m_set_State[0] &= ~0x3000;
}

inline
void CSequence_constraint_Base::SetDefaultStrandedness(void)
{
    ResetStrandedness();
}

inline
CSequence_constraint_Base::TStrandedness CSequence_constraint_Base::GetStrandedness(void) const
{
    return m_Strandedness;
}

inline
void CSequence_constraint_Base::SetStrandedness(CSequence_constraint_Base::TStrandedness value)
{
    m_Strandedness = value;
    m_set_State[0] |= 0x3000;
}

inline
CSequence_constraint_Base::TStrandedness& CSequence_constraint_Base::SetStrandedness(void)
{
#ifdef _DEBUG
    if (!IsSetStrandedness()) {
        memset(&m_Strandedness,UnassignedByte(),sizeof(m_Strandedness));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Strandedness;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_SEQUENCE_CONSTRAINT_BASE_HPP
