/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Search_func_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_SEARCH_FUNC_BASE_HPP
#define OBJECTS_MACRO_SEARCH_FUNC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CString_constraint;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSearch_func_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSearch_func_Base(void);
    // destructor
    virtual ~CSearch_func_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,                        ///< No variant selected
        e_String_constraint,
        e_Contains_plural,
        e_N_or_more_brackets_or_parentheses,
        e_Three_numbers,
        e_Underscore,
        e_Prefix_and_numbers,
        e_All_caps,
        e_Unbalanced_paren,
        e_Too_long,
        e_Has_term
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 11 ///< == e_Has_term+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CString_constraint TString_constraint;
    typedef int TN_or_more_brackets_or_parentheses;
    typedef string TPrefix_and_numbers;
    typedef int TToo_long;
    typedef string THas_term;

    // getters
    // setters

    // typedef CString_constraint TString_constraint
    bool IsString_constraint(void) const;
    const TString_constraint& GetString_constraint(void) const;
    TString_constraint& SetString_constraint(void);
    void SetString_constraint(TString_constraint& value);


    bool IsContains_plural(void) const;
    void SetContains_plural(void);

    // typedef int TN_or_more_brackets_or_parentheses
    bool IsN_or_more_brackets_or_parentheses(void) const;
    TN_or_more_brackets_or_parentheses GetN_or_more_brackets_or_parentheses(void) const;
    TN_or_more_brackets_or_parentheses& SetN_or_more_brackets_or_parentheses(void);
    void SetN_or_more_brackets_or_parentheses(TN_or_more_brackets_or_parentheses value);


    bool IsThree_numbers(void) const;
    void SetThree_numbers(void);


    bool IsUnderscore(void) const;
    void SetUnderscore(void);

    // typedef string TPrefix_and_numbers
    bool IsPrefix_and_numbers(void) const;
    const TPrefix_and_numbers& GetPrefix_and_numbers(void) const;
    TPrefix_and_numbers& SetPrefix_and_numbers(void);
    void SetPrefix_and_numbers(const TPrefix_and_numbers& value);


    bool IsAll_caps(void) const;
    void SetAll_caps(void);


    bool IsUnbalanced_paren(void) const;
    void SetUnbalanced_paren(void);

    // typedef int TToo_long
    bool IsToo_long(void) const;
    TToo_long GetToo_long(void) const;
    TToo_long& SetToo_long(void);
    void SetToo_long(TToo_long value);

    // typedef string THas_term
    bool IsHas_term(void) const;
    const THas_term& GetHas_term(void) const;
    THas_term& SetHas_term(void);
    void SetHas_term(const THas_term& value);


private:
    // copy constructor and assignment operator
    CSearch_func_Base(const CSearch_func_Base& );
    CSearch_func_Base& operator=(const CSearch_func_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TN_or_more_brackets_or_parentheses m_N_or_more_brackets_or_parentheses;
        TToo_long m_Too_long;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSearch_func_Base::E_Choice CSearch_func_Base::Which(void) const
{
    return m_choice;
}

inline
void CSearch_func_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSearch_func_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSearch_func_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSearch_func_Base::IsString_constraint(void) const
{
    return m_choice == e_String_constraint;
}

inline
bool CSearch_func_Base::IsContains_plural(void) const
{
    return m_choice == e_Contains_plural;
}

inline
void CSearch_func_Base::SetContains_plural(void)
{
    Select(e_Contains_plural, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CSearch_func_Base::IsN_or_more_brackets_or_parentheses(void) const
{
    return m_choice == e_N_or_more_brackets_or_parentheses;
}

inline
CSearch_func_Base::TN_or_more_brackets_or_parentheses CSearch_func_Base::GetN_or_more_brackets_or_parentheses(void) const
{
    CheckSelected(e_N_or_more_brackets_or_parentheses);
    return m_N_or_more_brackets_or_parentheses;
}

inline
CSearch_func_Base::TN_or_more_brackets_or_parentheses& CSearch_func_Base::SetN_or_more_brackets_or_parentheses(void)
{
    Select(e_N_or_more_brackets_or_parentheses, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_N_or_more_brackets_or_parentheses;
}

inline
void CSearch_func_Base::SetN_or_more_brackets_or_parentheses(CSearch_func_Base::TN_or_more_brackets_or_parentheses value)
{
    Select(e_N_or_more_brackets_or_parentheses, NCBI_NS_NCBI::eDoNotResetVariant);
    m_N_or_more_brackets_or_parentheses = value;
}

inline
bool CSearch_func_Base::IsThree_numbers(void) const
{
    return m_choice == e_Three_numbers;
}

inline
void CSearch_func_Base::SetThree_numbers(void)
{
    Select(e_Three_numbers, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CSearch_func_Base::IsUnderscore(void) const
{
    return m_choice == e_Underscore;
}

inline
void CSearch_func_Base::SetUnderscore(void)
{
    Select(e_Underscore, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CSearch_func_Base::IsPrefix_and_numbers(void) const
{
    return m_choice == e_Prefix_and_numbers;
}

inline
const CSearch_func_Base::TPrefix_and_numbers& CSearch_func_Base::GetPrefix_and_numbers(void) const
{
    CheckSelected(e_Prefix_and_numbers);
    return *m_string;
}

inline
CSearch_func_Base::TPrefix_and_numbers& CSearch_func_Base::SetPrefix_and_numbers(void)
{
    Select(e_Prefix_and_numbers, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSearch_func_Base::IsAll_caps(void) const
{
    return m_choice == e_All_caps;
}

inline
void CSearch_func_Base::SetAll_caps(void)
{
    Select(e_All_caps, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CSearch_func_Base::IsUnbalanced_paren(void) const
{
    return m_choice == e_Unbalanced_paren;
}

inline
void CSearch_func_Base::SetUnbalanced_paren(void)
{
    Select(e_Unbalanced_paren, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CSearch_func_Base::IsToo_long(void) const
{
    return m_choice == e_Too_long;
}

inline
CSearch_func_Base::TToo_long CSearch_func_Base::GetToo_long(void) const
{
    CheckSelected(e_Too_long);
    return m_Too_long;
}

inline
CSearch_func_Base::TToo_long& CSearch_func_Base::SetToo_long(void)
{
    Select(e_Too_long, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Too_long;
}

inline
void CSearch_func_Base::SetToo_long(CSearch_func_Base::TToo_long value)
{
    Select(e_Too_long, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Too_long = value;
}

inline
bool CSearch_func_Base::IsHas_term(void) const
{
    return m_choice == e_Has_term;
}

inline
const CSearch_func_Base::THas_term& CSearch_func_Base::GetHas_term(void) const
{
    CheckSelected(e_Has_term);
    return *m_string;
}

inline
CSearch_func_Base::THas_term& CSearch_func_Base::SetHas_term(void)
{
    Select(e_Has_term, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_SEARCH_FUNC_BASE_HPP
