/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file CDSGenePr_pseudo_constrain_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_CDSGENEPR_PSEUDO_CONSTRAIN_BASE_HPP
#define OBJECTS_MACRO_CDSGENEPR_PSEUDO_CONSTRAIN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/CDSGen_featur_type_constra.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCDSGeneProt_pseudo_constraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCDSGeneProt_pseudo_constraint_Base(void);
    // destructor
    virtual ~CCDSGeneProt_pseudo_constraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef ECDSGeneProt_feature_type_constraint TFeature;
    typedef bool TIs_pseudo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_feature,
        e_is_pseudo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef ECDSGeneProt_feature_type_constraint TFeature
    ///  Check whether the Feature data member has been assigned a value.
    bool IsSetFeature(void) const;
    /// Check whether it is safe or not to call GetFeature method.
    bool CanGetFeature(void) const;
    void ResetFeature(void);
    TFeature GetFeature(void) const;
    void SetFeature(TFeature value);
    TFeature& SetFeature(void);

    /// optional with default true
    /// typedef bool TIs_pseudo
    ///  Check whether the Is_pseudo data member has been assigned a value.
    bool IsSetIs_pseudo(void) const;
    /// Check whether it is safe or not to call GetIs_pseudo method.
    bool CanGetIs_pseudo(void) const;
    void ResetIs_pseudo(void);
    void SetDefaultIs_pseudo(void);
    TIs_pseudo GetIs_pseudo(void) const;
    void SetIs_pseudo(TIs_pseudo value);
    TIs_pseudo& SetIs_pseudo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCDSGeneProt_pseudo_constraint_Base(const CCDSGeneProt_pseudo_constraint_Base&);
    CCDSGeneProt_pseudo_constraint_Base& operator=(const CCDSGeneProt_pseudo_constraint_Base&);

    // data
    Uint4 m_set_State[1];
    ECDSGeneProt_feature_type_constraint m_Feature;
    bool m_Is_pseudo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCDSGeneProt_pseudo_constraint_Base::IsSetFeature(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCDSGeneProt_pseudo_constraint_Base::CanGetFeature(void) const
{
    return IsSetFeature();
}

inline
void CCDSGeneProt_pseudo_constraint_Base::ResetFeature(void)
{
    m_Feature = (ncbi::objects::ECDSGeneProt_feature_type_constraint)(0);
    m_set_State[0] &= ~0x3;
}

inline
CCDSGeneProt_pseudo_constraint_Base::TFeature CCDSGeneProt_pseudo_constraint_Base::GetFeature(void) const
{
    if (!CanGetFeature()) {
        ThrowUnassigned(0);
    }
    return m_Feature;
}

inline
void CCDSGeneProt_pseudo_constraint_Base::SetFeature(CCDSGeneProt_pseudo_constraint_Base::TFeature value)
{
    m_Feature = value;
    m_set_State[0] |= 0x3;
}

inline
CCDSGeneProt_pseudo_constraint_Base::TFeature& CCDSGeneProt_pseudo_constraint_Base::SetFeature(void)
{
#ifdef _DEBUG
    if (!IsSetFeature()) {
        memset(&m_Feature,UnassignedByte(),sizeof(m_Feature));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Feature;
}

inline
bool CCDSGeneProt_pseudo_constraint_Base::IsSetIs_pseudo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCDSGeneProt_pseudo_constraint_Base::CanGetIs_pseudo(void) const
{
    return true;
}

inline
void CCDSGeneProt_pseudo_constraint_Base::ResetIs_pseudo(void)
{
    m_Is_pseudo = true;
    m_set_State[0] &= ~0xc;
}

inline
void CCDSGeneProt_pseudo_constraint_Base::SetDefaultIs_pseudo(void)
{
    ResetIs_pseudo();
}

inline
CCDSGeneProt_pseudo_constraint_Base::TIs_pseudo CCDSGeneProt_pseudo_constraint_Base::GetIs_pseudo(void) const
{
    return m_Is_pseudo;
}

inline
void CCDSGeneProt_pseudo_constraint_Base::SetIs_pseudo(CCDSGeneProt_pseudo_constraint_Base::TIs_pseudo value)
{
    m_Is_pseudo = value;
    m_set_State[0] |= 0xc;
}

inline
CCDSGeneProt_pseudo_constraint_Base::TIs_pseudo& CCDSGeneProt_pseudo_constraint_Base::SetIs_pseudo(void)
{
#ifdef _DEBUG
    if (!IsSetIs_pseudo()) {
        memset(&m_Is_pseudo,UnassignedByte(),sizeof(m_Is_pseudo));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Is_pseudo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_CDSGENEPR_PSEUDO_CONSTRAIN_BASE_HPP
