/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AECR_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_AECR_ACTION_BASE_HPP
#define OBJECTS_MACRO_AECR_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAction_choice;
class CConstraint_choice_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAECR_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAECR_action_Base(void);
    // destructor
    virtual ~CAECR_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CAction_choice TAction;
    typedef bool TAlso_change_mrna;
    typedef CConstraint_choice_set TConstraint;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_action,
        e_also_change_mrna,
        e_constraint
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CAction_choice TAction
    ///  Check whether the Action data member has been assigned a value.
    bool IsSetAction(void) const;
    /// Check whether it is safe or not to call GetAction method.
    bool CanGetAction(void) const;
    void ResetAction(void);
    const TAction& GetAction(void) const;
    void SetAction(TAction& value);
    TAction& SetAction(void);

    /// optional with default false
    /// typedef bool TAlso_change_mrna
    ///  Check whether the Also_change_mrna data member has been assigned a value.
    bool IsSetAlso_change_mrna(void) const;
    /// Check whether it is safe or not to call GetAlso_change_mrna method.
    bool CanGetAlso_change_mrna(void) const;
    void ResetAlso_change_mrna(void);
    void SetDefaultAlso_change_mrna(void);
    TAlso_change_mrna GetAlso_change_mrna(void) const;
    void SetAlso_change_mrna(TAlso_change_mrna value);
    TAlso_change_mrna& SetAlso_change_mrna(void);

    /// optional
    /// typedef CConstraint_choice_set TConstraint
    ///  Check whether the Constraint data member has been assigned a value.
    bool IsSetConstraint(void) const;
    /// Check whether it is safe or not to call GetConstraint method.
    bool CanGetConstraint(void) const;
    void ResetConstraint(void);
    const TConstraint& GetConstraint(void) const;
    void SetConstraint(TConstraint& value);
    TConstraint& SetConstraint(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAECR_action_Base(const CAECR_action_Base&);
    CAECR_action_Base& operator=(const CAECR_action_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAction > m_Action;
    bool m_Also_change_mrna;
    CRef< TConstraint > m_Constraint;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAECR_action_Base::IsSetAction(void) const
{
    return m_Action.NotEmpty();
}

inline
bool CAECR_action_Base::CanGetAction(void) const
{
    return true;
}

inline
const CAECR_action_Base::TAction& CAECR_action_Base::GetAction(void) const
{
    if ( !m_Action ) {
        const_cast<CAECR_action_Base*>(this)->ResetAction();
    }
    return (*m_Action);
}

inline
CAECR_action_Base::TAction& CAECR_action_Base::SetAction(void)
{
    if ( !m_Action ) {
        ResetAction();
    }
    return (*m_Action);
}

inline
bool CAECR_action_Base::IsSetAlso_change_mrna(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAECR_action_Base::CanGetAlso_change_mrna(void) const
{
    return true;
}

inline
void CAECR_action_Base::ResetAlso_change_mrna(void)
{
    m_Also_change_mrna = false;
    m_set_State[0] &= ~0xc;
}

inline
void CAECR_action_Base::SetDefaultAlso_change_mrna(void)
{
    ResetAlso_change_mrna();
}

inline
CAECR_action_Base::TAlso_change_mrna CAECR_action_Base::GetAlso_change_mrna(void) const
{
    return m_Also_change_mrna;
}

inline
void CAECR_action_Base::SetAlso_change_mrna(CAECR_action_Base::TAlso_change_mrna value)
{
    m_Also_change_mrna = value;
    m_set_State[0] |= 0xc;
}

inline
CAECR_action_Base::TAlso_change_mrna& CAECR_action_Base::SetAlso_change_mrna(void)
{
#ifdef _DEBUG
    if (!IsSetAlso_change_mrna()) {
        memset(&m_Also_change_mrna,UnassignedByte(),sizeof(m_Also_change_mrna));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Also_change_mrna;
}

inline
bool CAECR_action_Base::IsSetConstraint(void) const
{
    return m_Constraint.NotEmpty();
}

inline
bool CAECR_action_Base::CanGetConstraint(void) const
{
    return IsSetConstraint();
}

inline
const CAECR_action_Base::TConstraint& CAECR_action_Base::GetConstraint(void) const
{
    if (!CanGetConstraint()) {
        ThrowUnassigned(2);
    }
    return (*m_Constraint);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_AECR_ACTION_BASE_HPP
