/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID1SeqEntry_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID1_ID1SEQENTRY_INFO_BASE_HPP
#define OBJECTS_ID1_ID1SEQENTRY_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID1blob_info;
class CSeq_entry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID1_EXPORT CID1SeqEntry_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID1SeqEntry_info_Base(void);
    // destructor
    virtual ~CID1SeqEntry_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CID1blob_info TBlob_info;
    typedef CSeq_entry TBlob;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_blob_info,
        e_blob
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CID1blob_info TBlob_info
    ///  Check whether the Blob_info data member has been assigned a value.
    bool IsSetBlob_info(void) const;
    /// Check whether it is safe or not to call GetBlob_info method.
    bool CanGetBlob_info(void) const;
    void ResetBlob_info(void);
    const TBlob_info& GetBlob_info(void) const;
    void SetBlob_info(TBlob_info& value);
    TBlob_info& SetBlob_info(void);

    /// optional
    /// typedef CSeq_entry TBlob
    ///  Check whether the Blob data member has been assigned a value.
    bool IsSetBlob(void) const;
    /// Check whether it is safe or not to call GetBlob method.
    bool CanGetBlob(void) const;
    void ResetBlob(void);
    const TBlob& GetBlob(void) const;
    void SetBlob(TBlob& value);
    TBlob& SetBlob(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID1SeqEntry_info_Base(const CID1SeqEntry_info_Base&);
    CID1SeqEntry_info_Base& operator=(const CID1SeqEntry_info_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBlob_info > m_Blob_info;
    CRef< TBlob > m_Blob;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID1SeqEntry_info_Base::IsSetBlob_info(void) const
{
    return m_Blob_info.NotEmpty();
}

inline
bool CID1SeqEntry_info_Base::CanGetBlob_info(void) const
{
    return true;
}

inline
const CID1SeqEntry_info_Base::TBlob_info& CID1SeqEntry_info_Base::GetBlob_info(void) const
{
    if ( !m_Blob_info ) {
        const_cast<CID1SeqEntry_info_Base*>(this)->ResetBlob_info();
    }
    return (*m_Blob_info);
}

inline
CID1SeqEntry_info_Base::TBlob_info& CID1SeqEntry_info_Base::SetBlob_info(void)
{
    if ( !m_Blob_info ) {
        ResetBlob_info();
    }
    return (*m_Blob_info);
}

inline
bool CID1SeqEntry_info_Base::IsSetBlob(void) const
{
    return m_Blob.NotEmpty();
}

inline
bool CID1SeqEntry_info_Base::CanGetBlob(void) const
{
    return IsSetBlob();
}

inline
const CID1SeqEntry_info_Base::TBlob& CID1SeqEntry_info_Base::GetBlob(void) const
{
    if (!CanGetBlob()) {
        ThrowUnassigned(1);
    }
    return (*m_Blob);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID1_ID1SEQENTRY_INFO_BASE_HPP
