/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ViewMemento_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_VIEWMEMENTO_BASE_HPP
#define OBJECTS_GBPROJ_VIEWMEMENTO_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CViewMemento_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CViewMemento_Base(void);
    // destructor
    virtual ~CViewMemento_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TOptions_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_options_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TOptions_id
    ///  Check whether the Options_id data member has been assigned a value.
    bool IsSetOptions_id(void) const;
    /// Check whether it is safe or not to call GetOptions_id method.
    bool CanGetOptions_id(void) const;
    void ResetOptions_id(void);
    TOptions_id GetOptions_id(void) const;
    void SetOptions_id(TOptions_id value);
    TOptions_id& SetOptions_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CViewMemento_Base(const CViewMemento_Base&);
    CViewMemento_Base& operator=(const CViewMemento_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Options_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CViewMemento_Base::IsSetOptions_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CViewMemento_Base::CanGetOptions_id(void) const
{
    return IsSetOptions_id();
}

inline
void CViewMemento_Base::ResetOptions_id(void)
{
    m_Options_id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CViewMemento_Base::TOptions_id CViewMemento_Base::GetOptions_id(void) const
{
    if (!CanGetOptions_id()) {
        ThrowUnassigned(0);
    }
    return m_Options_id;
}

inline
void CViewMemento_Base::SetOptions_id(CViewMemento_Base::TOptions_id value)
{
    m_Options_id = value;
    m_set_State[0] |= 0x3;
}

inline
CViewMemento_Base::TOptions_id& CViewMemento_Base::SetOptions_id(void)
{
#ifdef _DEBUG
    if (!IsSetOptions_id()) {
        memset(&m_Options_id,UnassignedByte(),sizeof(m_Options_id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Options_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_VIEWMEMENTO_BASE_HPP
