/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HugeFileProjectItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_HUGEFILEPROJECTITEM_BASE_HPP
#define OBJECTS_GBPROJ_HUGEFILEPROJECTITEM_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CHugeFileProjectItem_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHugeFileProjectItem_Base(void);
    // destructor
    virtual ~CHugeFileProjectItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TFile;
    typedef string TTmp_file;
    typedef string TLoader_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_file,
        e_tmp_file,
        e_loader_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// absolute path to the input file
    /// mandatory
    /// typedef string TFile
    ///  Check whether the File data member has been assigned a value.
    bool IsSetFile(void) const;
    /// Check whether it is safe or not to call GetFile method.
    bool CanGetFile(void) const;
    void ResetFile(void);
    const TFile& GetFile(void) const;
    void SetFile(const TFile& value);
    void SetFile(TFile&& value);
    TFile& SetFile(void);

    /// absolute path to the temporary output file
    /// mandatory
    /// typedef string TTmp_file
    ///  Check whether the Tmp_file data member has been assigned a value.
    bool IsSetTmp_file(void) const;
    /// Check whether it is safe or not to call GetTmp_file method.
    bool CanGetTmp_file(void) const;
    void ResetTmp_file(void);
    const TTmp_file& GetTmp_file(void) const;
    void SetTmp_file(const TTmp_file& value);
    void SetTmp_file(TTmp_file&& value);
    TTmp_file& SetTmp_file(void);

    /// loader id to register in OM
    /// mandatory
    /// typedef string TLoader_id
    ///  Check whether the Loader_id data member has been assigned a value.
    bool IsSetLoader_id(void) const;
    /// Check whether it is safe or not to call GetLoader_id method.
    bool CanGetLoader_id(void) const;
    void ResetLoader_id(void);
    const TLoader_id& GetLoader_id(void) const;
    void SetLoader_id(const TLoader_id& value);
    void SetLoader_id(TLoader_id&& value);
    TLoader_id& SetLoader_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHugeFileProjectItem_Base(const CHugeFileProjectItem_Base&);
    CHugeFileProjectItem_Base& operator=(const CHugeFileProjectItem_Base&);

    // data
    Uint4 m_set_State[1];
    string m_File;
    string m_Tmp_file;
    string m_Loader_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHugeFileProjectItem_Base::IsSetFile(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHugeFileProjectItem_Base::CanGetFile(void) const
{
    return IsSetFile();
}

inline
const CHugeFileProjectItem_Base::TFile& CHugeFileProjectItem_Base::GetFile(void) const
{
    if (!CanGetFile()) {
        ThrowUnassigned(0);
    }
    return m_File;
}

inline
void CHugeFileProjectItem_Base::SetFile(const CHugeFileProjectItem_Base::TFile& value)
{
    m_File = value;
    m_set_State[0] |= 0x3;
}

inline
void CHugeFileProjectItem_Base::SetFile(CHugeFileProjectItem_Base::TFile&& value)
{
    m_File = std::forward<CHugeFileProjectItem_Base::TFile>(value);
    m_set_State[0] |= 0x3;
}

inline
CHugeFileProjectItem_Base::TFile& CHugeFileProjectItem_Base::SetFile(void)
{
#ifdef _DEBUG
    if (!IsSetFile()) {
        m_File = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_File;
}

inline
bool CHugeFileProjectItem_Base::IsSetTmp_file(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHugeFileProjectItem_Base::CanGetTmp_file(void) const
{
    return IsSetTmp_file();
}

inline
const CHugeFileProjectItem_Base::TTmp_file& CHugeFileProjectItem_Base::GetTmp_file(void) const
{
    if (!CanGetTmp_file()) {
        ThrowUnassigned(1);
    }
    return m_Tmp_file;
}

inline
void CHugeFileProjectItem_Base::SetTmp_file(const CHugeFileProjectItem_Base::TTmp_file& value)
{
    m_Tmp_file = value;
    m_set_State[0] |= 0xc;
}

inline
void CHugeFileProjectItem_Base::SetTmp_file(CHugeFileProjectItem_Base::TTmp_file&& value)
{
    m_Tmp_file = std::forward<CHugeFileProjectItem_Base::TTmp_file>(value);
    m_set_State[0] |= 0xc;
}

inline
CHugeFileProjectItem_Base::TTmp_file& CHugeFileProjectItem_Base::SetTmp_file(void)
{
#ifdef _DEBUG
    if (!IsSetTmp_file()) {
        m_Tmp_file = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Tmp_file;
}

inline
bool CHugeFileProjectItem_Base::IsSetLoader_id(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHugeFileProjectItem_Base::CanGetLoader_id(void) const
{
    return IsSetLoader_id();
}

inline
const CHugeFileProjectItem_Base::TLoader_id& CHugeFileProjectItem_Base::GetLoader_id(void) const
{
    if (!CanGetLoader_id()) {
        ThrowUnassigned(2);
    }
    return m_Loader_id;
}

inline
void CHugeFileProjectItem_Base::SetLoader_id(const CHugeFileProjectItem_Base::TLoader_id& value)
{
    m_Loader_id = value;
    m_set_State[0] |= 0x30;
}

inline
void CHugeFileProjectItem_Base::SetLoader_id(CHugeFileProjectItem_Base::TLoader_id&& value)
{
    m_Loader_id = std::forward<CHugeFileProjectItem_Base::TLoader_id>(value);
    m_set_State[0] |= 0x30;
}

inline
CHugeFileProjectItem_Base::TLoader_id& CHugeFileProjectItem_Base::SetLoader_id(void)
{
#ifdef _DEBUG
    if (!IsSetLoader_id()) {
        m_Loader_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Loader_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_HUGEFILEPROJECTITEM_BASE_HPP
