/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Iteration_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_ITERATION_BASE_HPP
#define OBJECTS_BLASTXML2_ITERATION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// forward declarations
class CSearch;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML2_EXPORT CIteration_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CIteration_Base(void);
    // destructor
    virtual ~CIteration_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TIter_num;
    typedef CSearch TSearch;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_iter_num,
        e_search
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// iteration number (use with psiblast)
    /// mandatory
    /// typedef int TIter_num
    ///  Check whether the Iter_num data member has been assigned a value.
    bool IsSetIter_num(void) const;
    /// Check whether it is safe or not to call GetIter_num method.
    bool CanGetIter_num(void) const;
    void ResetIter_num(void);
    TIter_num GetIter_num(void) const;
    void SetIter_num(TIter_num value);
    TIter_num& SetIter_num(void);

    /// mandatory
    /// typedef CSearch TSearch
    ///  Check whether the Search data member has been assigned a value.
    bool IsSetSearch(void) const;
    /// Check whether it is safe or not to call GetSearch method.
    bool CanGetSearch(void) const;
    void ResetSearch(void);
    const TSearch& GetSearch(void) const;
    void SetSearch(TSearch& value);
    TSearch& SetSearch(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CIteration_Base(const CIteration_Base&);
    CIteration_Base& operator=(const CIteration_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Iter_num;
    CRef< TSearch > m_Search;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CIteration_Base::IsSetIter_num(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CIteration_Base::CanGetIter_num(void) const
{
    return IsSetIter_num();
}

inline
void CIteration_Base::ResetIter_num(void)
{
    m_Iter_num = 0;
    m_set_State[0] &= ~0x3;
}

inline
CIteration_Base::TIter_num CIteration_Base::GetIter_num(void) const
{
    if (!CanGetIter_num()) {
        ThrowUnassigned(0);
    }
    return m_Iter_num;
}

inline
void CIteration_Base::SetIter_num(CIteration_Base::TIter_num value)
{
    m_Iter_num = value;
    m_set_State[0] |= 0x3;
}

inline
CIteration_Base::TIter_num& CIteration_Base::SetIter_num(void)
{
#ifdef _DEBUG
    if (!IsSetIter_num()) {
        memset(&m_Iter_num,UnassignedByte(),sizeof(m_Iter_num));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Iter_num;
}

inline
bool CIteration_Base::IsSetSearch(void) const
{
    return m_Search.NotEmpty();
}

inline
bool CIteration_Base::CanGetSearch(void) const
{
    return true;
}

inline
const CIteration_Base::TSearch& CIteration_Base::GetSearch(void) const
{
    if ( !m_Search ) {
        const_cast<CIteration_Base*>(this)->ResetSearch();
    }
    return (*m_Search);
}

inline
CIteration_Base::TSearch& CIteration_Base::SetSearch(void)
{
    if ( !m_Search ) {
        ResetSearch();
    }
    return (*m_Search);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_ITERATION_BASE_HPP
