/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_get_reque_info_reply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST_GET_REQUE_INFO_REPLY_BASE_HPP
#define OBJECTS_BLAST_BLAST_GET_REQUE_INFO_REPLY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_database;
class CBlast4_parameters;
class CBlast4_queries;
class CBlast4_subject;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_get_request_info_reply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_get_request_info_reply_Base(void);
    // destructor
    virtual ~CBlast4_get_request_info_reply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBlast4_database TDatabase;
    typedef string TProgram;
    typedef string TService;
    typedef string TCreated_by;
    typedef CBlast4_queries TQueries;
    typedef CBlast4_parameters TAlgorithm_options;
    typedef CBlast4_parameters TProgram_options;
    typedef CBlast4_parameters TFormat_options;
    typedef CBlast4_subject TSubjects;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_database,
        e_program,
        e_service,
        e_created_by,
        e_queries,
        e_algorithm_options,
        e_program_options,
        e_format_options,
        e_subjects
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CBlast4_database TDatabase
    ///  Check whether the Database data member has been assigned a value.
    bool IsSetDatabase(void) const;
    /// Check whether it is safe or not to call GetDatabase method.
    bool CanGetDatabase(void) const;
    void ResetDatabase(void);
    const TDatabase& GetDatabase(void) const;
    void SetDatabase(TDatabase& value);
    TDatabase& SetDatabase(void);

    /// mandatory
    /// typedef string TProgram
    ///  Check whether the Program data member has been assigned a value.
    bool IsSetProgram(void) const;
    /// Check whether it is safe or not to call GetProgram method.
    bool CanGetProgram(void) const;
    void ResetProgram(void);
    const TProgram& GetProgram(void) const;
    void SetProgram(const TProgram& value);
    void SetProgram(TProgram&& value);
    TProgram& SetProgram(void);

    /// mandatory
    /// typedef string TService
    ///  Check whether the Service data member has been assigned a value.
    bool IsSetService(void) const;
    /// Check whether it is safe or not to call GetService method.
    bool CanGetService(void) const;
    void ResetService(void);
    const TService& GetService(void) const;
    void SetService(const TService& value);
    void SetService(TService&& value);
    TService& SetService(void);

    /// mandatory
    /// typedef string TCreated_by
    ///  Check whether the Created_by data member has been assigned a value.
    bool IsSetCreated_by(void) const;
    /// Check whether it is safe or not to call GetCreated_by method.
    bool CanGetCreated_by(void) const;
    void ResetCreated_by(void);
    const TCreated_by& GetCreated_by(void) const;
    void SetCreated_by(const TCreated_by& value);
    void SetCreated_by(TCreated_by&& value);
    TCreated_by& SetCreated_by(void);

    /// mandatory
    /// typedef CBlast4_queries TQueries
    ///  Check whether the Queries data member has been assigned a value.
    bool IsSetQueries(void) const;
    /// Check whether it is safe or not to call GetQueries method.
    bool CanGetQueries(void) const;
    void ResetQueries(void);
    const TQueries& GetQueries(void) const;
    void SetQueries(TQueries& value);
    TQueries& SetQueries(void);

    /// mandatory
    /// typedef CBlast4_parameters TAlgorithm_options
    ///  Check whether the Algorithm_options data member has been assigned a value.
    bool IsSetAlgorithm_options(void) const;
    /// Check whether it is safe or not to call GetAlgorithm_options method.
    bool CanGetAlgorithm_options(void) const;
    void ResetAlgorithm_options(void);
    const TAlgorithm_options& GetAlgorithm_options(void) const;
    void SetAlgorithm_options(TAlgorithm_options& value);
    TAlgorithm_options& SetAlgorithm_options(void);

    /// mandatory
    /// typedef CBlast4_parameters TProgram_options
    ///  Check whether the Program_options data member has been assigned a value.
    bool IsSetProgram_options(void) const;
    /// Check whether it is safe or not to call GetProgram_options method.
    bool CanGetProgram_options(void) const;
    void ResetProgram_options(void);
    const TProgram_options& GetProgram_options(void) const;
    void SetProgram_options(TProgram_options& value);
    TProgram_options& SetProgram_options(void);

    /// optional
    /// typedef CBlast4_parameters TFormat_options
    ///  Check whether the Format_options data member has been assigned a value.
    bool IsSetFormat_options(void) const;
    /// Check whether it is safe or not to call GetFormat_options method.
    bool CanGetFormat_options(void) const;
    void ResetFormat_options(void);
    const TFormat_options& GetFormat_options(void) const;
    void SetFormat_options(TFormat_options& value);
    TFormat_options& SetFormat_options(void);

    /// optional
    /// typedef CBlast4_subject TSubjects
    ///  Check whether the Subjects data member has been assigned a value.
    bool IsSetSubjects(void) const;
    /// Check whether it is safe or not to call GetSubjects method.
    bool CanGetSubjects(void) const;
    void ResetSubjects(void);
    const TSubjects& GetSubjects(void) const;
    void SetSubjects(TSubjects& value);
    TSubjects& SetSubjects(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_get_request_info_reply_Base(const CBlast4_get_request_info_reply_Base&);
    CBlast4_get_request_info_reply_Base& operator=(const CBlast4_get_request_info_reply_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDatabase > m_Database;
    string m_Program;
    string m_Service;
    string m_Created_by;
    CRef< TQueries > m_Queries;
    CRef< TAlgorithm_options > m_Algorithm_options;
    CRef< TProgram_options > m_Program_options;
    CRef< TFormat_options > m_Format_options;
    CRef< TSubjects > m_Subjects;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_get_request_info_reply_Base::IsSetDatabase(void) const
{
    return m_Database.NotEmpty();
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetDatabase(void) const
{
    return true;
}

inline
const CBlast4_get_request_info_reply_Base::TDatabase& CBlast4_get_request_info_reply_Base::GetDatabase(void) const
{
    if ( !m_Database ) {
        const_cast<CBlast4_get_request_info_reply_Base*>(this)->ResetDatabase();
    }
    return (*m_Database);
}

inline
CBlast4_get_request_info_reply_Base::TDatabase& CBlast4_get_request_info_reply_Base::SetDatabase(void)
{
    if ( !m_Database ) {
        ResetDatabase();
    }
    return (*m_Database);
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetProgram(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetProgram(void) const
{
    return IsSetProgram();
}

inline
const CBlast4_get_request_info_reply_Base::TProgram& CBlast4_get_request_info_reply_Base::GetProgram(void) const
{
    if (!CanGetProgram()) {
        ThrowUnassigned(1);
    }
    return m_Program;
}

inline
void CBlast4_get_request_info_reply_Base::SetProgram(const CBlast4_get_request_info_reply_Base::TProgram& value)
{
    m_Program = value;
    m_set_State[0] |= 0xc;
}

inline
void CBlast4_get_request_info_reply_Base::SetProgram(CBlast4_get_request_info_reply_Base::TProgram&& value)
{
    m_Program = std::forward<CBlast4_get_request_info_reply_Base::TProgram>(value);
    m_set_State[0] |= 0xc;
}

inline
CBlast4_get_request_info_reply_Base::TProgram& CBlast4_get_request_info_reply_Base::SetProgram(void)
{
#ifdef _DEBUG
    if (!IsSetProgram()) {
        m_Program = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Program;
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetService(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetService(void) const
{
    return IsSetService();
}

inline
const CBlast4_get_request_info_reply_Base::TService& CBlast4_get_request_info_reply_Base::GetService(void) const
{
    if (!CanGetService()) {
        ThrowUnassigned(2);
    }
    return m_Service;
}

inline
void CBlast4_get_request_info_reply_Base::SetService(const CBlast4_get_request_info_reply_Base::TService& value)
{
    m_Service = value;
    m_set_State[0] |= 0x30;
}

inline
void CBlast4_get_request_info_reply_Base::SetService(CBlast4_get_request_info_reply_Base::TService&& value)
{
    m_Service = std::forward<CBlast4_get_request_info_reply_Base::TService>(value);
    m_set_State[0] |= 0x30;
}

inline
CBlast4_get_request_info_reply_Base::TService& CBlast4_get_request_info_reply_Base::SetService(void)
{
#ifdef _DEBUG
    if (!IsSetService()) {
        m_Service = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Service;
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetCreated_by(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetCreated_by(void) const
{
    return IsSetCreated_by();
}

inline
const CBlast4_get_request_info_reply_Base::TCreated_by& CBlast4_get_request_info_reply_Base::GetCreated_by(void) const
{
    if (!CanGetCreated_by()) {
        ThrowUnassigned(3);
    }
    return m_Created_by;
}

inline
void CBlast4_get_request_info_reply_Base::SetCreated_by(const CBlast4_get_request_info_reply_Base::TCreated_by& value)
{
    m_Created_by = value;
    m_set_State[0] |= 0xc0;
}

inline
void CBlast4_get_request_info_reply_Base::SetCreated_by(CBlast4_get_request_info_reply_Base::TCreated_by&& value)
{
    m_Created_by = std::forward<CBlast4_get_request_info_reply_Base::TCreated_by>(value);
    m_set_State[0] |= 0xc0;
}

inline
CBlast4_get_request_info_reply_Base::TCreated_by& CBlast4_get_request_info_reply_Base::SetCreated_by(void)
{
#ifdef _DEBUG
    if (!IsSetCreated_by()) {
        m_Created_by = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Created_by;
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetQueries(void) const
{
    return m_Queries.NotEmpty();
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetQueries(void) const
{
    return true;
}

inline
const CBlast4_get_request_info_reply_Base::TQueries& CBlast4_get_request_info_reply_Base::GetQueries(void) const
{
    if ( !m_Queries ) {
        const_cast<CBlast4_get_request_info_reply_Base*>(this)->ResetQueries();
    }
    return (*m_Queries);
}

inline
CBlast4_get_request_info_reply_Base::TQueries& CBlast4_get_request_info_reply_Base::SetQueries(void)
{
    if ( !m_Queries ) {
        ResetQueries();
    }
    return (*m_Queries);
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetAlgorithm_options(void) const
{
    return m_Algorithm_options.NotEmpty();
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetAlgorithm_options(void) const
{
    return true;
}

inline
const CBlast4_get_request_info_reply_Base::TAlgorithm_options& CBlast4_get_request_info_reply_Base::GetAlgorithm_options(void) const
{
    if ( !m_Algorithm_options ) {
        const_cast<CBlast4_get_request_info_reply_Base*>(this)->ResetAlgorithm_options();
    }
    return (*m_Algorithm_options);
}

inline
CBlast4_get_request_info_reply_Base::TAlgorithm_options& CBlast4_get_request_info_reply_Base::SetAlgorithm_options(void)
{
    if ( !m_Algorithm_options ) {
        ResetAlgorithm_options();
    }
    return (*m_Algorithm_options);
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetProgram_options(void) const
{
    return m_Program_options.NotEmpty();
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetProgram_options(void) const
{
    return true;
}

inline
const CBlast4_get_request_info_reply_Base::TProgram_options& CBlast4_get_request_info_reply_Base::GetProgram_options(void) const
{
    if ( !m_Program_options ) {
        const_cast<CBlast4_get_request_info_reply_Base*>(this)->ResetProgram_options();
    }
    return (*m_Program_options);
}

inline
CBlast4_get_request_info_reply_Base::TProgram_options& CBlast4_get_request_info_reply_Base::SetProgram_options(void)
{
    if ( !m_Program_options ) {
        ResetProgram_options();
    }
    return (*m_Program_options);
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetFormat_options(void) const
{
    return m_Format_options.NotEmpty();
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetFormat_options(void) const
{
    return IsSetFormat_options();
}

inline
const CBlast4_get_request_info_reply_Base::TFormat_options& CBlast4_get_request_info_reply_Base::GetFormat_options(void) const
{
    if (!CanGetFormat_options()) {
        ThrowUnassigned(7);
    }
    return (*m_Format_options);
}

inline
bool CBlast4_get_request_info_reply_Base::IsSetSubjects(void) const
{
    return m_Subjects.NotEmpty();
}

inline
bool CBlast4_get_request_info_reply_Base::CanGetSubjects(void) const
{
    return IsSetSubjects();
}

inline
const CBlast4_get_request_info_reply_Base::TSubjects& CBlast4_get_request_info_reply_Base::GetSubjects(void) const
{
    if (!CanGetSubjects()) {
        ThrowUnassigned(8);
    }
    return (*m_Subjects);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST_GET_REQUE_INFO_REPLY_BASE_HPP
