/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_get_queries_reply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_GET_QUERIES_REPLY_BASE_HPP
#define OBJECTS_BLAST_BLAST4_GET_QUERIES_REPLY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_queries;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_get_queries_reply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_get_queries_reply_Base(void);
    // destructor
    virtual ~CBlast4_get_queries_reply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBlast4_queries TQueries;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_queries
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CBlast4_queries TQueries
    ///  Check whether the Queries data member has been assigned a value.
    bool IsSetQueries(void) const;
    /// Check whether it is safe or not to call GetQueries method.
    bool CanGetQueries(void) const;
    void ResetQueries(void);
    const TQueries& GetQueries(void) const;
    void SetQueries(TQueries& value);
    TQueries& SetQueries(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_get_queries_reply_Base(const CBlast4_get_queries_reply_Base&);
    CBlast4_get_queries_reply_Base& operator=(const CBlast4_get_queries_reply_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TQueries > m_Queries;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_get_queries_reply_Base::IsSetQueries(void) const
{
    return m_Queries.NotEmpty();
}

inline
bool CBlast4_get_queries_reply_Base::CanGetQueries(void) const
{
    return true;
}

inline
const CBlast4_get_queries_reply_Base::TQueries& CBlast4_get_queries_reply_Base::GetQueries(void) const
{
    if ( !m_Queries ) {
        const_cast<CBlast4_get_queries_reply_Base*>(this)->ResetQueries();
    }
    return (*m_Queries);
}

inline
CBlast4_get_queries_reply_Base::TQueries& CBlast4_get_queries_reply_Base::SetQueries(void)
{
    if ( !m_Queries ) {
        ResetQueries();
    }
    return (*m_Queries);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_GET_QUERIES_REPLY_BASE_HPP
